<?php
/**
 * Display footer information
 *
 * @package Hasium
 */
global $hasium_options;
?>
<div class="footer-contact pt-30">
	<div class="f-logo">
		<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" >
			<?php $custom_logo_id = get_theme_mod('custom_logo');
			$custom_logo_image = wp_get_attachment_image_src( $custom_logo_id , 'full');
			?>
			<img src="<?php echo esc_url($custom_logo_image[0]); ?>" alt=""/>
		</a>
	</div>
	<div class="f-info pt-40">
		<p class="mb-30"><?php echo esc_html($hasium_options['footer_info_contact_address']);?></p>
		<span><?php echo esc_html($hasium_options['footer_info_contact_email']);?></span>
		<span><?php echo esc_html($hasium_options['footer_info_contact_phone']);?></span>
	</div>
</div> <!-- footer contact -->