<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package hasium
 */

if ( ! is_active_sidebar( 'footer-sidebar-1' ) &&
    ! is_active_sidebar( 'footer-sidebar-2' ) &&
    ! is_active_sidebar( 'footer-sidebar-3' ) ) {
    return;
}
?>

<div class="col-lg-3 col-md-6 col-sm-6 order-sm-0 order-lg-0">
    <?php if ( is_active_sidebar( 'footer-sidebar-1') ) : ?>
        <div class="f-logo">
            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" >
                <?php $custom_logo_id = get_theme_mod('custom_logo');
                $custom_logo_image = wp_get_attachment_image_src( $custom_logo_id , 'full');
                ?>
                <img src="<?php echo esc_url($custom_logo_image[0]); ?>" alt="" />
            </a>
        </div>
        <?php dynamic_sidebar( 'footer-sidebar-1' ); ?>
    <?php endif; ?>
</div>
<div class="col-lg-3 col-md-6 col-sm-6">
    <?php if ( is_active_sidebar( 'footer-sidebar-2') ) : ?>
        <?php dynamic_sidebar( 'footer-sidebar-2' ); ?>
    <?php endif; ?>
</div>
<div class="col-lg-3 col-md-6 col-sm-6">
    <?php if ( is_active_sidebar( 'footer-sidebar-3') ) : ?>
        <?php dynamic_sidebar( 'footer-sidebar-3' ); ?>
    <?php endif; ?>
</div>
<div class="col-lg-3 col-md-6 col-sm-6 order-sm-1 order-lg-2">
    <?php if ( is_active_sidebar( 'footer-sidebar-4') ) : ?>
        <?php dynamic_sidebar( 'footer-sidebar-4' ); ?>
    <?php endif; ?>
</div>