<?php
/**
 * Register Trending Post Section.
 *
 * @package hasium
 */

function hasium_action_trending_post() {

	register_widget( 'hasium_trending_post' );

}
add_action( 'widgets_init', 'hasium_action_trending_post' );

class hasium_trending_post extends WP_Widget{

	function __construct() {
		global $control_ops;
		$widget_ops = array(
			'classname'   => 'featured-posts',
			'description' => esc_html__( 'Add Widget to Display Trending Post.', 'hasium' )
		);
		parent::__construct( 'hasium_trending_post',esc_html__( 'HS: Trending Post', 'hasium' ), $widget_ops, $control_ops );
	}

	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array(
			'category'         	=> '',
		) );

		$category 			= isset( $instance['category'] ) ? absint( $instance['category'] ) : 0;
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>">
				<?php esc_html_e( 'Post Category:', 'hasium' ); ?>
			</label>

			<?php
			wp_dropdown_categories(array(
				'show_option_none' => '',
				'class' 		  => 'widefat',
				'show_option_all'  => esc_html__('From Recent Post','hasium'),
				'name'             => esc_attr($this->get_field_name( 'category' )),
				'selected'         => absint( $category ),
			) );
			?>
		</p>

		<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['category'] 			= absint( $new_instance['category'] );
		$instance['show_post_meta'] 	= (bool) $new_instance['show_post_meta'];

		return $instance;
	}

	function widget( $args, $instance ) {

		extract( $args );
		$category  			= isset( $instance[ 'category' ] ) ? $instance[ 'category' ] : 0;
		$featured_category  = isset( $instance[ 'featured_category' ] ) ? $instance[ 'featured_category' ] : 0;

		echo $before_widget; ?>

		<?php $slider_args = array(
			'posts_per_page' => 4,
			'post_type' => 'post',
			'post_status' => 'publish',
			'post__not_in' => get_option( 'sticky_posts' ),
		);

		if ( absint( $category ) > 0 ) {
			$slider_args['cat'] = absint( $category );
		}
		$the_query = new WP_Query( $slider_args );

		if ($the_query->have_posts()) : $count= 0; ?>
			<div class="title-bar border-bottom pt-55">
				<div class="row">
					<div class="col-lg-6 col-8">
						<div class="section-title">
							<h4><?php if ( absint( $category ) > 0 ) {echo get_cat_name($category); } ?></h4>
						</div>
					</div>
					<div class="col-lg-6 col-4">
						<div class="view-more text-right">
							<a href="#" class="view-btn"><?php echo esc_html__('View All', 'hasium'); ?></a>
						</div> <!-- view more -->
					</div>
				</div> <!-- row -->
			</div> <!-- title bar -->
			<div class="row">
			<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
				<div class="col-md-6">
				<div class="news-five pt-15">
						<?php if ( has_post_thumbnail() ){ ?>
							<div class="news-five-image mt-15">
								<?php the_post_thumbnail( 'hasium-trending-post' );?>
							</div>
						<?php } else { ?>
							<div class="news-five-image mt-15">
									<img src="<?php echo esc_url(get_template_directory_uri() );?>/assets/img/no-image-01.png);">
							</div>
						<?php } ?>
					        <div class="news-five-content mt-25">
								<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
								<div class="author-name clearfix mt-20">
									<div class="name">
										<ul>
											<li><?php the_author_link(); ?></li>
											<li><a href="#"><?php echo esc_html(get_the_time( get_option('date_format') )); ?></a></li>
										</ul>
									</div>
								</div>
							</div>
				</div> <!-- news-five -->
				</div>
			<?php endwhile; ?>
			</div> <!-- row -->
			<?php wp_reset_postdata(); ?>
		<?php endif;?>

					<?php echo $after_widget;
	}

}
?>