<?php
/**
 * Register Latest Popular Post Section.
 *
 * @package hasium
 */

function hasium_action_popular_post() {

	register_widget( 'hasium_popular_post' );

}
add_action( 'widgets_init', 'hasium_action_popular_post' );

class hasium_popular_post extends WP_Widget{

	function __construct() {
		global $control_ops;
		$widget_ops = array(
			'classname'   => 'featured-posts',
			'description' => esc_html__( 'Add Widget to Display Popular Post.', 'hasium' )
		);
		parent::__construct( 'hasium_popular_post',esc_html__( 'HS: Popular Post', 'hasium' ), $widget_ops, $control_ops );
	}

	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array(
			'category'         	=> '',
		) );

		$category 			= isset( $instance['category'] ) ? absint( $instance['category'] ) : 0;
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>">
				<?php esc_html_e( 'Post Category:', 'hasium' ); ?>
			</label>

			<?php
			wp_dropdown_categories(array(
				'show_option_none' => '',
				'class' 		  => 'widefat',
				'show_option_all'  => esc_html__('From Recent Post','hasium'),
				'name'             => esc_attr($this->get_field_name( 'category' )),
				'selected'         => absint( $category ),
			) );
			?>
		</p>

		<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['category'] 			= absint( $new_instance['category'] );
		$instance['show_post_meta'] 	= (bool) $new_instance['show_post_meta'];

		return $instance;
	}

	function widget( $args, $instance ) {

		extract( $args );
		$category  			= isset( $instance[ 'category' ] ) ? $instance[ 'category' ] : 0;
		$featured_category  = isset( $instance[ 'featured_category' ] ) ? $instance[ 'featured_category' ] : 0;

		echo $before_widget; ?>

		<?php $slider_args = array(
			'posts_per_page' => 3,
			'post_type' => 'post',
			'post_status' => 'publish',
			'post__not_in' => get_option( 'sticky_posts' ),
		);

		if ( absint( $category ) > 0 ) {
			$category_name = get_cat_name( $category );
			$category_link = get_category_link( $category );
			$slider_args['cat'] = absint( $category );
		}
		$the_query = new WP_Query( $slider_args );

		if ($the_query->have_posts()) : $count= 0; ?>
				<div class="title-bar border-bottom pt-55">
					<div class="row">
						<div class="col-lg-6 col-8">
							<div class="section-title">
								<h4><?php echo $category_name; ?></h4>
							</div>
						</div>
						<div class="col-lg-6 col-4">
							<div class="view-more text-right">
								<a href="<?php echo esc_url( $category_link ); ?>" class="view-btn"><?php echo esc_html__('View All', 'hasium'); ?></a>
							</div> <!-- view more -->
						</div>
					</div> <!-- row -->
				</div> <!-- title bar -->
				<div class="row">
					<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
				        <?php if (!$count){ ?>
					       <div class="col-lg-12">
							   <div class="news-tow mt-30">
								<?php if ( has_post_thumbnail() ){ ?>
									<div class="news-tow-image">
										<?php the_post_thumbnail( 'hasium-popular-post-main' );?>
										<span><?php if ( absint( $category ) > 0 ) {echo get_cat_name($category); } ?></span>
									</div>
								<?php } else { ?>
									<div class="news-tow-image">
										<img src="<?php echo esc_url(get_template_directory_uri() );?>/assets/img/no-image-01.png);">
									</div>
								<?php } ?>
								   <div class="news-tow-content text-center mt-25 pl-50 pr-50">
									   <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
									   <strong>By <?php the_author_link(); ?> on <a href="<?php the_permalink(); ?>"><?php echo esc_html(get_the_time( get_option('date_format') )); ?></a></strong>
									   <p class="mt-15"><?php the_excerpt(); ?></p>
									   <a class="mt-40" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'hasium' ); ?></a>
								   </div>
								   <div class="like-social-share clearfix mt-60">
									   <div class="like-comment">
										   <ul>
											   <li><a href="#"><i class="ti-heart"></i> 20 Likes</a></li>
											   <li><a href="#"><i class="ti-comment-white-oval-bubble"></i> 6 Comments</a></li>
										   </ul>
									   </div>
									   <div class="social-share">
										   <ul>
											   <li><a href="#"><i class="ti-google"></i></a></li>
											   <li><a href="#"><i class="ti-pinterest"></i></a></li>
											   <li><a href="#"><i class="ti-twitter"></i></a></li>
											   <li><a href="#"><i class="ti-friends"></i></a></li>
											   <li><a href="#"><i class="ti-paper-plane"></i></a></li>
											   <li><a href="#"><i class="ti-streaming"></i></a></li>
										   </ul>
									   </div>
								   </div>
							   </div> <!-- news-tow -->
						   </div>
				        <?php } else { ?>
					       <div class="col-md-6">
						      <div class="news-tow mt-30">
							   <?php if (has_post_thumbnail()) { ?>
								  <div class="news-tow-image">
									 <?php the_post_thumbnail('hasium-popular-post-list'); ?>
									 <span><?php if ( absint( $category ) > 0 ) {echo get_cat_name($category); } ?></span>
								  </div>
							    <?php } else { ?>
								  <div class="news-tow-image">
									 <img
										src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/no-image-01.png);">
								  </div>
							     <?php } ?>
							    <div class="news-tow-content text-center mt-25 pl-10 pr-10">
								   <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
								   <strong>By <?php the_author_link(); ?> on <a href="<?php the_permalink(); ?>"><?php echo esc_html(get_the_time( get_option('date_format') )); ?></a></strong>
								   <p class="mt-15"><?php the_excerpt(); ?></p>
								   <a class="mt-40" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'hasium' ); ?></a>
								</div>
							  </div> <!-- news-tow -->
						   </div>
						<?php } ?>

					<?php $count++; endwhile; ?>
					</div>
					<?php wp_reset_postdata(); ?>
					<?php endif; ?>

					<?php echo $after_widget;
	}

}
?>