<?php
/**
 * Register Masonry Post Section.
 *
 * @package hasium
 */

function hasium_action_masonry_post() {

	register_widget( 'hasium_masonry_post' );

}
add_action( 'widgets_init', 'hasium_action_masonry_post' );

class hasium_masonry_post extends WP_Widget{

	function __construct() {
		global $control_ops;
		$widget_ops = array(
			'classname'   => 'featured-posts',
			'description' => esc_html__( 'Add Widget to Display Masonry Post.', 'hasium' )
		);
		parent::__construct( 'hasium_masonry_post',esc_html__( 'HS: Masonry Post', 'hasium' ), $widget_ops, $control_ops );
	}

	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array(
			'category'         	=> '',
		) );

		$category 			= isset( $instance['category'] ) ? absint( $instance['category'] ) : 0;
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>">
				<?php esc_html_e( 'Post Category:', 'hasium' ); ?>
			</label>

			<?php
			wp_dropdown_categories(array(
				'show_option_none' => '',
				'class' 		  => 'widefat',
				'show_option_all'  => esc_html__('From Recent Post','hasium'),
				'name'             => esc_attr($this->get_field_name( 'category' )),
				'selected'         => absint( $category ),
			) );
			?>
		</p>

		<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['category'] 			= absint( $new_instance['category'] );
		$instance['show_post_meta'] 	= (bool) $new_instance['show_post_meta'];

		return $instance;
	}

	function widget( $args, $instance ) {

		extract( $args );
		$category  			= isset( $instance[ 'category' ] ) ? $instance[ 'category' ] : 0;
		$featured_category  = isset( $instance[ 'featured_category' ] ) ? $instance[ 'featured_category' ] : 0;

		echo $before_widget; ?>

		<?php $slider_args = array(
			'posts_per_page' => 12,
			'post_type' => 'post',
			'post_status' => 'publish',
			'post__not_in' => get_option( 'sticky_posts' ),
		);

		if ( absint( $category ) > 0 ) {
			$category_name = get_cat_name( $category );
			$category_link = get_category_link( $category );
			$slider_args['cat'] = absint( $category );
		}
		$the_query = new WP_Query( $slider_args );

		if ($the_query->have_posts()) : $count= 0; ?>
			<div class="row grid">
			<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
				<div class="col-lg-4 col-md-6 grid-item">
					<div class="single-blog mt-30 news-hidden-2">
					<?php if ( has_post_thumbnail() ){ ?>
						    <div class="blog-image">
								<?php
								$sizes = array('hasium-masonry-post-1', 'hasium-masonry-post-2', 'hasium-masonry-post-3');
								$index = array_rand($sizes);
								the_post_thumbnail($sizes[$index]);
								?>
							</div>
						<?php } else { ?>
						    <div class="blog-image">
									<img src="<?php echo esc_url(get_template_directory_uri() );?>/assets/img/no-image-01.png);">
							</div>
						<?php } ?>
						    <div class="blog-content">
								<ul>
									<li><a href="#"><?php the_date( get_option('date_format') ); ?> </a></li>
									<li><a href="<?php echo esc_url( $category_link ); ?>"><?php echo $category_name; ?></a></li>
								</ul>
								<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
								<p><?php the_excerpt(); ?></p>
								<a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'hasium' ); ?></a>
							</div>
				    </div>
				</div>
			<?php endwhile; ?>
			</div> <!-- row -->
			<?php wp_reset_postdata(); ?>
		<?php endif;?>

					<?php echo $after_widget;
	}

}
?>