<?php
/**
 * Register Featured Main Post Section.
 *
 * @package hasium
 */

function hasium_action_featured_post_main() {

	register_widget( 'hasium_featured_post_main' );

}
add_action( 'widgets_init', 'hasium_action_featured_post_main' );

class hasium_featured_post_main extends WP_Widget{

	function __construct() {
		global $control_ops;
		$widget_ops = array(
			'classname'   => 'featured-posts',
			'description' => esc_html__( 'Add Widget to Display Featured Main Post.', 'hasium' )
		);
		parent::__construct( 'hasium_featured_post_main',esc_html__( 'HS: Featured Main Post ', 'hasium' ), $widget_ops, $control_ops );
	}

	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array(
			'category'         	=> '',
		) );

		$category 			= isset( $instance['category'] ) ? absint( $instance['category'] ) : 0;
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>">
				<?php esc_html_e( 'Post Category:', 'hasium' ); ?>
			</label>

			<?php
			wp_dropdown_categories(array(
				'show_option_none' => '',
				'class' 		  => 'widefat',
				'show_option_all'  => esc_html__('From Recent Post','hasium'),
				'name'             => esc_attr($this->get_field_name( 'category' )),
				'selected'         => absint( $category ),
			) );
			?>
		</p>
		<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['category'] 			= absint( $new_instance['category'] );

		return $instance;
	}

	function widget( $args, $instance ) {

		extract( $args );
		$category  			= isset( $instance[ 'category' ] ) ? $instance[ 'category' ] : 0;
		$featured_category  = isset( $instance[ 'featured_category' ] ) ? $instance[ 'featured_category' ] : 0;

		echo $before_widget; ?>

		<?php $post_args = array(
			'posts_per_page' => 1,
			'post_type' => 'post',
			'post_status' => 'publish',
			'post__not_in' => get_option( 'sticky_posts' ),
		);

		if ( absint( $category ) > 0 ) {
			$post_args['cat'] = absint( $category );
		}
		$the_query = new WP_Query( $post_args );

		if ($the_query->have_posts()) : $count= 0; ?>
			   <div class="col-lg-8">
			     <?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
					 <div class="slider-banner-left">
				           <?php if ( has_post_thumbnail() ){ ?>
					           <div class="banner-slider-image">
						         <?php the_post_thumbnail( 'hasium-featured-post-main' );?>
					           </div>
				            <?php } else { ?>
					           <div class="banner-slider-image">
								   <img src="<?php echo esc_url(get_template_directory_uri() );?>/assets/img/no-image-01.png);">
							   </div>
						    <?php } ?>
							<div class="banner-slider-content">
								<span><?php if ( absint( $category ) > 0 ) {echo get_cat_name($category); } ?></span>
								<h3 class="mt-10"><?php the_title(); ?></h3>
								<a class="mt-15" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'hasium' ); ?></a>
							</div>
					 </div> <!-- slider banner left -->
				<?php endwhile; ?>
			   </div>
			<?php wp_reset_postdata(); ?>
		<?php endif;?>

		<?php echo $after_widget;

	}

}
?>