<?php
/**
 * The Hasium Theme Functions start here.
 *
 * @package    Hasium
 * @author     wphobby
 * @link       http://hasium.wphobby.com
 */


/**
 * Set constants
 */
if ( ! defined( 'HASIUM_THEME_DIR' ) ) {
    define( 'HASIUM_THEME_DIR', get_template_directory() );
}

if ( ! defined( 'HASIUM_THEME_VERSION' ) ) {
    define( 'HASIUM_THEME_VERSION', '1.6.5' );
}

if ( ! defined( 'WPHOBBY_STATS_URL' ) ) {
    define( 'WPHOBBY_STATS_URL', 'https://wphobby.com' );
}

/**
* Define Theme Options
*/
global $hasium_options;

/**
 * Add Kirki customizer library file
 */
require get_template_directory() . '/inc/kirki/kirki.php';

/**
 * Add Kirki options file
 */
require get_template_directory() . '/inc/customizer/kirki-customizer.php';

/**
* Setup Theme Functions.
* Enqueue styles, register widget regions, etc.
*/
require get_template_directory() . '/inc/functions/function-setup.php';
require get_template_directory() . '/inc/functions/function-template.php';
require get_template_directory() . '/inc/functions/function-admin.php';

/**
 * Admin Classes for this theme.
 */
require_once get_template_directory() . '/inc/admin/classes/class-attr.php';

/**
 *TGM Plugin Activation
 */
require get_template_directory() . '/inc/tgm-plugin-activation/class-tgm-plugin-activation.php';
require get_template_directory() . '/inc/tgm-plugin-activation/required_plugins.php';

/**
 * Load custom menu
 */
require get_template_directory().'/inc/custom-menu/custom_walker.php';


/**
 * Hasium Theme Widgets
 */
require get_template_directory() . '/inc/widgets/widget-featured-post-main.php';
require get_template_directory() . '/inc/widgets/widget-featured-post-prime.php';
require get_template_directory() . '/inc/widgets/widget-featured-post-news.php';
require get_template_directory() . '/inc/widgets/widget-featured-post-grid.php';
require get_template_directory() . '/inc/widgets/widget-latest-post.php';
require get_template_directory() . '/inc/widgets/widget-popular-post.php';
require get_template_directory() . '/inc/widgets/widget-trending-post.php';
require get_template_directory() . '/inc/widgets/widget-masonry-post.php';


?>
