<?php
/**
 * Hooking Theme Functions
 *
 * @package hasium
 */

/**
 * Hooking pre loader
 *
 */
function hasium_add_pre_loader() {
    // Show preloader if enabled.
    if ( true === get_theme_mod( 'enabled_pre_loader') ) :
        get_template_part( 'template-parts/loader/pre', 'loader' );
    endif;
}

add_action( 'hasium_before_header', 'hasium_add_pre_loader', 1 );

/**
 * Hooking post sliders
 *
 */
function hasium_add_post_slider() {
    // Show post slider if enabled.
    if ( ( is_home() || is_front_page() ) && true === get_theme_mod( 'enabled_post_slider') ) :
        get_template_part( 'template-parts/slider/post', 'slider' );
    endif;
}

add_action( 'hasium_after_header', 'hasium_add_post_slider', 1 );

/**
 * Adds the necessary template to load on footer.
 *
 */
function hasium_add_footer_extras() {

    // load search form.
    get_template_part( 'template-parts/footer/search', 'form' );

    // Load off canvas menu.
    get_template_part( 'template-parts/menu/menu', 'offcanvas' );

    // Show back to top if enabled.
    if ( true === get_theme_mod( 'enable_back_to_top', true ) ) {
        ?>
        <a href="#" class="back-to-top"><i class="ti-arrow-up"></i></a>
        <?php
    }
}
add_action( 'hasium_after_footer', 'hasium_add_footer_extras' );

/**
 * Filter to Change the Length of Excerpts
 *
 */
function hasium_excerpt_length( $length ) {
    // Don't change anything inside admin
    if ( is_admin() ) {
        return $length;
    }
    // Set excerpt length to 20 words
    return 18;
}
// "999" priority makes this run last of all the functions hooked to this filter, meaning it overrides them
add_filter( 'excerpt_length', 'hasium_excerpt_length', 999 );

/**
 *
 * Display navigation to next/previous pages when applicable
 */
function hasium_content_nav(){
    global $wp_query, $post;

    // Don't print empty markup on single pages if there's nowhere to navigate.
    if ( is_single() ) {
        $previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
        $next = get_adjacent_post( false, '', false );

        if ( ! $next && ! $previous )
            return;
    }

    if ( is_single() ) : // navigation links for single posts ?>
        <div class="next-previous">
            <div class="row">

                 <div class="col-6 col-sm-5">
                     <div class="next mt-15">
                         <?php previous_post_link( '%link', '<h6 class="meta-title"> %title </h6> <i class="ti-arrow-left"></i>'.__( "Previous Post", "hasium" ) ); ?>
                     </div>
                 </div>

                <div class="col-6 col-sm-7">
                    <div class="previous mt-15 text-right">
                        <?php next_post_link( '%link', '<h6 class="meta-title"> %title </h6> '.__( "Next Post", "hasium" ) .'<i class="ti-arrow-right"></i>'); ?>
                     </div>
                </div>

           </div><!-- .row -->
       </div><!-- .next-previous-->
<?php endif;
}

/**
 *
 * List post comments
 */
function hasium_comment( $comment, $args, $depth ) {
?>

    <li id="comment-<?php comment_ID(); ?>" <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ); ?>>

            <div class="single-comment">

                <div class="comment-image">
                    <?php echo get_avatar( $comment, 80 ); ?>
                </div><!-- .comment-image -->

                <div class="comment-post">
                    <?php sprintf( '<div class="post-title">%s</div>', get_comment_author_link() ); ?>
                    <sapn>
                        <time datetime="<?php comment_time( 'c' ); ?>">
                            <?php printf( __( '%1$s at %2$s', 'hasium' ), get_comment_date(), get_comment_time() ); ?>
                        </time>
                    </sapn>
                    <p class="mt-10"><?php comment_text(); ?></p>
                    <?php
                    comment_reply_link( array_merge( $args, array(
                        'add_below' => 'div-comment',
                        'depth'     => $depth,
                        'max_depth' => $args['max_depth'],
                        'before'    => '',
                        'after'     => '',
                    ) ) );
                    ?>
                </div><!-- .comment-post -->
            </div><!-- .single-comment -->
    </li>
    <?php
}

function hasium_move_comment_field_to_bottom( $fields ) {
    $comment_field = $fields['comment'];
    unset( $fields['comment'] );
    $fields['comment'] = $comment_field;
    return $fields;
}

add_filter( 'comment_form_fields', 'hasium_move_comment_field_to_bottom' );

function hasium_comment_form_hide_cookies_consent( $fields ) {
    unset( $fields['cookies'] );
    return $fields;
}
add_filter( 'comment_form_fields', 'hasium_comment_form_hide_cookies_consent' );

/* Tagcloud, change the font size */
function hasium_custom_tag_cloud_widget($args) {
    $args['largest'] = 10; //largest tag
    $args['smallest'] = 10; //smallest tag
    $args['unit'] = 'px'; //tag font unit
    return $args;
}
add_filter( 'widget_tag_cloud_args', 'hasium_custom_tag_cloud_widget' );

/*Hide categories from WordPress category widget*/
function hasium_exclude_widget_categories($args){
    $exclude = "1,8,14,10,15,24,17";
    $args["exclude"] = $exclude;
    return $args;
}
add_filter("widget_categories_args","hasium_exclude_widget_categories");

/* Set post count for per page */
function hasium_set_posts_per_page( $query ) {
    $count = 0;
    //Get layout_blog
    $layout_blog = 'layout-1';
    if(isset($hasium_options['layout_blog'])){
        $layout_blog = $hasium_options['layout_blog'];
    }
    if(isset($_GET['layout_blog'])){
        $layout_blog = $_GET['layout_blog'];
    }
    switch ($layout_blog){
        case "layout-3":
            $count = 9;
            break;
        case "layout-4":
            $count = 8;
            break;
    }
    if ( !is_admin() && $query->is_main_query() && $count > 0 ) {
        $query->set( 'posts_per_page', $count );
    }
}
add_action( 'pre_get_posts', 'hasium_set_posts_per_page' );

function hasium_customizer_head_styles() {
    $link_color = get_theme_mod( 'hasium_color_primary' );

    if ( $link_color != '#de7b85' ) :
        ?>
        <style type="text/css">
            .header-logo a:hover {
                color: <?php echo $link_color; ?>;
            }
            .copyright a {
                color: <?php echo $link_color; ?>;
            }
            .post-info-cat, .post-info-cat a {
                color: <?php echo $link_color; ?>;
            }
            .news-one .one-content h5 a:hover,
            .details-content .meta .tag ul li a,
            .details-content .next-previous .next a,
            .details-content .next-previous .previous a,
            .pagination .page-numbers:hover {
                color: <?php echo $link_color; ?>;
            }
        </style>
        <?php
    endif;
}
add_action( 'wp_head', 'hasium_customizer_head_styles' );

/**
 * Build list of attributes into a string and apply contextual filter on string.
 *
 * The contextual filter is of the form `hasium_attr_{context}_output`.
 *
 * @since 1.6.2
 * @credits - Genesis Theme By StudioPress.
 *
 * @param string $context    The context, to build filter name.
 * @param array  $attributes Optional. Extra attributes to merge with defaults.
 * @param array  $args       Optional. Custom data to pass to filter.
 * @return string String of HTML attributes and values.
 */
function hasium_attr( $context, $attributes = array(), $args = array() ) {
    return Hasium_Attr::get_instance()->hasium_attr( $context, $attributes, $args );
}
?>