<?php
function hasium_setup() {

    /* add woocommerce support */
    add_theme_support( 'woocommerce' );

    /* add title tag support */
    add_theme_support( 'title-tag' );

    /* load theme languages */
    load_theme_textdomain( 'hasium', get_template_directory() . '/languages' );

    /* Add default posts and comments RSS feed links to head */
    add_theme_support( 'automatic-feed-links' );

    /* Add excerpt to pages */
    add_post_type_support( 'page', 'excerpt' );

    /* Add support for post thumbnails */
    add_theme_support( 'post-thumbnails' );
    add_image_size( 'hasium-featured-post-main', 770, 500, true);
    add_image_size( 'hasium-featured-post-news', 370, 240, true);
    add_image_size( 'hasium-featured-post-prime', 570, 520, true);
    add_image_size( 'hasium-featured-post-grid', 270, 245, true);
    add_image_size( 'hasium-popular-post-main', 770, 348, true);
    add_image_size( 'hasium-popular-post-list', 370, 230, true);
    add_image_size( 'hasium-latest-post', 303, 230, true);
    add_image_size( 'hasium-trending-post', 370, 296, true);
    add_image_size( 'hasium-slider-post', 1170, 720, true);
    add_image_size( 'hasium-single-fullwidth', 1170, 560, true);
    add_image_size( 'hasium-masonry-post-1', 370, 460, true);
    add_image_size( 'hasium-masonry-post-2', 370, 200, true);
    add_image_size( 'hasium-masonry-post-3', 370, 320, true);
    add_image_size( 'hasium-layout-1', 303, 280, true);
    add_image_size( 'hasium-layout-2', 450, 270, true);
    add_image_size( 'hasium-layout-3', 303,200, true);
    add_image_size( 'hasium-layout-4', 303,200, true);






    /* Add support for Selective Widget refresh */
    add_theme_support( 'customize-selective-refresh-widgets' );

    /** Add sensei support */
    add_theme_support( 'sensei' );

    /* Add support for HTML5 */
    add_theme_support( 'html5', array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
        'widgets',
    ) );

    /**
     * Add support for core custom logo.
     *
     * @link https://codex.wordpress.org/Theme_Logo
     */
    add_theme_support( 'custom-logo', array(
        'height'      => 250,
        'width'       => 250,
        'flex-width'  => true,
        'flex-height' => true,
    ) );

    // Set up the WordPress core custom background feature.
    add_theme_support( 'custom-background', apply_filters( 'hasium_custom_background_args', array(
        'default-color' => 'ffffff',
        'default-image' => '',
    ) ) );

    add_editor_style();

    /*  Register menus. */
    register_nav_menus( array(
        'primary' => __( 'Main Menu', 'hasium' ),
        'primary_mobile' => __( 'Main Menu - Mobile', 'hasium' ),
        'off_canvas' => __( 'Off Canvas Menu', 'hasium' ),
        'footer' => __( 'Footer Menu', 'hasium' ),
    ) );
}
add_action( 'after_setup_theme', 'hasium_setup' );

/* Setup Theme Widgets */
function hasium_widgets_init() {

    //Sidebar Widget
    register_sidebar( array(
        'name'          => esc_html__( 'Sidebar', 'hasium' ),
        'id'            => 'sidebar-1',
        'description'   => esc_html__( 'Add widgets here.', 'hasium' ),
        'before_widget' => '<div class="col-lg-12 col-md-6"><section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section></div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    //Featured Post News
    register_sidebar( array(
        'name'          => esc_html__( 'Featured Post News', 'hasium' ),
        'id'            => 'featured-post-news',
        'description'   => esc_html__( 'News Widget Below Header Section.', 'hasium' ),
        'before_widget' => '',
        'after_widget'  => '',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    //Featured Post Grid
    register_sidebar( array(
        'name'          => esc_html__( 'Featured Post Grid', 'hasium' ),
        'id'            => 'featured-post-grid',
        'description'   => esc_html__( 'Grid Widget Below Header Section.', 'hasium' ),
        'before_widget' => '',
        'after_widget'  => '',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    //Popular Latest Post News
    register_sidebar( array(
        'name'          => esc_html__( 'Popular Latest Post News', 'hasium' ),
        'id'            => 'popular-latest-post-news',
        'description'   => esc_html__( 'News Widget Below Post News.', 'hasium' ),
        'before_widget' => '',
        'after_widget'  => '',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    //Popular Latest Post Grid
    register_sidebar( array(
        'name'          => esc_html__( 'Popular Latest Post Grid', 'hasium' ),
        'id'            => 'popular-latest-post-grid',
        'description'   => esc_html__( 'News Widget Below Post News.', 'hasium' ),
        'before_widget' => '',
        'after_widget'  => '',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    //Masonry Post
    register_sidebar( array(
        'name'          => esc_html__( 'Masonry Post', 'hasium' ),
        'id'            => 'masonry-post',
        'description'   => esc_html__( 'Masonry Post.', 'hasium' ),
        'before_widget' => '',
        'after_widget'  => '',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    //Footer widget area 1
    register_sidebar( array(
        'name'          => esc_html__( 'Footer 1', 'hasium' ),
        'id'            => 'footer-sidebar-1',
        'description'   => esc_html__( 'Add widgets here to show on footer 1.', 'hasium' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    //Footer widget area 2
    register_sidebar( array(
        'name'          => esc_html__( 'Footer 2', 'hasium' ),
        'id'            => 'footer-sidebar-2',
        'description'   => esc_html__( 'Add widgets here to show on footer 2.', 'hasium' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    //Footer widget area 3
    register_sidebar( array(
        'name'          => esc_html__( 'Footer 3', 'hasium' ),
        'id'            => 'footer-sidebar-3',
        'description'   => esc_html__( 'Add widgets here to show on footer 3.', 'hasium' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    //Footer widget area 4
    register_sidebar( array(
        'name'          => esc_html__( 'Footer 4', 'hasium' ),
        'id'            => 'footer-sidebar-4',
        'description'   => esc_html__( 'Add widgets here to show on footer 4.', 'hasium' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
}
add_action( 'widgets_init', 'hasium_widgets_init' );


/**
 * Setup hasium Styles and Scripts
 */
function hasium_scripts() {
    $uri = get_template_directory_uri();
    $theme = wp_get_theme( get_template() );
    $version = $theme->get( 'Version' );

    // Enqueue theme styles  (Loaded on request)

    wp_enqueue_style('hasium-bootstrap', $uri . '/assets/css/bootstrap.min.css', NULL, $version, 'all' );
    wp_enqueue_style('hasium-font-awesome', $uri . '/assets/css/font-awesome.min.css', NULL, $version, 'all' );
    wp_enqueue_style('hasium-themify-icons', $uri . '/assets/css/themify-icons.css', NULL, $version, 'all' );
    wp_enqueue_style('hasium-animate', $uri . '/assets/css/animate.css', NULL, $version, 'all' );
    wp_enqueue_style('hasium-slick', $uri . '/assets/css/slick.css', NULL, $version, 'all' );
    wp_enqueue_style('hasium-meanmenu', $uri . '/assets/css/meanmenu.css', NULL, $version, 'all' );
    wp_enqueue_style('hasium-default', $uri . '/assets/css/default.css', NULL, $version, 'all' );
    wp_enqueue_style('hasium-style', $uri . '/assets/css/style.css', NULL, $version, 'all' );
    wp_enqueue_style('hasium-responsive', $uri . '/assets/css/responsive.css', NULL, $version, 'all' );


    // Enqueue theme scripts
    wp_enqueue_script( 'hasium-bootstrap-js', $uri .'/assets/js/bootstrap.js', array('jquery'), '4.2.1', false );
    wp_enqueue_script( 'hasium-slick-js', $uri .'/assets/js/slick.js', array('jquery'), '', false );
    wp_enqueue_script( 'hasium-meanmenu-js', $uri .'/assets/js/jquery.meanmenu.js', array('jquery'), '', false );
    wp_enqueue_script( 'hasium-isotope-js', $uri .'/assets/js/isotope.pkgd.js', array('imagesloaded'), '3.0.6', false );
    wp_enqueue_script( 'hasium-main-js', $uri .'/assets/js/main.js', array('jquery'), '', false );

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }

}
add_action( 'wp_enqueue_scripts', 'hasium_scripts', 100 );

/**
 * Load theme options
 */
function hasium_customizer_styles(){

    global $hasium_options;

    /* Header Style */
    $hasium_options['header_style'] 							    = hasium_theme_option('header_style', 'site-header-center');

    /* Social Media */
    $hasium_options['social_icons'] 							    = hasium_theme_option('social_icons_lists', array());


    /* Blog Layout */
    $hasium_options['layout_blog'] 							    = hasium_theme_option('layout_blog', 'layout-1');
    $hasium_options['enable_blog_sidebar'] 					    = hasium_theme_option('enable_blog_sidebar', 1);

    /* Single Post */
    $hasium_options['single_post_layout'] 					    = hasium_theme_option('single_post_layout', 'full-width');
    $hasium_options['single_enable_author_box'] 					    = hasium_theme_option('single_enable_author_box', true);

    /* Breadcrumbs */
    $hasium_options['enable_breadcrumbs'] 						= hasium_theme_option('enable_breadcrumbs', 1);

    /* Footer */
    $hasium_options['enable_scroll_to_top'] = hasium_theme_option('enable_scroll_to_top', true);
    $hasium_options['footer_info_background'] = hasium_theme_option('footer_info_background', 'white');
    $hasium_options['footer_info_contact_phone'] = hasium_theme_option('footer_info_contact_phone', '');
    $hasium_options['footer_info_contact_email'] = hasium_theme_option('footer_info_contact_email', '');
    $hasium_options['footer_info_contact_address'] = hasium_theme_option('footer_info_contact_address','');

    /* Post Slider */
    $hasium_options['enabled_post_slider'] = hasium_theme_option('enabled_post_slider', true);

}
add_action( 'wp_loaded', 'hasium_customizer_styles', 99 );


/**
 * Get theme options from theme settings
 */
if ( ! function_exists ('hasium_theme_option') ) {
    function hasium_theme_option( $name, $default = "" ) {
        return get_theme_mod( $name, $default );
    } //function
}

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) ) {
    $content_width = 1200;
}

function hasium_switch_theme() {
    set_transient( '_hasium_activation_redirect', 1 );
}
add_action( 'after_switch_theme', 'hasium_switch_theme' );


function hasium_admin_redirects() {
    $page_url = 'admin.php?page=hasium-admin-menu';
    if ( ! get_transient( '_hasium_activation_redirect' ) ) {
        return;
    }
    delete_transient( '_hasium_activation_redirect' );
    wp_safe_redirect( admin_url( $page_url ) );
    exit;
}
add_action( 'admin_init', 'hasium_admin_redirects' );
