<?php
if ( ! function_exists( 'has_fs' ) ) {
    // Create a helper function for easy SDK access.
    function has_fs() {
        global $has_fs;

        if ( ! isset( $has_fs ) ) {
            // Include Freemius SDK.
            require_once get_template_directory() . '/freemius/start.php';

            $has_fs = fs_dynamic_init( array(
                'id'                  => '9156',
                'slug'                => 'hasium',
                'type'                => 'theme',
                'public_key'          => 'pk_caf6b024918ba18d5145d03491453',
                'is_premium'          => false,
                // If your theme is a serviceware, set this option to false.
                'has_premium_version' => true,
                'has_addons'          => false,
                'has_paid_plans'      => true,
                'menu'                => array(
                    'slug'           => 'hasium-admin-menu',
                    'support'        => false,
                    'parent'         => array(
                        'slug' => 'themes.php',
                    ),
                ),
                // Set the SDK to work in a sandbox mode (for development & testing).
                // IMPORTANT: MAKE SURE TO REMOVE SECRET KEY BEFORE DEPLOYMENT.
                'secret_key'          => 'undefined',
            ) );
        }

        return $has_fs;
    }

    // Init Freemius.
    has_fs();
    // Signal that SDK was initiated.
    do_action( 'has_fs_loaded' );
}