<?php
/**
 * Customizer option for typography
 *
 * @package hasium
 */

// Body typography.
Kirki::add_field(
	'hasium_config', array(
		'type'     => 'typography',
		'settings' => 'hasium_typography_body',
		'label'    => esc_attr__( 'Body', 'hasium' ),
		'section'  => 'hasium_section_typography',
		'default'  => array(
			'font-family' => 'HK Nova',
			'variant'     => 'regular',
		),
		'output'   => array(
			array(
				'element' => 'body',
			),
		),
		'choices'  => array(
			'fonts'   => array(
				'google' => array(
					'HK Nova',
					'Roboto',
					'Open Sans',
				),
			),
			'variant' => array(
				'400',
				'700',
			),
		),
	)
);

// Heading.
Kirki::add_field(
	'hasium_config', array(
		'type'     => 'typography',
		'settings' => 'hasium_typography_heading',
		'label'    => esc_attr__( 'Heading', 'hasium' ),
		'section'  => 'hasium_section_typography',
		'default'  => array(
			'font-family' => '',
			'variant'     => '700',
		),
		'output'   => array(
			array(
				'element' => array( 'h1, h2, h3, h4, h5, h6' ),
			),
		),
		'choices'  => array(
			'fonts'   => array(
				'google' => array(
					'Catamaran',
					'Playfair Display',
				),
			),
			'variant' => array(
				'700',
			),
		),
	)
);
