<?php
/**
 * Social Media Options
 *
 * @package hasium
 */

// Option to add the social links via repeater field.
Kirki::add_field( 'hasium_config', array(
	'type'        => 'repeater',
	'label'       => esc_html__( 'Add Social Profile', 'hasium' ),
	'description' => esc_html__( 'Drag & Drop items to re-arrange the order', 'hasium' ),
	'section'     => 'hasium_section_social',
	'settings'    => 'social_icons_lists',
	'row_label'   => array(
		'type'  => 'field',
		'value' => esc_html__( 'Social Profile', 'hasium' ),
		'field' => 'social_icon',
	),
	'fields'      => array(
		'social_icon' => array(
			'label'   => esc_html__( 'Social Icon', 'hasium' ),
			'type'    => 'select',
			'default' => 'hasium-icon-instagram',
			'choices' => array(
				'hasium-icon-instagram'     => esc_html__( 'Instagram', 'hasium' ),
				'hasium-icon-facebook'     => esc_html__( 'Facebook', 'hasium' ),
				'hasium-icon-twitter'     => esc_html__( 'Twitter', 'hasium' ),
				'hasium-icon-pinterest'     => esc_html__( 'Pinterest', 'hasium' ),
				'hasium-icon-vimeo'     => esc_html__( 'Vimeo', 'hasium' ),
				'hasium-icon-dribbble'     => esc_html__( 'Dribbble', 'hasium' ),
				'hasium-icon-spotify'     => esc_html__( 'Spotify', 'hasium' ),
			),
		),
		'social_url'  => array(
			'type'    => 'text',
			'label'   => esc_html__( 'Social Link URL', 'hasium' ),
			'default' => '',
		),
	),
) );
