<?php
/**
 * Kirki Customizer Options File
 *
 * @package Hasium
 */

/**
 * Configuration for Kirki Framework
 */
function hasium_kirki_configuration() {
	return array(
		'url_path' => get_template_directory_uri() . '/inc/kirki/',
	);
}

add_filter( 'kirki/config', 'hasium_kirki_configuration' );

/**
 * Hasium Kirki Config
 */
Kirki::add_config( 'hasium_config', array(
	'capability'  => 'edit_theme_options',
	'option_type' => 'theme_mod',
) );

/**
 * Hasium Kirki Theme Options Panel
 */
Kirki::add_panel( 'hasium_theme_options', array(
	'priority' => 10,
	'title'    => esc_html__( 'Theme Options', 'hasium' ),
) );


/**
 * Hasium Header Options section
 */
Kirki::add_section( 'hasium_section_header', array(
	'title'    => esc_html__( 'Header', 'hasium' ),
	'panel'    => 'hasium_theme_options',
	'priority' => 25,
) );

/**
 * Hasium Layout Options section
 */
Kirki::add_section( 'hasium_section_layout', array(
	'title'    => esc_html__( 'Layout', 'hasium' ),
	'panel'    => 'hasium_theme_options',
	'priority' => 25,
) );


/**
 * Hasium Footer Options section
 */
Kirki::add_section( 'hasium_section_footer', array(
	'title'    => esc_html__( 'Footer', 'hasium' ),
	'panel'    => 'hasium_theme_options',
	'priority' => 25,
) );

/**
 * Hasium Preloader Options section
 */
Kirki::add_section( 'hasium_section_loader', array(
	'title'    => esc_html__( 'Loader', 'hasium' ),
	'panel'    => 'hasium_theme_options',
	'priority' => 25,
) );

/**
 * Hasium Post Slider Options section
 */
Kirki::add_section( 'hasium_section_post_slider', array(
	'title'    => esc_html__( 'Post Slider', 'hasium' ),
	'panel'    => 'hasium_theme_options',
	'priority' => 25,
) );

/**
 * Hasium Breadcrumb Options section
 */
Kirki::add_section( 'hasium_section_breadcrumb', array(
	'title'    => esc_html__( 'Breadcrumb', 'hasium' ),
	'panel'    => 'hasium_theme_options',
	'priority' => 25,
) );

/**
 * Single Post Options section
 */
Kirki::add_section( 'hasium_section_single', array(
	'title'    => esc_html__( 'Single Post', 'hasium' ),
	'panel'    => 'hasium_theme_options',
	'priority' => 25,
) );

/**
 * Social Options section
 */
Kirki::add_section( 'hasium_section_social', array(
	'title'    => esc_html__( 'Social', 'hasium' ),
	'panel'    => 'hasium_theme_options',
	'priority' => 25,
) );

/**
 * Color Options section
 */
Kirki::add_section( 'hasium_section_color', array(
	'title'    => esc_html__( 'Color', 'hasium' ),
	'panel'    => 'hasium_theme_options',
	'priority' => 25,
) );

/**
 * Typography Options section
 */
Kirki::add_section( 'hasium_section_typography', array(
	'title'    => esc_html__( 'Typography', 'hasium' ),
	'panel'    => 'hasium_theme_options',
	'priority' => 25,
) );


/**
 * Add the required kirki customizer options files
 */

require get_template_directory() . '/inc/customizer/options/options-layout.php';
require get_template_directory() . '/inc/customizer/options/options-header.php';
require get_template_directory() . '/inc/customizer/options/options-footer.php';
require get_template_directory() . '/inc/customizer/options/options-social.php';
require get_template_directory() . '/inc/customizer/options/options-color.php';
require get_template_directory() . '/inc/customizer/options/options-single.php';
require get_template_directory() . '/inc/customizer/options/options-typography.php';
require get_template_directory() . '/inc/customizer/options/options-post-slider.php';
require get_template_directory() . '/inc/customizer/options/options-loader.php';
require get_template_directory() . '/inc/customizer/options/options-breadcrumb.php';