<?php
/**
 * Custom Walker
 *
 * @access      public
 * @since       1.0 
 * @return      void
*/
class Hasium_Nav_Walker extends Walker_Nav_Menu
{
	// Displays start of a level. E.g '<ul>'
	// @see Walker::start_lvl()
	function start_lvl(&$output, $depth=0, $args=array()) {
			$output .= '';
	}

	// Displays end of a level. E.g '</ul>'
	// @see Walker::end_lvl()
	function end_lvl(&$output, $depth=0, $args=array()) {
            $output .= '';
	}

	// Displays start of an element. E.g '<li> Item Name'
	// @see Walker::start_el()
	function start_el(&$output, $item, $depth=0, $args=array(), $id = 0) {

		if($depth == 0){
			if($args->walker->has_children){
				$output .= '<li><a href="#" class="dw-menu">'.$item->title.'</a>
                        <ul class="sub-menu">';
			}else{
				$output .= '<li><a href="'.$item->url.'" class="dw-menu">'.$item->title.'</a>
                        <ul class="sub-menu">';
			}


		}

		if($depth == 1){
             $output .= '<li><a href="'.$item->url.'">'.$item->title.'</a>';
		}

	}

	// Displays end of an element. E.g '</li>'
	// @see Walker::end_el()
	function end_el(&$output, $item, $depth=0, $args=array()) {
		if($depth == 0){
			$output .= "</ul></li>";
		}

		if($depth == 1){
            $output .= '</li>';
		}

	}
}