<?php
function hasium_let_to_num( $size ) {
    $l   = substr( $size, -1 );
    $ret = substr( $size, 0, -1 );
    switch ( strtoupper( $l ) ) {
        case 'P':
            $ret *= 1024;
        case 'T':
            $ret *= 1024;
        case 'G':
            $ret *= 1024;
        case 'M':
            $ret *= 1024;
        case 'K':
            $ret *= 1024;
    }
    return $ret;
}
$ssl_check = 'https' === substr( get_home_url(), 0, 5 );
$green_mark = '<mark class="green"><span class="dashicons dashicons-yes"></span></mark>';
$hasium_theme = wp_get_theme();
$plugins_counts = (array) get_option( 'active_plugins', array() );
if ( is_multisite() ) {
    $network_activated_plugins = array_keys( get_site_option( 'active_sitewide_plugins', array() ) );
    $plugins_counts            = array_merge( $plugins_counts, $network_activated_plugins );
}
?>
<div class="wrap about-wrap wphobby-wrap">
    <h1><?php _e( 'Welcome to Hasium', 'hasium' ); ?></h1>
    <div class="about-text">
        <?php
        printf(
                  esc_html__( 'Hasium theme is now installed and ready to use! - %1$s', 'hasium' ),
                  '<a href="https://wphobby.com/pricing" target="_blank">Visit Pro Version</a>'
              );
        ?>
	</div>
    <div class="hasium-badge">
        <img src="data:image/png;base64,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" alt="hasium admin logo">
        <p><?php echo esc_html($hasium_theme->get( 'Version' )); ?></p>
    </div>
    <h2 class="nav-tab-wrapper">
        <?php
        printf( '<a href="#" class="nav-tab nav-tab-active">%s</a>', __( 'Welcome', 'hasium' ) );
        printf( '<a href="%s" class="nav-tab">%s</a>', admin_url( 'customize.php' ), __( 'Theme Options', 'hasium' ) );
        ?>
        <a href="https://wphobby.com/pricing" target="_blank" class="nav-tab">
            <?php esc_html_e( 'View Demos', 'hasium' ); ?>
        </a>
        <a href="https://wphobby.com/pricing" target="_blank" class="nav-tab">
            <?php esc_html_e( 'Help & Support', 'hasium' ); ?>
        </a>

    </h2>
    <div class="hasium-section nav-tab-active" id="welcome">
        <p class="about-description">
            <?php printf( __( 'Hasium comes with website ready-to-use <a href="https://wphobby.com/demo" target="_blank">demo template</a> with a single click.', 'hasium')); ?>
        </p>
                <div class="hasium-review-notice-container">
				    <a class="button button-primary" href="https://wphobby.com/pricing" target="_blank">
                        <?php esc_html_e( 'Get Started', 'hasium' ); ?>
                    </a>
			    </div>
    </div>
</div>

