<?php
/**
 * The header of all pages.
 *
 * Displays all of the <head> section and everything before <main id="main">
 *
 *
 * @package    Hasium
 * @author     wphobby
 * @link       http://hasium.wphobby.com
 */
global $hasium_options;
?>
    <!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <link rel="profile" href="http://gmpg.org/xfn/11">
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">

        <?php wp_head(); ?>
    </head>

<body <?php body_class(); ?>>
<?php
if ( function_exists( 'wp_body_open' ) ) {
    wp_body_open();
} else {
    do_action( 'wp_body_open' );
}
?>
<!--[if lt IE 8]>
<p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please upgrade your browser to improve your experience.</p>
<![endif]-->
<?php do_action( 'hasium_before_header' ); ?>

<?php
$header_load = 'left';

if ( (isset($hasium_options['header_style'])) ) {
    if ('site-header-center' === $hasium_options['header_style']) {
        $header_load = 'center';
    }else if('site-header-left' === $hasium_options['header_style']){
        $header_load = 'left';
    }
}

get_template_part( 'template-parts/header/header', $header_load );

do_action( 'hasium_after_header' );
?>