<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package hasium
 */
global $hasium_options;
?>

<!--====== FOOTER PART START ======-->

<footer class="footer-area <?php echo esc_attr($hasium_options['footer_info_background']);?>">
    <div class="container">
        <div class="footer-top pt-30 pb-60 border-bottom">
            <div class="row">
                <?php get_sidebar('footer'); ?>
            </div> <!-- row -->
        </div> <!-- Footer top -->


        <div class="footer-copyright pt-15 pb-15">
            <div class="row">
                <div class="col-lg-12">
                    <div class="copyright text-center">
                        <p>
                        <?php
                        /* translators: 1: Current Year, 2: Blog Name 3: Theme Developer 4: WordPress. */
                        printf( esc_html__( 'COPYRIGHT @ %1$s %2$s', 'hasium' ),
                            esc_attr( date( 'Y' ) ),
                            '<a href="https://wphobby.com/pricing" target="_blank">WPHOBBY</a>'
                        );
                        ?>
                        </p>
                    </div> <!-- copyright -->
                </div>
            </div> <!-- row -->
        </div> <!-- footer copyright -->
    </div> <!-- container -->
</footer>

<!--====== FOOTER PART ENDS ======-->
<?php
do_action( 'hasium_after_footer' );
wp_footer();
?>
</body>
</html>
