<?php
/**
 * The template to display comments.
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 *
 * @package    Hasium
 * @author     wphobby
 * @link       http://hasium.wphobby.com
 */
?>

<div class="details-comment pt-55 pb-60">

    <div class="comment-list">
    <?php if ( have_comments() ) : ?>
        <h4 class="comments-title">
            <?php
            $comment_count = get_comments_number();
            if ( '1' === $comment_count ) {
                printf(
                /* translators: 1: title. */
                    esc_html__( 'One thought on &ldquo;%1$s&rdquo;', 'hasium' ),
                    '<span>' . esc_html(get_the_title()) . '</span>'
                );
            } else {
                printf( // WPCS: XSS OK.
                /* translators: 1: comment count number, 2: title. */
                    esc_html( _nx( '%1$s thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', $comment_count, 'comments title', 'hasium' ) ),
                    number_format_i18n( $comment_count ),
                    '<span>' . esc_html(get_the_title()) . '</span>'
                );
            }
            ?>
        </h4>

        <ul>
            <?php
            /* Loop through and list the comments. Tell wp_list_comments()
             * to use hasium_comment() to format the comments.
             * If you want to override this in a child theme, then you can
             * define hasium_comment() and that will be used instead.
             */
            wp_list_comments( array( 'callback' => 'hasium_comment' ) );
            ?>
        </ul><!-- .comment-list -->
        <?php the_comments_navigation(); ?>
      <?php endif; // have_comments() ?>
    </div> <!-- comment title -->

    <?php
    // If comments are closed and there are comments, let's leave a little note, shall we?
    if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
        ?>
        <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'hasium' ); ?></p>
    <?php endif; ?>

    <?php

    $commenter 	= wp_get_current_commenter();
    $req 		= get_option( 'require_name_email' );
    $aria_req 	= ( $req ? " aria-required='true'" : '' );

    $hasium_comment_args = array(

        'title_reply' => __( 'Leave a Comment', 'hasium' ),

        'fields' => apply_filters( 'comment_form_default_fields', array(

            'author' 	=> 	'<div class="row"><div class="col-md-12"><div class="single-form"><input type="text" placeholder="'. esc_attr__( 'Name', 'hasium' ) .'" name="author" value="">
                             </div> <!-- single form --></div>',
            'email'  	=> 	'<div class="col-md-6"><div class="single-form"><input type="email" placeholder="'. esc_attr__( 'Email Address', 'hasium' ) .'" name="email" value="">
                             </div> <!-- single form --></div>',
            'url'   	=> 	'<div class="col-md-6"><div class="single-form"><input type="text" placeholder="'. esc_attr__( 'Website', 'hasium' ) .'" name="website">
                             </div> <!-- single form --></div>'

        )),

        'comment_field' =>	'<div class="col-md-12"><div class="single-form">
                             <textarea placeholder="'. esc_attr__( 'Enter your comment here...', 'hasium' ) .'" name="comment"></textarea>
                             </div> <!-- single form -->
                             </div></div><!-- row -->',

        'comment_notes_after'  => '',

    );

    echo '<div class="comment-form pt-50">';
    comment_form($hasium_comment_args);
    echo '</div>';

    ?>
</div> <!-- details comment -->
