jQuery(function($) {
    
    "use strict";
    
    //===== Prealoder
    
    $(window).on('load', function(event) {
        $('.preloader').delay(500).fadeOut(500);
    });
    
    
    //===== Search
    
    $('a[href="#search-box"]').on('click', function(){
        $(".search-box").addClass('open');
    });
    
    $('.closebtn').on('click', function(){
        $(".search-box").removeClass("open");
    });
    
    
    //===== Side Canvas
    
    $('a[href="#side-canvas"]').on('click', function(){
        $(".side-canvas").addClass('open');
    });
    
    $('.canvas-closebtn').on('click', function(){
        $(".side-canvas").removeClass("open");
    });
    
    
    var lastClicked;
    $(".dw-menu").on('click', function(e) {
        
      $(this).siblings().toggle('slow');
      $(this).removeClass('b');

        if (lastClicked != $(this)) {
            if (lastClicked != undefined) {
                if(lastClicked.hasClass('b')){
                    lastClicked.siblings().hide(1000);
                }
            }
        }

        lastClicked = $(this);
        lastClicked.addClass('b')
    });
    
    
    
    //===== Mean Menu
    
    $('#mobile-menu').meanmenu({
        meanMenuContainer: '.mobile-menu',
        meanScreenWidth: "991",
        meanMenuClose: '<span></span><span></span></span><span></span>',
        meanMenuCloseSize: "0px",
        meanRevealPosition: "left"
    });
    
    
    //===== Sticky
    
    $(window).on('scroll',function(event) {    
        var scroll = $(window).scrollTop();
        if (scroll < 245) {
            $(".header-sticky").removeClass("sticky");
        }else{
            $(".header-sticky").addClass("sticky");
        }
    });
    
    
    //===== Slick Slider 
    
    function mainSlider() {
        var BasicSlider = $('.slider-active');
        var BasicSlider2 = $('.slider-active-2');
        
        BasicSlider.on('init', function(e, slick) {
            var $firstAnimatingElements = $('.single-slider:first-child').find('[data-animation]');
            doAnimations($firstAnimatingElements);
        });
        BasicSlider2.on('init', function(e, slick) {
            var $firstAnimatingElements = $('.single-slider:first-child').find('[data-animation]');
            doAnimations($firstAnimatingElements);
        });
        
        
        BasicSlider.on('beforeChange', function(e, slick, currentSlide, nextSlide) {
            var $animatingElements = $('.single-slider[data-slick-index="' + nextSlide + '"]').find('[data-animation]');
            doAnimations($animatingElements);
        });
        BasicSlider2.on('beforeChange', function(e, slick, currentSlide, nextSlide) {
            var $animatingElements = $('.single-slider[data-slick-index="' + nextSlide + '"]').find('[data-animation]');
            doAnimations($animatingElements);
        });
        
        
        
        BasicSlider.slick({
            autoplay: true,
            autoplaySpeed: 6000,
            dots: false,
            fade: true,
            speed: 1000,
			arrows: true,
            prevArrow:'<span class="prev"><i class="ti-arrow-left"></i></span>',
            nextArrow: '<span class="next"><i class="ti-arrow-right"></i></span>',
            responsive: [
                { breakpoint: 767, settings: { dots: false, arrows: false } }
            ]
        });
        
        BasicSlider2.slick({
            autoplay: true,
            autoplaySpeed: 6000,
            dots: true,
            fade: true,
            speed: 1000,
            arrows: false,
            responsive: [
                { breakpoint: 767, settings: { dots: false, arrows: false } }
            ]
        });

        function doAnimations(elements) {
            var animationEndEvents = 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend';
            elements.each(function() {
                var $this = $(this);
                var $animationDelay = $this.data('delay');
                var $animationType = 'animated ' + $this.data('animation');
                $this.css({
                    'animation-delay': $animationDelay,
                    '-webkit-animation-delay': $animationDelay
                });
                $this.addClass($animationType).one(animationEndEvents, function() {
                    $this.removeClass($animationType);
                });
            });
        }
    }
    mainSlider();
    
    
    //===== Back to top
    
    // Show or hide the sticky footer button
    $(window).on('scroll', function(event) {
        if($(this).scrollTop() > 600){
            $('.back-to-top').fadeIn(200)
        } else{
            $('.back-to-top').fadeOut(200)
        }
    });
    
    //Animate the scroll to yop
    $('.back-to-top').on('click', function(event) {
        event.preventDefault();
        
        $('html, body').animate({
            scrollTop: 0,
        }, 1500);
    });

    
    
    //===== Slick Team 
    
    $('.team-active').slick({
        dots: false,
        infinite: true,
        speed: 800,
        slidesToShow: 4,
        slidesToScroll: 1,
        arrows: true,
        prevArrow:'<span class="prev"><i class="fa fa-angle-left"></i></span>',
        nextArrow: '<span class="next"><i class="fa fa-angle-right"></i></span>',
        responsive: [
        {
          breakpoint: 1200,
          settings: {
              slidesToShow: 4,
          }
        },
        {
          breakpoint: 992,
          settings: {
              slidesToShow: 4,
          }
        },
        {
          breakpoint: 768,
          settings: {
              slidesToShow: 3,
          }
        },
        {
          breakpoint: 576,
          settings: {
              slidesToShow: 2,
              arrows: false,
          }
        }
        // You can unslick at a given breakpoint now by adding:
        // settings: "unslick"
        // instead of a settings object
        ]
    });
    

 
    
    
    
    //===== Slick Testimonial 
    
    $('.testimonial-active').slick({
        dots: true,
        arrows: true,
        prevArrow:'<span class="prev"><i class="fa fa-angle-left"></i></span>',
        nextArrow: '<span class="next"><i class="fa fa-angle-right"></i></span>',
        infinite: true,
        speed: 800,
        slidesToShow: 1,
        responsive: [
        {
          breakpoint: 576,
          settings: {
              slidesToShow: 1,
              arrows: false,
          }
        }
        // You can unslick at a given breakpoint now by adding:
        // settings: "unslick"
        // instead of a settings object
        ]
    });
    
    
    //===== Load Function 
    
    $(function () {
        
        $('.news-hidden').slice(0, 4).show();
        
        $('#more').on('click', function(e) {
            
            e.preventDefault();
            
            $('.news-hidden:hidden').slice(0, 2).slideDown();
            
            if($('.news-hidden:hidden').length == 0) {
                $('#more').fadeOut('show')
            }
            
            $('html,body').animate({
                scrollTop: $(this).offset().top
            }, 1500);
            
        });
        
    });
    
    
    //===== Load Function 
    
//    $(function () {
//        
//        $('.news-hidden-2').slice(0, 12).show();
//        
//        $('#more-2').on('click', function(e) {
//            
//            e.preventDefault();
//            
//            $('.news-hidden-2:hidden').slice(0, 3).slideDown();
//            
//            if($('.news-hidden-2:hidden').length == 0) {
//                $('#more-2').fadeOut('show')
//            }
//            
//            $('html,body').animate({
//                scrollTop: $(this).offset().top
//            }, 1500);
//            
//        });
//        
//    });
    

    
    
    
    
});































