<?php
/**
 * The template to display 404 pages (not found).
 *
 *
 * @package    Hasium
 * @author     wphobby
 * @link       http://hasium.wphobby.com
 */
get_header();
?>
    <section class="error-page pt-60 pb-60">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="error-content text-center">
                        <img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/error.png" alt="">
                        <h2 class="error-title mt-35">404 - not found</h2>
                        <p class="mt-40"><?php esc_html_e( "It seems we can't find what you're looking for. Perhaps searching can help or go back to", "hasium" ); ?><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php esc_html_e( 'Homepage', 'hasium' ); ?></a></p>
                        <div class="error-search">
                            <?php
                            get_search_form();
                            ?>
                        </div> <!-- error-search -->
                    </div> <!-- error content -->
                </div>
            </div> <!-- row -->
        </div> <!-- container -->
    </section>
<?php
get_footer();
