<?php

if ( ! function_exists( 'handdrawn_article_intro' ) ) :
/**
 * Template to display the main article on the home page and the intro of the article on single posts
 */
    function handdrawn_article_intro(){ ?>
        <?php global $post; ?>
        <div class="row">
            <div class="article-title small-12 columns">
                <h1 class="handy"><?php if( ! is_single() ) { ?><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> <?php } else { the_title(); } ?></h1>
            </div>
            <?php if( ! is_page()) { ?>
            <p class="post-informations small-12 columns handy">
                <span class="icon-calendar"></span><span><?php echo get_the_date(); ?></span>
                <span class="icon-speech-bubble-single"></span><span><?php comments_number('0'); ?></span>
                <span class="icon-folder"></span><span><?php the_category( ', ' ); ?></span>
            <?php if ( has_tag()) { ?>
                <span class="icon-tag"></span><span><?php the_tags('', ' ', ''); ?></span>
            <?php } ?>
            <span><?php _e(' by ', 'handdrawn-lite'); esc_url( the_author_posts_link() ); ?></span></p>
            <?php } ?>
        </div><!-- end .row -->
        <?php if ( has_post_thumbnail() ) { ?>
            <div class="row">
                  <div class="large-12 small-centered columns post-thumb">
                    <?php if( ! is_single() ) { ?>
                      <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
                    <?php } else { the_post_thumbnail('handdrawn-size'); } ?>
                  </div>
            </div><!-- end .row -->
        <?php } ?>    
    <?php } ?>
<?php endif; 

if ( ! function_exists( 'handdrawn_article_intro_circle_clip_textpath' ) ) :
/**
 * Template to display the main article on the home page and the intro of the article on single posts
 */
    function handdrawn_article_intro_circle_clip_textpath(){ ?>
        <?php global $post; ?>
        <h1 class="screen-reader-text"><?php if( ! is_single() ) { ?><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> <?php } else { the_title(); } ?></h1>
        <div class="row circle-clip">
            <div class="large-12 small-centered columns post-thumb">
                <div class="clip-mask">
                    <?php if( ! is_single() ) { ?>
                    <a href="<?php the_permalink(); ?>">
                    <?php } ?>
                    <div class="svg-container">
                        <svg version="1.1" preserveAspectRatio="xMinYMin meet" viewBox="0 0 800 600" enable-background="new 0 0 800 600" class="svg-content">
                            <defs>
                                <path id="author-path" fill="none" stroke-miterlimit="10" d="M222.8 171.4c40.3-56 106-92.4 180.2-92.4 122.6 0 222 99.4 222 222s-99.4 222-222 222 -222-99.4-222-222c0-45.5 13.7-87.7 37.1-122.9"/>
                            </defs>
                            <path fill="#fff" d="M0 0v600h800V0H0zM611.9 329.6c-1.7 19-4.1 38.3-11.5 55.9 -7.6 18.2-20.3 33.7-33.7 48.1 -15.8 17.1-33 33.1-52.5 45.9 -52.4 34.6-120.8 43.8-180.5 24.4C274 484.4 224.1 436.8 202.1 378c-22.1-58.8-15.9-127.5 16.3-181.4 7.5-12.6 16.3-24.3 25.1-36 3.5-4.7 7-9.4 10.6-14.1 -0.9 0.6-1.8 1.2-2.7 1.8L264 133c-3.3 4.5-6.7 8.9-10 13.4 33.8-23 69.5-44.4 109.1-54.3C418.2 78.3 479 88.7 526 120.4c47.1 31.7 79.6 84.4 86.4 140.7C615.2 283.8 613.9 306.8 611.9 329.6z"/>
                            <path fill="#99b897" d="M260.9 160.2c2.8-11 11.7-18.4 20.9-24.2 10.4-6.7 21.4-12.6 32.5-18.1 22.1-10.9 45.8-19.5 70.4-22.1 26-2.7 52.2 1.4 77.4 7.9 22.1 5.7 43.8 13.7 63.6 25.2 41.5 24.2 69.8 64.9 78.2 112.4 5.2 29.7 1.2 60.5-4.8 89.8 -4.9 23.8-12.4 47.1-24.4 68.3 -40.9 72.5-125 116.6-207.8 102.1C276.5 485.6 200 406.4 196.4 313c-1-26.7 4.6-54 15.2-78.5 9.9-22.9 24.7-42.8 41.4-61.1 32.4-35.5 71.3-71.4 120.8-78.6 12-1.7 24.1-1.5 36 0.7 -0.2 0 0.5-5.5-0.1-5.6 -53.6-11-102.3 22.7-138.4 58.5 -18.3 18.2-36.2 37.6-49.4 59.9 -12.7 21.5-20.8 45.6-24.1 70.4 -6.3 47.3 4.4 95.5 30 135.7 24.2 37.9 61.3 67.1 103.4 82.7 41.3 15.3 86.6 16.7 128.4 2.7 41.4-13.9 78.1-41.3 103.5-76.8 29-40.5 41-91.6 43.4-140.7 2.2-46.4-10.6-93.2-42.6-127.9 -34-36.9-85.6-55.1-134.2-62.1 -26.8-3.8-53.4-2.1-79.3 6.1 -24.6 7.8-49.1 19.9-70.5 34.3 -8.7 5.9-16.4 13.2-19 23.6C260.4 157.5 261.1 159.4 260.9 160.2L260.9 160.2z"/>
                            <path fill="#F8ecc9" d="M312.8 101.2c51.3-12.8 105.9-10.8 155.6 7.8 44.4 16.6 84 45.7 113 83.3 16.5 21.4 28.5 45.3 31.5 72.4 3.3 29.4-3.5 59.1-14.1 86.4 -8.9 22.9-20.4 45-33.4 65.8 -12.5 19.9-27 38.9-45 54.1 -18.3 15.5-39.4 25.6-62.7 30.8 -13.2 2.9-26.6 4.7-40 6.2 -13.6 1.6-27.4 2.6-41.1 1.5 -25.8-2.1-48.9-13.8-69.9-28.5 -18.3-12.8-34.9-28.1-49.2-45.3C228.6 401 208.7 358.1 204 313c-4.6-44.6 7.6-90.9 31.7-128.5 25.4-39.7 63.6-66.4 108.5-79.8 43.2-12.9 92.8-17.2 135 1.4 9.6 4.2 18.8 9.5 27.2 15.8 -0.4-0.3 0.7-3.3-0.1-3.9C469.9 85.7 416.7 83.5 371 92.4c-26.4 5.1-52.4 13.8-75.5 27.7 -18.5 11.1-34.7 25.7-48.1 42.5 -27.6 34.6-43.1 78.2-44.8 122.3 -1.7 44.1 10.4 87.8 33.1 125.4 24 39.7 60.5 75.4 103.2 94.4 27.2 12.1 55.6 11.2 84.5 7.6 26.5-3.3 53-7.9 76.3-21.6 41.8-24.6 68.8-69.1 89.2-111.7 21.6-45.1 34.7-98.2 17.7-147 -8.3-23.7-23.9-44.7-41-62.8 -17-18.1-36.6-33.7-58-46.1 -46.4-27.1-101-38.7-154.4-33 -13.7 1.5-27.2 4.1-40.5 7.9C312.2 98 312.8 101.2 312.8 101.2L312.8 101.2z"/>
                            <path fill="#eb9f9f" d="M422.7 83.9c45.1 16.4 89.9 36.8 125.8 69.4 32 29.1 56.8 68.2 63.8 111.3 7.5 45.7-7.9 90.9-31.3 129.8 -11.7 19.4-25.5 37.8-42.3 53 -17.2 15.6-37.6 27-59 35.7 -42.8 17.4-89 26.2-134.3 14 -42.9-11.5-79.8-38.5-104.5-75.3 -47-70.2-49.2-170.5-4.5-242.4 10.7-17.2 24.3-32.7 40.7-44.6 18.5-13.5 40-21.6 62-27.4 43-11.4 89.9-16.5 133.1-3.4 10.6 3.2 20.9 7.4 30.5 12.9 1.1 0.6 0.8 0.4 0.2-0.3 -0.9-1.1-2.6-1.9-3.9-2.7 -40.4-24-88.2-26.7-133.7-19.3 -24.4 4-49.2 10.1-71.7 20.6 -20.1 9.4-37.5 23.2-51.6 40.4 -56.5 69-58.5 176.8-13.9 252.2 21.1 35.7 53.8 64.3 91.2 82 19.1 9 39.7 15 60.8 17 24.4 2.3 48.8-1.1 72.3-7.8 24.3-6.9 48.3-16.4 69.6-30 20.5-13.1 37.6-30.6 51.7-50.4 28-39 49.5-86.8 46.2-135.8 -6.4-92.9-88.7-155.6-168-189.1 -10.9-4.6-22.1-8.9-33.3-12.8C419.5 81.3 421.2 83.4 422.7 83.9L422.7 83.9z"/>
                            <text x="18px" class="title-textpath handy" fill="#99b897" stroke="none">
                                <textPath xlink:href="#author-path"><?php the_title(); ?></textPath>
                            </text>
                        </svg>
                    </div>
                    <?php if( ! is_single() ) { ?>
                    </a>
                    <?php } ?>
                </div>
                            <?php if( ! is_single() ) { ?>
                              <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
                            <?php } else { the_post_thumbnail('handdrawn-size'); } ?>
            </div>
            <?php if( ! is_page()) { ?>
            <p class="post-informations small-12 columns handy under-thumbnail">
                <span class="icon-calendar"></span><span><?php echo get_the_date(); ?></span>
                <span class="icon-speech-bubble-single"></span><span><?php comments_number('0'); ?></span>
                <span class="icon-folder"></span><span><?php the_category( ', ' ); ?></span>
            <?php if ( has_tag()) { ?>
                <span class="icon-tag"></span><span><?php the_tags('', ' ', ''); ?></span>
            <?php } ?>
            <span><?php _e(' by ', 'handdrawn-lite'); esc_url( the_author_posts_link() ); ?></span></p>
            <?php } ?>
        </div><!-- end .row -->   
    <?php } ?>
<?php endif; 

if ( ! function_exists( 'handdrawn_article_intro_circle_clip' ) ) :
/**
 * Template to display the main article on the home page and the intro of the article on single posts
 */
    function handdrawn_article_intro_circle_clip(){ ?>
        <?php global $post; ?>
        <div class="row">
            <div class="article-title small-12 columns">
                <h1 class="handy "><?php if( ! is_single() ) { ?><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> <?php } else { the_title(); } ?></h1>
            </div>
            <?php if( ! is_page()) { ?>
            <p class="post-informations small-12 columns handy">
                <span class="icon-calendar"></span><span><?php echo get_the_date(); ?></span>
                <span class="icon-speech-bubble-single"></span><span><?php comments_number('0'); ?></span>
                <span class="icon-folder"></span><span><?php the_category( ', ' ); ?></span>
            <?php if ( has_tag()) { ?>
                <span class="icon-tag"></span><span><?php the_tags('', ' ', ''); ?></span>
            <?php } ?>
            <span><?php _e(' by ', 'handdrawn-lite'); esc_url( the_author_posts_link() ); ?></span></p>
            <?php } ?>
           
        </div><!-- end .row -->
            <div class="row circle-clip">
                <div class="large-12 small-centered columns post-thumb">
                    <div class="clip-mask"> <!-- This div contains the curved name  -->
                        <div class="svg-container">
                            <svg version="1.1" preserveAspectRatio="xMinYMin meet" viewBox="0 0 800 600" enable-background="new 0 0 800 600" class="svg-content">
                                <path fill="#fff" d="M0 0v600h799V0H0zM663.2 337c-2.1 23.8-5.1 47.9-14.3 69.9 -9.5 22.7-25.4 42.2-42.1 60.2 -19.8 21.4-41.3 41.3-65.6 57.4C475.5 567.7 390 579.3 315.3 555c-74.7-24.3-137.1-83.9-164.7-157.5C123 324 130.7 238 171 170.6c9.4-15.7 20.4-30.4 31.4-45.1 4.4-5.9 8.8-11.7 13.2-17.6 -1.1 0.8-2.2 1.5-3.4 2.3l15.9-19c-4.2 5.6-8.4 11.2-12.5 16.8 42.3-28.8 86.9-55.5 136.5-67.9C421 22.7 497 35.7 555.8 75.4c58.9 39.7 99.6 105.5 108 176C667.3 279.8 665.7 308.5 663.2 337z"/>
                                <path fill="#99b897" d="M204.9 120.8c3.7-14.7 15.9-24.5 28.3-32.1 14-8.7 28.7-16.5 43.6-23.7 30.7-14.9 63.4-26.5 97.5-30 35.6-3.7 71.5 1.7 106 10.3 30.7 7.6 60.9 18.3 88.4 34 27.3 15.5 51.5 36.1 69.9 61.7 18.6 25.9 31.1 56.1 36.9 87.5 7.2 39.2 2.1 79.6-5.8 118.3 -6.6 32.2-16.7 63.7-33.1 92.3 -27.8 48.7-70.9 88.2-121.1 113 -51.2 25.3-109 34.1-165.4 24.5 -56.7-9.7-110.3-36.8-151.8-76.6C151 454.7 119 391.1 116.4 325.3c-1.4-35.3 5.9-71.3 19.9-103.7 13.4-31.1 33.8-58 56.8-82.6 45.1-48.2 99.2-96.3 167.1-105.6 16.2-2.2 32.8-2.1 48.9 1 -0.2 0 0.5-5.5-0.1-5.6 -72-13.8-137.4 28-187.3 75.5 -25.6 24.3-50.6 50.4-69.3 80.5 -17.7 28.6-29.2 60.9-34 94.2 -9.1 64.3 6.9 130 43.5 183.6 34 49.8 84.9 87.3 141.7 107.2 56.4 19.7 117.9 21.2 174.7 2.5 55.3-18.2 104.9-53.7 139.9-100.3 18.4-24.5 32.2-51.9 41.5-81 11-34.7 17.5-71.7 19.3-108 3-63.3-16.4-126.9-62-172.3 -47.6-47.4-117.1-70.4-182.3-79.2 -36.9-4.9-73.5-2.2-109.1 9 -17.1 5.4-33.6 12.3-49.7 20.2 -15.4 7.5-31 15.6-45.3 25.1 -11.6 7.6-22.3 17.2-25.7 31.1C204.4 118.1 205.1 120 204.9 120.8L204.9 120.8z"/>
                                <path fill="#F8ecc9" d="M422.7 24c58.1 21.1 115.9 47.5 162.1 89.5 40.8 37 72.3 86.6 81.7 141.4 10.1 59.3-10 118-40.6 168.4 -15.1 24.8-32.8 48.3-54.5 67.7 -22.3 19.9-48.8 34.5-76.5 45.6 -29.2 11.7-60 20.7-91.5 23.8 -27.4 2.6-55.1 0-81.5-7.5 -53.3-15.1-99.5-48.9-130.8-94.5 -31.7-46.3-47.5-102.5-48.2-158.4 -0.6-53.5 12.3-108.2 40.7-153.9 13.6-21.9 30.8-41.6 51.6-56.9 24.2-17.8 52.5-28.3 81.3-35.9 54.9-14.4 114.7-20.6 169.8-3.7 13.4 4.1 26.5 9.5 38.6 16.6 1.1 0.6 0.8 0.4 0.2-0.3 -0.9-1.1-2.6-2-3.9-2.7C469.8 33 409.6 29.3 351.7 38.6c-30.8 4.9-62 12.6-90.5 25.5 -25.8 11.7-48.4 29.1-66.6 50.8 -35.7 42.6-54.2 98-58.1 153 -4.2 58 7.8 117.5 36.7 168.1 26.9 47.1 69.2 84.8 118.3 107.7 24.6 11.5 51.1 19 78.2 21.3 31 2.7 62-1.9 91.8-10.4 30.5-8.8 60.7-20.7 87.5-37.9 26-16.6 47.7-38.6 65.8-63.6 35.8-49.5 63.6-110.5 60-172.8 -3.3-56.9-32-109.9-71.1-150.4 -40-41.3-91.1-70.9-143.8-93.1 -13.6-5.7-27.4-11-41.3-15.9C419.5 21.4 421.2 23.5 422.7 24L422.7 24z"/>
                                <path fill="#eb9f9f" d="M120.6 265.7c0.5 0 0.5-8.6-0.2-8.6C119.8 257 119.9 265.7 120.6 265.7L120.6 265.7z"/>
                                <path fill="#eb9f9f" d="M459.4 23.3c19.1-3.4 36.7 6.4 52.1 16.6 15 9.9 29.5 20.6 43.5 31.9 25.5 20.6 49.1 43.7 69.4 69.6 40 51.1 66.8 114.6 65.6 180.2 -1.1 59-25.6 116.9-66.4 159.4 -43.7 45.4-104.3 69-165.6 78.6 -33.4 5.2-68.9 8.4-102.3 2.4 -34.8-6.2-66.1-24.9-93.4-46.6C216.3 479 179.7 430.8 156 377.2c-11.6-26.1-20.1-53.6-25.1-81.7 -5.4-30.4-7.6-62.4-2.8-93 10.2-64.9 61.5-111.1 118.2-138.6 60.5-29.4 130.4-47.7 197.9-42.2 60.7 4.9 120.1 31.3 157 81.1 8.4 11.4 15.9 23.7 21.3 36.8 0.5 1.2 3.1 1.5 3.5 2.4 -21.3-51.6-67.2-89.1-118.6-109 -65.5-25.3-138.8-18.5-204.5 2.3C239 55.5 172.2 88.6 139 149.8c-16.9 31.1-20.3 66.1-18.3 101 1.7 30.6 7.7 60.9 17.4 90 19 57.2 52.3 109.5 95.9 151.1 21.2 20.2 44.9 38.2 70.5 52.6 14.6 8.2 30.1 15 46.4 18.9 17.8 4.3 36.2 5.2 54.4 4.7 66.6-1.9 136.3-17.6 191.1-57.1 51.1-36.8 85.8-94.7 95.1-156.9 10.1-67.3-11.6-135.5-49.4-191 -18.9-27.7-41.7-52.5-66.8-74.7 -23.3-20.6-48.6-40.4-75.4-56.1 -13-7.6-27.5-13.4-42.7-10.6C457.5 21.6 458.6 23.5 459.4 23.3L459.4 23.3z"/>
                            </svg>
                        </div>
                    </div>
                        <?php if( ! is_single() ) { ?>
                          <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
                        <?php } else { the_post_thumbnail('handdrawn-size'); } ?>
                </div>
            </div><!-- end .row -->   
    <?php } ?>
<?php endif; 



if ( ! function_exists( 'handdrawn_article_intro_cloud_clip' ) ) :

    function handdrawn_article_intro_cloud_clip(){ ?>
        <?php global $post; ?>
        <div class="row">
            <div class="article-title large-12 columns">
                <h1 class="handy "><?php if( ! is_single() ) { ?><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> <?php } else { the_title(); } ?></h1>
            </div>
            <?php if( ! is_page()) { ?>
            <p class="post-informations small-12 columns handy">
                <span class="icon-calendar"></span><span><?php echo get_the_date(); ?></span>
                <span class="icon-speech-bubble-single"></span><span><?php comments_number('0'); ?></span>
                <span class="icon-folder"></span><span><?php the_category( ', ' ); ?></span>
            <?php if ( has_tag()) { ?>
                <span class="icon-tag"></span><span><?php the_tags('', ' ', ''); ?></span>
            <?php } ?>
            <span><?php _e(' by ', 'handdrawn-lite'); esc_url( the_author_posts_link() ); ?></span></p>
            <?php } ?>
        </div><!-- end .row -->
            <div class="row circle-clip">
                <div class="large-12 small-centered columns post-thumb">
                    <div class="clip-mask"> <!-- This div contains the curved name  -->
                        <div class="svg-container">
                            <!-- the textpath used to layout the title text along a circle -->
                            <svg version="1.1" preserveAspectRatio="xMinYMin meet" viewBox="0 0 803 602" enable-background="new 0 0 803 602" class="svg-content">
                                <path fill="#fff" d="M-3.5-3.5v609h810v-609H-3.5z M741.8,417c-2.3,23.4-12.8,43.5-26.9,62.2c-4.5,3.4-8.5,7.3-11.7,12c-0.7,0.6-1.5,1.1-2.2,1.7c-26.6,20.6-56.6,30.6-90.9,27.9c-14.3-1.1-28.2-3.6-41-10.1c-7-3.6-10.9-2.5-15.9,3.5c-30.4,36.4-70.2,56.3-118.6,56.9c-48.4,0.6-88.7-18.2-119.8-54.1c-4.6-5.3-8.1-6.9-15.2-4.6c-31.5,10-63.7,10.3-96.1,4.6c-2-0.2-4-0.4-6-0.5c-2.2-2.4-5.2-2.8-8.2-3.3c-56.1-18-95-53.9-118-106.3c-1.4-5.5-2.8-10.9-5.8-15.9l0-0.1c-2.2-14.2-5.8-28.2-6-42.6c-1.5-74.6,41.6-139.1,113-168.5c7.5-3.1,10.6-7.3,13-14.3c20.2-57.2,59.7-96.4,118.9-116c57.7-19.1,112.1-9.8,163.1,20.8c25.8,15.5,44.4,37.9,60.4,62.4c0,0-0.1,0.1-0.1,0.1c2.4,10.1,7.9,12.1,16.9,6.4c3-1.9,6.7-2.7,10.1-4c60.5-14.9,115.3,16.1,128.5,73.1c4.1,17.8,2,35.6-3,53.1c-2.4,4.6-4.6,9.2-7.2,13.7c-10,17.7-10.1,17.6,9.4,26l0,0c0.6,0.5,1.3,1,1.9,1.5c0.7,0.3,1.4,0.6,2.1,0.9c0.7,0.5,1.4,1,2,1.5c1.6,1.2,3.1,2.5,4.7,3.7C730.2,336.1,746.2,372.3,741.8,417z"/>
                                <path fill="#99b897" d="M170.7,174.7c20.1-56.3,64.8-102.8,120.5-124.7c58.4-22.9,130.1-19.8,183.3,15c26.7,17.4,49.1,43.6,53.9,75.9c0,0.1,0.3,1.6,0.7,1.5c37.2-15.3,81.9-16,116.3,6.8c30.6,20.2,50.6,56.7,40.1,93.4c-5.4,18.9-17.7,35.5-34.9,45.3c-0.9,0.5-0.8,5.8,0.4,6c51.6,8.5,96,54.4,98.2,107.5c2.2,55.1-36.9,105.9-90.6,117.8c-30.1,6.7-62.5,1.9-88.8-14.3c-0.1-0.1-0.3-0.1-0.4,0c-28.2,26.7-64.4,44.4-102.9,50.2c-38.2,5.7-77.6-0.9-112-18.3c-19.2-9.7-36.7-22.6-51.6-38.1c-0.1-0.1-0.3-0.1-0.4,0c-11.5,17.1-35.4,18.5-54.1,19.5c-21.5,1.2-43.3-0.2-64.4-4.3c-41.7-8.3-81.2-28.1-109.3-60.5c-28.5-32.8-44.4-75.8-46.9-119c-2.5-44.8,8.9-93.1,40.8-126.2c31.6-32.8,79.3-48.3,124-40.1c0.9,0.2,1.4-6.5-0.2-6.8c-43.4-7.9-89.8,6.9-121.3,37.7c-34.2,33.4-46.5,83.5-45.1,130c1.3,44.5,15.6,89.2,43.5,124.2c29.5,37.1,73.2,59.2,119.4,67.4c23.1,4.1,46.7,4.9,70.1,2.8c10.5-1,21.4-2.5,30.9-7.4c2-1.1,4-2.3,5.8-3.7c2.2-1.7,3.7-4.1,5.8-5.7c1.1-0.9,0.2-1.5,2.3-1.1c0.8,0.2,2.8,2.8,3.4,3.4c2.3,2.3,4.7,4.4,7.1,6.6c36,31.6,84.2,49.1,132.2,47.2c24.2-1,48.1-6.7,70.1-16.6c10.7-4.8,21-10.6,30.7-17.3c4.9-3.4,9.7-7,14.2-10.9c2-1.7,3.9-3.9,6.1-5.4c3.4-2.3,5.3-0.1,8.6,1.6c39.7,21.1,91.5,17.8,127.5-9.4c33.6-25.4,50.8-69,46.7-110.6c-4.1-41.9-31.5-79.1-69.6-96.8c-9.5-4.5-19.6-7.5-30-9.3c0.1,2,0.2,4,0.4,6c31.7-17.9,44.8-58,36.6-92.5c-9.3-38.9-43.9-67.3-82.5-74.2c-25.7-4.6-52.3-0.6-76.3,9.3c0.2,0.5,0.4,1,0.7,1.5C520.5,77.7,460.5,42.1,405,32.6c-64.8-11-132.3,9-180.1,54.2c-24.6,23.3-43.5,52.2-54.8,84.2C169.8,171.9,170.4,175.5,170.7,174.7L170.7,174.7z"/>
                                <path fill="#F8ecc9" d="M532.7,129.8c40.3-12.7,88.2-23.3,126.3,1.3c15.5,10,27.8,24.6,35.3,41.4c8.9,20.2,9.2,42,1.3,62.6c-7.6,19.8-21.7,36.8-40.2,47.5c-0.7,0.4-0.6,5.6,0.1,5.9c49.4,18.5,69.1,77.8,76.4,125.3c4.8,31.5,1.5,64.1-18.1,90.3c-15.6,20.8-38.9,35.6-64.3,41.1c-31.6,6.8-65.1-0.2-92.3-17.3c0,0-0.1,0.1-0.1,0.1c-28,30.3-68.6,48-109.9,48.4c-39.6,0.4-77.8-16.2-105.6-44.3c-15.7-15.8-27.8-34.9-35.1-56c-0.3-0.8-0.5,0.1-0.6,0.5c-2.9,19.2-23.7,28.8-40.3,33.4c-21.1,6-43.3,8.2-65.2,6.5c-41.2-3.1-80.4-20.4-109.5-49.8c-13.5-13.6-24.6-29.6-32.5-47c-9.9-21.9-14-45.9-14.4-69.9c-0.8-44.3,7.4-90.9,38.2-124.5c29.1-31.6,71.2-48.5,113.4-52.6c0.5-0.1,0.4-3,0.4-3.2c-0.5-20.5,10.7-39.9,22.6-55.8c10.1-13.6,22.1-25.9,35.4-36.4c25.9-20.6,56.7-35.1,89.2-41.9c65.3-13.7,132.8,6.4,181.2,52c26.8,25.2,47.1,57.2,57.3,92.6c0.4,1.5,0.7-1.1,0.8-1.3c0.3-1.5,0.1-3.5-0.3-4.9c-18.6-64.4-70-117.5-133.2-139.3c-65.9-22.7-141.1-6.8-195.1,36.4c-29.5,23.6-59.6,58.9-58.8,98.7c0.1-1.1,0.3-2.1,0.4-3.2c-43.2,3.4-86.7,22.1-115.6,55c-32.6,37.1-39,89.9-36.5,137.5c1.3,24.4,6.1,48.7,16.9,70.7c9.7,19.9,23.7,37.7,40.6,52.2c37.4,32.1,87.5,45.6,136.2,39.9c20.7-2.4,45.8-7.1,61-22.8c3.3-3.5,6-7.5,7.5-12.1c0.1-0.4,1-4.6,1.2-4.6c0,0,2.5,6.7,2.8,7.6c4.1,9.8,9.2,19.2,15.4,28c24.7,35.2,64.4,59.8,107.4,63.9c44.4,4.3,90.5-12.2,121.7-44.2c0.7-0.7,1.8-2.4,2.6-2.8c2.1-0.9,3.6,0.6,5.2,1.5c2.4,1.4,4.9,2.7,7.4,3.9c6,2.9,12.3,5.5,18.7,7.5c11.7,3.7,23.9,5.7,36.2,5.9c23,0.3,45.6-6.2,64.6-19.1c18.1-12.3,32.5-30,39.8-50.7c7.9-22.4,7.9-46.9,4.7-70.2c-5.6-41-19.3-88.9-52.5-116.4c-7.5-6.3-16.1-11.2-25.2-14.6c0,2,0.1,3.9,0.1,5.9c34.3-19.9,51.9-60.1,45.7-98.9c-3.1-19.5-12.6-37.8-26.5-51.7c-15.6-15.8-36.1-24.8-58.1-26.9c-28.6-2.7-57.1,5-84.1,13.8C531.7,125,532.6,129.9,532.7,129.8L532.7,129.8z"/>
                                <path fill="#eb9f9f" d="M561.8,517.6c-2.4,21.5-18,38.6-35.1,50.5c-17.9,12.5-38.8,21-60.2,24.9c-41,7.6-83.6-2.1-115.9-28.8c-17.2-14.3-30.8-32.8-38.6-53.7c-0.1-0.1-0.1-0.1-0.2,0c-21,34.9-70,43.7-107.3,39.2c-40.8-4.9-78.4-25.6-105.8-55.9c-27.7-30.6-45.5-69.6-53.3-109.9c-8.8-45.2-4.5-94.4,19.1-134.7c21.8-37.3,59.6-64.9,102.9-70.1c0.7-0.1,0.2-4.9,0.2-5.5c-5.3-34.4,16.6-67.4,42.2-88.2C234,65.6,263.8,52,294,43.9c60.1-16,124.7-9.2,179.9,19.4c30.1,15.6,56.8,37.1,78.4,63.2c0,0,0.1,0.1,0.1,0.1c38.5-21.5,89.1-22.7,124.6,5.8c15.4,12.4,27.3,29.7,32.8,48.8c6.1,21.6,1.5,43.7-11,62.1c-12.4,18.2-31.7,31.5-53.8,34.3c-0.8,0.1-0.7,6.6,0.2,6.7c57.5,11,98.8,63.5,110.9,118.7c4.3,19.8,5.5,40.8-2.2,59.9c-5.6,14-15.4,26.2-26.9,35.8c-24.8,20.8-57.5,30.9-89.4,32.7c-37.7,2.2-75.5-6.9-109.6-22.8c0.2,0.1-1.3,6,0.2,6.7c61.7,28.9,145.1,36.5,200.2-10.8c12-10.3,21.8-23.1,27.1-38c5.8-16.1,6.1-33.8,4.2-50.7c-3.4-30.2-14.7-59.6-32.7-84.1c-20-27.1-48.5-47.9-82-54.2c0.1,2.2,0.1,4.5,0.2,6.7c24.1-3.1,44.9-18.6,57-39.3c11.5-19.7,14.1-43.4,9-65.5c-5.8-24.8-21.9-46.7-43.4-60.2c-23.9-15-53.7-18.4-81-12.5c-7,1.5-13.9,3.6-20.5,6.2c-3.1,1.2-6.1,2.5-9,4c-1.8,0.9-3.9,2.7-6,1.6c-1.3-0.7-2.6-3.1-3.6-4.3c-8.8-10.1-18.4-19.4-28.7-28c-21.3-17.7-45.6-31.8-71.5-41.7C392,23.6,329.8,23.6,274,43.7c-51,18.4-106.5,56.7-108.2,116.5c-0.2,6,0.2,12,1.1,18c0.1-1.8,0.1-3.7,0.2-5.5C103.2,179.1,57,235.5,44.6,295.5c-12.8,62.1,1.9,131.8,38.2,183.7c36.8,52.5,101,86.5,165.8,74.5c15.6-2.9,31.1-8.4,44.1-17.6c6.1-4.3,11.6-9.5,16-15.6c0.7-0.9,2.1-3.9,3.1-3.8c1.2,0.1,1.8,3,2.2,4.1c1.5,3.6,3.3,7.1,5.2,10.5c14.3,25.9,37.7,46.4,64.7,58.1c30.6,13.2,65.4,14.2,97.3,5.1c29.2-8.3,61.9-26,75.6-54.5c2.9-6.1,4.7-12.6,5.4-19.3C562.3,520.1,562,515.8,561.8,517.6L561.8,517.6z"/>
                            </svg>
                        </div>
                    </div>
                        <?php if( ! is_single() ) { ?>
                          <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
                        <?php } else { the_post_thumbnail('handdrawn-size'); } ?>
                </div>
            </div><!-- end .row -->   
    <?php } ?>
<?php endif;

if ( ! function_exists( 'handdrawn_article_intro_cloud_clip_textpath' ) ) :

    function handdrawn_article_intro_cloud_clip_textpath(){ ?>
        <?php global $post; ?>
        <h1 class="screen-reader-text"><?php if( ! is_single() ) { ?><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> <?php } else { the_title(); } ?></h1>
        <div class="row circle-clip">
            <div class="large-12 small-centered columns post-thumb">
                <div class="clip-mask">
                    <?php if( ! is_single() ) { ?>
                    <a href="<?php the_permalink(); ?>">
                    <?php } ?>
                    <div class="svg-container">
                        <!-- the textpath used to layout the title text along a circle -->
                        <svg version="1.1" preserveAspectRatio="xMinYMin meet" viewBox="0 0 803 602" enable-background="new 0 0 803 602" class="svg-content">
                            <defs>
                                <path id="author-path" fill="none" stroke="none" d="M221.3,171.4c40.3-56,106-92.4,180.2-92.4c122.6,0,222,99.4,222,222s-99.4,222-222,222s-222-99.4-222-222c0-45.5,13.7-87.7,37.1-122.9"/>
                            </defs>
                            <path fill="#fff" d="M-5-4v610h811V-4H-5z M594.7,409.6c-16.3,19.5-42.2,36.3-68.3,35c-8.2-0.4-14.2-3.8-21.5-5.7c-10.5-2.8-5-5.7-15.2,0.7c-12.5,7.8-19.9,25.8-34.1,32.2c-27.1,12.1-54.8,10.3-82.8-4.4c-8.8-4.6-19.6-12.8-25.7-20.1c-3.9-4.6-2-10.9-9.7-12.2c-4.7-0.8-15.2,6-20.8,7.1c-24.8,4.6-55.5-3-76.8-17.1c-12.8-8.5-25.9-24.1-35.5-35.8c-5.6-6.8-11.6-18-13.7-26.5c-1.3-4.9,1.1-17.4-4-15.5c1.5-6.7-0.7-11.8-2.1-18.1c1.1-1.8,1.8-3.7,2.1-5.8c-1.3-2.6-2.9-4.9-5-6.9c-0.6-13.5,2.5-39.1,7.5-51c9.5-23,31.5-56.3,53.5-66.8c22.5-10.8,17.9-17.9,26.5-39.2c3.5-8.7,10.6-18.9,15.9-26.3c18.9-26.1,48.6-32.8,76.3-44.9c21.3,0,40.8,2.9,58.8,14.6c11.2,7.3,23.4,11.7,32.7,20.9c4.4,4.3,8.2,10.9,11.7,16c2.4,3.4,5.2,6.4,8.4,9c-0.1,3.2,0,6.3,0.2,9.5c9.3-2.9,0.5,5,7.8,5.1c2.8,0.1,10.8-5.4,14.9-6.2c17.5-3.4,32.8-2.3,47.3,8.3c29.8,21.8,31.5,55.8,23.6,89.3c-1.4,6-6.8,14-3.2,20.6c3.1,5.6,9.2,4.4,11.7,6.8c8.9,8.6,20.8,22.6,26.5,33.6C614.7,340.2,613.4,387.2,594.7,409.6z"/>
                            <path fill="#99b897" d="M252.4,196.4c5.9-39,33.5-73.1,69.5-88.8c36.4-16,78.6-9.8,110.8,12.8c18.3,12.8,32.9,30.5,41.2,51.3c0.1,0.2,0.3,0.7,0.6,0.3c7.8-10.8,21.9-13,34.4-12.7c14.6,0.4,29.2,3.8,42,10.8c24.6,13.3,43.8,43.1,32.9,71.2c-5.4,13.8-16.3,25.1-30.3,29.9c-1.4,0.5-1,6.4,0.2,7c69,34.3,45.8,148.3-20.8,171.2c-17.3,5.9-36.4,6-53.1-1.7c-0.3-0.1-0.6,1-0.6,1c-5,26.5-43.5,29-64.4,28.7c-15.2-0.3-30.4-2.7-44.9-7.2c-11.4-3.6-30.1-10.3-31-24.7c0-0.2-0.5-3.3-1.2-2.4c-13.4,17.4-41.5,12.8-59.7,6.9c-20.8-6.7-39.3-19.5-53.6-36c-33.8-38.9-38.7-95.2-19.6-142c9.4-23,25.6-44.5,49.5-53.3c1.6-0.6,0.9-6.4,0.1-7.5c-10.4-13.5-4.1-30.7,2.9-44.4c7.2-14,16-27.2,26.1-39.3c1.2-1.5-0.4-7.3-0.6-7c-12.7,15.4-25,33.1-31.7,52.1c-5.1,14.5-7,33,3,45.9c0-2.5,0-5,0.1-7.5c-47.4,17.7-64.2,79.1-62.1,124.7c2.2,49.1,28.2,95.4,73.9,116.3c20.1,9.2,56.2,18.6,72.4-2.3c-0.4-0.8-0.8-1.6-1.2-2.4c0.9,13.6,11.5,21.6,23.3,26.5c16.3,6.7,34.2,10,51.7,10.6c23.7,0.8,63.3-2,68.5-31.5c-0.3,0.6-0.5,1.2-0.8,1.7c35.3,15.3,75.1-1.2,96.1-31.7c20.8-30.1,27.2-72.8,15.2-107.4c-6.6-19-19.6-35.5-37.8-44.4c0.1,2.3,0.1,4.7,0.2,7c33.8-11.7,42.8-53.4,28.3-83.2c-8.4-17.4-23.7-30-41.6-36.8c-16.7-6.2-39.5-9.5-56.1-1.3c-3.4,1.7-5.7,3.9-8.6,6.3c-2.3,1.9-2,0.3-3.1-2.1c-1.1-2.4-2.2-4.7-3.5-7.1c-3.9-7.2-8.6-14-13.9-20.3c-11.1-12.9-25-23.4-40.4-30.7c-31.9-15.1-68.8-15-100.1,1.5c-33.6,17.7-57.9,51.1-63.2,88.8C251.4,194.3,252.1,198.4,252.4,196.4L252.4,196.4z"/>
                            <path fill="#F8ecc9" d="M495.4,437.9c-17,27.3-42,51.6-75,56.3c-15.7,2.2-32-0.4-45.4-9.2c-12.7-8.3-22.5-21.6-24.4-36.9c0-0.2-0.7-3.1-1.2-1.7c-4.5,11.2-19.7,13.7-30.3,15c-11.3,1.3-22.8,0.5-33.9-2c-23.1-5.2-44.5-17.9-60.4-35.4c-35.2-38.7-42-96.7-27.4-145.6c8.1-26.9,23-51.6,44.7-69.7c1.4-1.1,0.7-5,0.1-6.4c-4.7-10.7,6-26.6,11.8-35.6c5.3-8.3,11.5-15.9,18.4-22.9c13.7-13.9,30.3-25.1,48.3-32.6c37.5-15.6,80-13.4,116.3,4.4c20.8,10.2,39.2,25.3,52.8,44c0.1,0.3,0.3,0.4,0.6,0.5c33.3-8.4,73.1-4,94.4,26c9.7,13.7,13.4,30.5,5.9,46c-6.9,14.4-20.9,25.3-37.2,25.7c-1.7,0-1.5,7,0.2,7.5c40.5,11.6,55.9,59.3,52.2,97.3c-4.2,42.3-30.6,82.2-72.7,94c-21.9,6.2-45.9,4.4-65.8-7.1c-1.2-0.7-1.9,5.8-0.4,6.7c39.7,23.8,91.8,7.6,118.2-28.2c25.4-34.4,31.1-84.7,15.1-124.2c-8.5-21-24-39.8-46.6-45.9c0.1,2.5,0.1,5,0.2,7.5c16.8-0.7,31.1-11.9,38.3-26.7c7.1-14.7,6.7-32.3,0.4-47.2c-15.8-37.4-58.9-47.5-95.5-40.4c-2.1,0.4-5.2,1.7-7.1,0.6c-1.3-0.8-2.8-3.7-3.9-5c-3-3.7-6.3-7.3-9.7-10.7c-6.6-6.6-13.9-12.6-21.7-17.8c-15.2-10.2-32.4-17.6-50.3-21.5c-35.5-7.9-72.6-1.3-103.6,17.5c-17.2,10.5-32.4,24.4-44,40.9c-10.2,14.5-23.1,35.2-15.2,53.3c0-2.1,0.1-4.3,0.1-6.4c-40.9,33.8-57.1,91.1-52.3,142.5c4.8,51.9,34.3,100.7,85.4,117.8c13.6,4.6,28.1,6.5,42.4,5.2c11.7-1.1,28.4-3.6,33.3-16.1c-0.4-0.6-0.8-1.1-1.2-1.7c2.9,22.7,19.7,41.3,41.5,47.8c27.1,8,56-2.4,76.8-20.2c11.5-9.9,20.9-21.9,28.8-34.9C496.7,441.4,495.6,437.7,495.4,437.9L495.4,437.9z"/>
                            <path fill="#eb9f9f" d="M336.1,435.7c-19.9,13.5-45.5,15.1-68.1,8.2c-23.6-7.2-43.1-23.8-58.4-42.7c-16.8-20.9-31.4-45.8-35.5-72.6c-4.1-26.7,2.3-54.7,17.1-77.3c14.6-22,36.5-38.6,61.6-46.8c1.4-0.4,0.7-4.8,0.4-5.7c-6.9-22.1,8.5-47,22.1-63.6c12.6-15.4,28.7-28,46.8-36.4c35.6-16.6,77.3-14.6,111,6c18.4,11.2,33.6,27.4,42.6,47.1c0.1,0.3,0.4,0.6,0.7,0.4c26.6-23.8,66.2-17.2,90.1,6.9c13.1,13.2,24.1,32.5,18.9,51.5c-4.3,15.7-16.6,28.8-32,34c-1.4,0.5-1.3,6.9,0.2,7.2c16.2,2.9,28.1,16,35.6,29.9c8.6,15.9,13,34,13.1,52c0.3,34.9-15.9,70.3-44.9,90.3c-14.9,10.3-32.8,15.6-50.9,12.9c-0.4-0.1-0.7,0.9-0.7,1.1c-7.2,29.7-37.8,47.5-66.2,52.1c-30,4.8-60.8-3.9-83.4-24.2c-12.7-11.4-22.4-25.8-28-41.9c-1.1-3-1.7,3.7-1.2,4.9c9.7,27.8,30.9,51,58.4,62.2c30.3,12.4,67.3,9.2,94.4-9.6c13.4-9.3,23.8-22.5,27.7-38.4c-0.2,0.4-0.5,0.7-0.7,1.1c36.5,5.5,69.4-21.1,84.8-52.3c16.4-33.4,17.2-74.9,2.3-108.9c-7.6-17.5-20.5-34.7-40.4-38.4c0.1,2.4,0.1,4.8,0.2,7.2c15.9-5.4,28.1-18.7,32.9-34.7c5.2-17.3,1.2-35.7-8.3-50.7c-19.6-31-60.7-47.7-94-27.5c-1.7,1-3.4,2.2-5,3.4c-2.4,1.8-2.8,3-4.3,0c-1.9-3.8-4-7.5-6.3-11c-4.9-7.4-10.7-14.2-17.3-20.2c-12.7-11.6-28.1-20.4-44.5-25.5C372.2,74.7,335,81.7,305,101.5c-16.9,11.2-31.4,26.2-41.7,43.7c-10.3,17.4-17.3,38.3-11,58.4c0.1-1.9,0.3-3.8,0.4-5.7c-50,16.6-82.4,64.6-81.2,117c0.6,27.7,11.2,52.9,26.4,75.8c14.5,21.9,33.1,41.9,57.1,53.4c25.7,12.3,57.6,13,81.5-3.6C337.4,439.7,336.6,435.4,336.1,435.7L336.1,435.7z"/>
                            <text x="18px" class="title-textpath handy"  fill="#99b897" stroke="none">
                                <textPath xlink:href="#author-path"><?php the_title(); ?></textPath>
                            </text>
                        </svg>
                    </div>
                    <?php if( ! is_single() ) { ?>
                    </a>
                    <?php } ?>
                </div>
                            <?php if( ! is_single() ) { ?>
                              <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
                            <?php } else { the_post_thumbnail('handdrawn-size'); } ?>
            </div>
            <?php if( ! is_page()) { ?>
            <p class="post-informations small-12 columns handy under-thumbnail">
                <span class="icon-calendar"></span><span><?php echo get_the_date(); ?></span>
                <span class="icon-speech-bubble-single"></span><span><?php comments_number('0'); ?></span>
                <span class="icon-folder"></span><span><?php the_category( ', ' ); ?></span>
            <?php if ( has_tag()) { ?>
                <span class="icon-tag"></span><span><?php the_tags('', ' ', ''); ?></span>
            <?php } ?>
            <span><?php _e(' by ', 'handdrawn-lite'); esc_url( the_author_posts_link() ); ?></span></p>
            <?php } ?>
        </div><!-- end .row -->   
    <?php } ?>
<?php endif; 

if ( ! function_exists( 'handdrawn_lite_comment' ) ) :
/**
 * Template for comments.
 *
 */
function handdrawn_lite_comment( $comment, $args, $depth ) {
    $GLOBALS['comment'] = $comment; ?>
    <li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
        <div class="comment-content">
            <div class="row">
                <?php if('square' == get_theme_mod('handdrawn_comment_author_style')) { ?>
                <div class="comment-author comment-author-square large-2 columns">
                            <?php echo get_avatar( $comment, 80 ); ?>
                </div><!-- end .comment-author -->
                <?php } else { ?>
                <div class="comment-author comment-author-circle large-2 columns">
                            <?php echo get_avatar( $comment, 80 ); ?>
                </div><!-- end .comment-author -->   
                <?php } ?>
                <div class="comment-informations handy large-10 columns">
                    <p><strong> <?php comment_author(); ?></strong><?php _e( ' on ', 'handdrawn-lite' ); ?>
                    <time datetime="<?php comment_time('c'); ?>"><?php echo get_comment_date('M j Y'); ?></time></p>
                </div><!-- end .comment-informations -->
                <div class="comment-text small-12 large-10 large-offset-2 columns">
                    <?php comment_text(); ?>
                    <?php edit_comment_link(__(' edit comment', 'handdrawn-lite'), '<span>', '</span>'); ?>
                    <?php if ( $comment->comment_approved == '0' ) : ?>
                        <em><?php _e( 'Your comment is awaiting moderation.', 'handdrawn-lite' ); ?></em>
                        <br />
                    <?php endif; ?>
                    <p class="reply-to-comment handy">
                    <?php comment_reply_link( array_merge( $args, array( 'reply_text' => __('reply','handdrawn-lite'),  'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
                    </p>
                </div><!-- end .comment-text -->               
            </div><!-- end .row -->            
        </div><!-- end .comment-content -->
    </li>
<?php } ?>
<?php endif; 
