<?php
/**
 * @package WordPress
 * @subpackage Halftone theme
 */

get_header(); ?>

	<div class="narrowcolumn" role="main">

	<?php if (have_posts()) : ?>

		<?php while (have_posts()) : the_post(); ?>

			<div <?php post_class() ?> id="post-<?php the_ID(); ?>">
				<h1><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
				
				<?php $img = get_post_meta($post->ID, 'thumb', true); 
					if($img != null)
						echo "<img src=\"$img\" alt='' width='530' style='padding: 5px; border: 1px solid silver;'/>";?>
				<div class='clear'></div>
				<div class='meta'>
					<img src="<?php bloginfo('template_directory'); ?>/images/clock.gif" alt=''  style='vertical-align: middle'/> <?php the_time('F jS, Y') ?> &nbsp;&nbsp;
					<img src="<?php bloginfo('template_directory'); ?>/images/folder.gif" alt='' style='vertical-align: middle'/> Posted in <?php the_category(', ') ?>
				</div>
				<div class='clear'></div>
				
					<?php the_content('<b>Read more</b>'); ?>
				

				<div style='border-bottom: 1px dotted #ccc; text-align: right; margin-top: -12px'>
					<img src="<?php bloginfo('template_directory'); ?>/images/comment.gif" alt='' style='vertical-align: middle'/> <?php comments_popup_link('No Comments', '1 Comment', '% Comments'); ?>
				</div>
			</div>

		<?php endwhile; ?>

		<div class="navigation">
			<div class="alignleft"><?php next_posts_link('&laquo; Older Entries') ?></div>
			<div class="alignright"><?php previous_posts_link('Newer Entries &raquo;') ?></div>
		</div>

	<?php else : ?>

		<h2 class="center">Not Found</h2>
		<p class="center">Sorry, but you are looking for something that isn't here.</p>
		<?php get_search_form(); ?>

	<?php endif; ?>

	</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
