<?php
/**
 * @package WordPress
 * @subpackage Halftone theme
 */
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>

<head profile="http://gmpg.org/xfn/11">
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />

<title><?php wp_title('&laquo;', true, 'right'); ?> <?php bloginfo('name'); ?></title>

<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

	


<?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); ?>

<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div class="full-page">

	<div class="header">
		<div id="logo">
			<?php $logo = get_option('halftone_logo_url');
			if($logo != null){
				echo "<a href=\"".get_option('home')."\"><img src=\"$logo\" alt='Logo' /></a>"; 
			} else { ?>
			<br/><h1><a href="<?php echo get_option('home'); ?>/"><?php bloginfo('name'); ?></a></h1>
			<?php } ?>
		</div>
		<div id="search">
			<form method="get" id="searchform" action="<?php bloginfo('url'); ?>/">
				<label class="hidden" for="s"><?php _e('Search for:'); ?></label>
				<input type="text" value="<?php the_search_query(); ?>" name="s" id="s" class="text"/>
				<input type="image" src="<?php bloginfo('template_directory'); ?>/images/btn-search.gif" alt="Search" class="image"/>
				
			</form>
		</div>
		<div id="quote">
			<i><?php bloginfo('description'); ?></i>
		</div>
		<div id="nav">
			<ul class="dropdown">
	   			<?php if (is_page()) { $highlight = "page_item"; } else {$highlight = "page_item current_page_item"; } ?>
	            <li class="b <?php echo $highlight; ?>"><a href="<?php bloginfo('url'); ?>">Home</a></li>
		    	<?php wp_list_pages('sort_column=menu_order&depth=3&title_li=&exclude='.get_option('halftone_menu_cat')); ?>
		    	
	    	</ul>
		</div>
		<div class='clear'></div>
	</div><!-- /.header -->

