<?php
/**
 * @package WordPress
 * @subpackage Halftone Theme
 */

add_action('admin_menu', 'halftone_add_theme_page');

if ( function_exists('register_sidebar') ){
    register_sidebar();
    register_sidebar(array(
		'name' => 'Footer',
		'description' => 'Widgets in this area will be shown in the footer.',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
   		'after_widget'  => '</div>')
    );
}

function halftone_init() {
	// add_option('variable name','default value'
	// Category to show in the top menu //
	add_option('halftone_menu_cat', '1,2,3');
	// Featured category//
	add_option('halftone_featured_cat', 0); 
	//URL to logo
	add_option('halftone_logo_url', '');       
}

function halftone_add_theme_page(){
	// if variables are empty we call the function myDefault_init to set the default values
	if((get_option('halftone_featured_cat') == '')||(get_option('halftone_menu_cat') == '')){
			halftone_init();
	}
	if ($_GET['page'] == basename(__FILE__)) {
		//if the form was submited we saved the changes
		if ( 'save' == $_REQUEST['action'] ){
			
			if(isset($_REQUEST['halftone_featured_cat'])){
				update_option('halftone_featured_cat', $_REQUEST['halftone_featured_cat']);
			} else {
				update_option('halftone_featured_cat', 'Fill this field please');
			}
			
			if(isset($_REQUEST['halftone_menu_cat'])){
				update_option('halftone_menu_cat', $_REQUEST['halftone_menu_cat']);
			} else {
				update_option('halftone_menu_cat', 'Fill this field please');
			}
			
			if(isset($_REQUEST['halftone_logo_url']))
				update_option('halftone_logo_url', $_REQUEST['halftone_logo_url']);
			
			header("Location: themes.php?page=functions.php&saved=true");die;
		}
	// Addd the header (css + script) to the control panel
	add_action('admin_head', 'halftone_theme_page_head');}
	//add_menu_page(page_title, menu_title, access_level/capability,file,[function]);
	add_theme_page('Halftone Options', 'Halftone Options', 'edit_themes', basename(__FILE__), 'halftone_theme_page');
}


function halftone_theme_page(){
	if ( $_REQUEST['saved'] ) 
		echo '<div id="message" class="updated fade"><p><strong>Options Saved</strong></p></div>';
	?>
	<div class="wrap">
		<div id="myDefault">
		<h2>Halftone Theme Options</h2>
		<form name="halftone" method="post" action="">
			<input type="hidden" name="action" value="save" />
			<table class="optiontable">
			<tbody>
			<tr>
			<th>Page IDs to EXCLUDE from the <em> navigation menu</em>:</th>
			<td><input name="halftone_menu_cat" id="halftone_menu_cat" type="text" class="code" value="<?php echo get_option('halftone_menu_cat'); ?>" /><br/></td>
			</tr>
			<tr>
			<th>Logo URL:</th>
			<td><input name="halftone_logo_url" id="halftone_logo_url" type="text" class="code" value="<?php echo get_option('halftone_logo_url'); ?>" /><br/>
				Maximum logo size (in px): 380 x 250</td>
			</tr>
			</tbody>
			</table>
			<p class="submit"><input type="submit" name="Save" value="Apply" /></p>
		</form>
		<br/><br/>
		Use the posts custom filed name of "thumb" for images on the home page.
		</div>
	</div>
<?php }



function halftone_theme_page_head()
{	// header Css+Script ...?>
	<style type="text/css">
	p {margin-left:4px;}
	#myDefault {margin:5px;padding:10px;}	
	</style>
<?php }
