<?php

/*-----------------------------------------------------------------------------------*/
/* Enqueue scripts */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('haaski_diary_enqueue_scripts')) {

	function haaski_diary_enqueue_scripts() {

		wp_enqueue_style(
			'owl.carousel',
			get_stylesheet_directory_uri() . '/assets/css/owl.carousel.css',
			array(), '2.3.4'
		);

		wp_enqueue_style(
			'owl.theme.default',
			get_stylesheet_directory_uri() . '/assets/css/owl.theme.default.css',
			array(), '2.3.4'
		);

		wp_enqueue_style(
			'haaski-diary-owl-theme',
			get_stylesheet_directory_uri() . '/assets/css/haaski.diary.owl.theme.css',
			array(), '1.0.0'
		);

		wp_enqueue_script(
			'owl.carousel',
			get_stylesheet_directory_uri() . '/assets/js/owl.carousel.js',
			array('jquery'),
			'2.3.4',
			TRUE
		);

		wp_enqueue_script(
			'jquery.ticker',
			get_stylesheet_directory_uri() . '/assets/js/jquery.ticker.js',
			array('jquery'),
			'1.2.1',
			TRUE
		);

		wp_deregister_style( 'google-fonts' );
		wp_deregister_style( 'savana-lite-style' );
		wp_deregister_style( 'savana-lite-' . esc_attr(get_theme_mod('savana_lite_skin', 'orange')) );

		wp_enqueue_style( 'haaski-diary-parent-style' , get_template_directory_uri() . '/style.css' );
		wp_enqueue_style( 'haaski-diary-style' , get_stylesheet_directory_uri() . '/style.css' );

		wp_enqueue_style(
			'haaski-diary-' . esc_attr(get_theme_mod('savana_lite_skin', 'orange')),
			get_stylesheet_directory_uri() . '/assets/skins/' . esc_attr(get_theme_mod('savana_lite_skin', 'orange')) . '.css',
			array( 'haaski-diary-style' ),
			'1.0.0'
		);

		wp_enqueue_script(
			'haaski-diary-script',
			get_stylesheet_directory_uri() . '/assets/js/script.js',
			array('jquery'),
			'1.0.0',
			TRUE
		);

		$googleFontsArgs = array(
			'family' =>    str_replace('|', '%7C', haaski_diary_google_font_args()),
			'subset' =>    'latin,latin-ext'
		);

		wp_enqueue_style('google-fonts', add_query_arg ( $googleFontsArgs, "https://fonts.googleapis.com/css" ), array(), '1.0.0' );

	}

	add_action( 'wp_enqueue_scripts', 'haaski_diary_enqueue_scripts', 999);

}

/*-----------------------------------------------------------------------------------*/
/* Replace hooks */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('haaski_diary_replace_hooks')) {

	function haaski_diary_replace_hooks() {

		remove_action( 'post_class', 'savana_lite_post_class');

		remove_action( 'savana_lite_mobile_menu', 'savana_lite_mobile_menu_function' );
		remove_action( 'savana_lite_slick_slider', 'savana_lite_slick_slider_function');
		remove_action( 'savana_lite_thumbnail', 'savana_lite_thumbnail_function', 10, 2 );
		remove_action( 'savana_lite_before_content', 'savana_lite_before_content_function' );
		remove_action( 'savana_lite_archive_title', 'savana_lite_archive_title_function' );
		remove_action( 'savana_lite_searched_item', 'savana_lite_searched_item_function' );
		remove_action( 'savana_lite_postformat', 'savana_lite_postformat_function' );

		remove_action( 'savana_lite_default_format', 'savana_lite_default_format_function' );
		remove_action( 'savana_lite_image_format', 'savana_lite_image_format_function' );
		remove_action( 'savana_lite_link_format', 'savana_lite_link_format_function' );
		remove_action( 'savana_lite_quote_format', 'savana_lite_quote_format_function' );
		remove_action( 'savana_lite_page_format', 'savana_lite_page_format_function' );

		remove_filter('the_content_more_link', 'savana_lite_hide_excerpt_more');
		remove_filter('excerpt_more', 'savana_lite_hide_excerpt_more');
		remove_filter('get_the_excerpt', 'savana_lite_customize_excerpt_more' );

	}

	add_action('init','haaski_diary_replace_hooks');

}

/*-----------------------------------------------------------------------------------*/
/* Theme setup */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('haaski_diary_theme_setup')) {

	function haaski_diary_theme_setup() {

		remove_theme_support('custom-header');
		unregister_nav_menu( 'top-menu' );

		load_child_theme_textdomain( 'haaski-diary', get_stylesheet_directory() . '/languages' );

		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/functions/function-style.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/functions/google-fonts.php' );

		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/post/related-post.php' );

		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/post-formats.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/before-content.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/related-posts.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/featured-posts.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/mobile-menu.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/media.php' );

		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/post-formats/default-format.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/post-formats/image-format.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/post-formats/link-format.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/post-formats/quote-format.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/post-formats/page-format.php' );

		if ( !get_theme_mod('savana_lite_logo_text_color') )
			set_theme_mod( 'savana_lite_logo_text_color', '#616161' );

		if ( !get_theme_mod('savana_lite_logo_font_size') )
			set_theme_mod( 'savana_lite_logo_font_size', '40px' );

		if ( !get_theme_mod('savana_lite_logo_description_top_margin') )
			set_theme_mod( 'savana_lite_logo_description_top_margin', '10px' );

		if ( !get_theme_mod('savana_lite_screen3') )
			set_theme_mod( 'savana_lite_screen3', '1170' );

		if ( !get_theme_mod('savana_lite_screen4') )
			set_theme_mod( 'savana_lite_screen4', '1370' );

		if ( !get_theme_mod('savana_lite_home') )
			set_theme_mod( 'savana_lite_home', 'right-sidebar' );

		if ( !get_theme_mod('savana_lite_category_layout') )
			set_theme_mod( 'savana_lite_category_layout', 'right-sidebar' );

		if ( !get_theme_mod('savana_lite_search_layout') )
			set_theme_mod( 'savana_lite_search_layout', 'right-sidebar' );

	}

	add_action( 'after_setup_theme', 'haaski_diary_theme_setup', 999);

}

/*-----------------------------------------------------------------------------------*/
/* Customize register */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('haaski_diary_customize_register')) {

	function haaski_diary_customize_register( $wp_customize ) {

		$wp_customize->remove_section('slideshow_section');
		$wp_customize->remove_section('topmenu_section');
		$wp_customize->remove_control('savana_lite_enable_slideshow_overlay');
		$wp_customize->remove_control('savana_lite_enable_topbar');
		$wp_customize->remove_control('savana_lite_sticky_header');
		$wp_customize->remove_control('savana_lite_enable_header_search_form');
		$wp_customize->remove_control('savana_lite_enable_breadcrumb');
		$wp_customize->remove_control('savana_lite_enable_category_title');
		$wp_customize->remove_control('savana_lite_enable_searched_item');
		$wp_customize->remove_control('savana_lite_readmore_layout');
		$wp_customize->remove_control('savana_lite_enable_readmore_button');
		$wp_customize->remove_section('layouts_section');

		/* Slideshow section
		   ========================================================================== */

		$wp_customize->add_section('haaski_diary_homepage_slideshow_section', array(
			'title' => esc_html__( 'Homepage slideshow', 'haaski-diary' ),
			'description' => esc_html__( 'Homepage slideshow', 'haaski-diary' ),
			'priority' => 7,
			'panel' => 'general_panel',
		));

		/**
		 * Slideshow section > Slideshow category option
		 */

		$wp_customize->add_setting( 'haaski_diary_slideshow_category', array(
 			'default' => 'all',
 			'sanitize_callback' => 'haaski_diary_select_sanitize',
 		));

		$wp_customize->add_control( 'haaski_diary_slideshow_category' , array(
			'priority' => 8,
			'type' => 'select',
			'section' => 'haaski_diary_homepage_slideshow_section',
			'label' => esc_html__('Category','haaski-diary'),
			'description' => esc_html__('Please select the category of the slideshow.','haaski-diary'),
			'choices'  => haaski_diary_get_categories(),
		));

		/**
		 * Slideshow section > Slideshow layout option
		 */

		$wp_customize->add_setting( 'haaski_diary_post_slideshow_layout', array(
			'default' => 'layout-1',
			'sanitize_callback' => 'haaski_diary_select_sanitize',
		));

		$wp_customize->add_control( 'haaski_diary_post_slideshow_layout' , array(
			'priority' => 9,
			'type' => 'select',
			'section' => 'haaski_diary_homepage_slideshow_section',
			'label' => esc_html__('Grid layout','haaski-diary'),
			'description' => esc_html__('Please select one of available layouts for the desktop devices.','haaski-diary'),
			'choices'  => array (
			   'disable' => esc_html__( 'Disable','haaski-diary'),
			   'layout-1' => esc_html__( 'Layout 1','haaski-diary'),
			   'layout-2' => esc_html__( 'Layout 2','haaski-diary'),
			   'layout-3' => esc_html__( 'Layout 3','haaski-diary'),
				 'layout-4' => esc_html__( 'Layout 4','haaski-diary'),
				 'layout-5' => esc_html__( 'Layout 5','haaski-diary'),
				 'layout-6' => esc_html__( 'Layout 6','haaski-diary'),
				 'layout-7' => esc_html__( 'Layout 7','haaski-diary'),
			),
		));

		/**
		 * Slideshow section > Featured posts items option
		 */

		$wp_customize->add_setting( 'haaski_diary_featured_posts_items', array(
			'default' => '3',
			'sanitize_callback' => 'haaski_diary_select_sanitize',
		));

		$wp_customize->add_control( 'haaski_diary_featured_posts_items' , array(
			'priority' => 9,
			'type' => 'select',
			'section' => 'haaski_diary_homepage_slideshow_section',
			'label' => esc_html__('Slideshow items','haaski-diary'),
			'description' => esc_html__('Please note that, since it is a post grid, each slide contains 6 articles.','haaski-diary'),
			'choices'  => array (
			   '1' => esc_html__( '1 slide with 6 posts','haaski-diary'),
			   '2' => esc_html__( '2 slide with 12 posts','haaski-diary'),
			   '3' => esc_html__( '3 slide with 18 posts','haaski-diary'),
			   '4' => esc_html__( '4 slide with 24 posts','haaski-diary'),
			   '5' => esc_html__( '5 slide with 30 posts','haaski-diary'),
			),
		));

		/**
		 * Slideshow section > Exclude recent posts 
		 */

		 $wp_customize->add_setting( 'haaski_diary_exclude_slideshow_posts_on_loop', array(
			'default' => true,
			'sanitize_callback' => 'haaski_diary_checkbox_sanize',
			'transport'  => 'refresh'
		));

		$wp_customize->add_control( 'haaski_diary_exclude_slideshow_posts_on_loop', array(
			'label' => esc_html__( 'Exclude slideshow posts','haaski-diary'),
			'description' => esc_html__( 'Do you want to exclude the slideshow posts from the main homepage article loop (if the slideshow posts grid is enabled)?', 'giornale' ),
			'section' => 'haaski_diary_homepage_slideshow_section',
			'type' => 'checkbox',
		));

		/**
		 * Slideshow section > Slideshow dots option
		 */

		$wp_customize->add_setting( 'haaski_diary_slideshow_dots', array(
			'default' => true,
			'sanitize_callback' => 'haaski_diary_checkbox_sanize',
			'transport'  => 'refresh'
		));

		$wp_customize->add_control( 'haaski_diary_slideshow_dots', array(
			'label' => esc_html__( 'Show Dots','haaski-diary'),
			'section' => 'haaski_diary_homepage_slideshow_section',
			'type' => 'checkbox',
		));

		/**
		 * Main settins panel > General settings section > Related posts option
		 */

		$wp_customize->add_setting( 'haaski_diary_enable_related_posts', array(
			'default' => 'on',
			'sanitize_callback' => 'haaski_diary_checkbox_sanize',
		));

		$wp_customize->add_control( 'haaski_diary_enable_related_posts' , array(
			'type' => 'checkbox',
			'section' => 'settings_section',
			'label' => esc_html__('Related posts','haaski-diary'),
			'description' => esc_html__('Do you want to display the related posts at the end of each article?','haaski-diary'),
		));

		/* Main settins panel > Topbar section
		========================================================================== */

		 $wp_customize->add_section( 'haaski_diary_topbar_section', array(
 			'title' => esc_html__( 'Topbar','haaski-diary'),
 			'panel' => 'general_panel',
 			'priority' => 9,
 			'description' => esc_html__('From this section you can manage the topbar','haaski-diary'),
 		));

		/**
		 * Main settins panel > Topbar section > Enable topbar option
		 */

		 $wp_customize->add_setting( 'haaski_diary_enable_topbar_section', array(
 			'default' => 'on',
 			'sanitize_callback' => 'haaski_diary_checkbox_sanize',
 		));

 		$wp_customize->add_control( 'haaski_diary_enable_topbar_section' , array(
 			'type' => 'checkbox',
 			'section' => 'haaski_diary_topbar_section',
 			'label' => esc_html__('Topbar section','haaski-diary'),
 			'description' => esc_html__('Do you want to enable the topbar?','haaski-diary'),
 		));

		/**
		 * Main settins panel > Topbar section > Enable current date option
		 */

		 $wp_customize->add_setting( 'haaski_diary_enable_current_date', array(
 			'default' => 'on',
 			'sanitize_callback' => 'haaski_diary_checkbox_sanize',
 		));

 		$wp_customize->add_control( 'haaski_diary_enable_current_date' , array(
 			'type' => 'checkbox',
 			'section' => 'haaski_diary_topbar_section',
 			'label' => esc_html__('Site date','haaski-diary'),
 			'description' => esc_html__('Do you want to display the current date on your website?','haaski-diary'),
 		));

		/**
		 * Main settins panel > Topbar section > Enable topbar socials option
		 */

		 $wp_customize->add_setting( 'haaski_diary_enable_topbar_socials', array(
 			'default' => 'on',
 			'sanitize_callback' => 'haaski_diary_checkbox_sanize',
 		));

 		$wp_customize->add_control( 'haaski_diary_enable_topbar_socials' , array(
 			'type' => 'checkbox',
 			'section' => 'haaski_diary_topbar_section',
 			'label' => esc_html__('Social links','haaski-diary'),
 			'description' => esc_html__('Do you want to show the social links in the topbar?','haaski-diary'),
 		));

		/**
		* Main settins panel > Topbar section > Date format option
		 */

		$wp_customize->add_setting( 'haaski_diary_topbar_date_format', array(
			'default' => 'l, F j Y',
			'sanitize_callback' => 'haaski_diary_date_sanitize',
		));

		$wp_customize->add_control( 'haaski_diary_topbar_date_format' , array(
			'type' => 'text',
			'section' => 'haaski_diary_topbar_section',
			'label' => esc_html__('Date format','haaski-diary'),
			'description' => sprintf( wp_kses( __( '<a href="%s" target="_blank">To format the date, please refer to the online documentation for detailed instructions</a>.', 'haaski-diary' ), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://wordpress.org/support/article/formatting-date-and-time' ) ),
		));

		/* Main settins panel > News ticker section
		========================================================================== */

		 $wp_customize->add_section( 'haaski_diary_news_ticker', array(
 			'title' => esc_html__( 'News ticker','haaski-diary'),
 			'panel' => 'general_panel',
 			'priority' => 9,
 			'description' => esc_html__('From this section you can manage the news ticker section.','haaski-diary'),
 		));

		/**
		 * Main settins panel > News ticker section > Enable news ticker option
		 */

		 $wp_customize->add_setting( 'haaski_diary_enable_news_ticker', array(
 			'default' => 'on',
 			'sanitize_callback' => 'haaski_diary_checkbox_sanize',
 		));

 		$wp_customize->add_control( 'haaski_diary_enable_news_ticker' , array(
 			'type' => 'checkbox',
 			'section' => 'haaski_diary_news_ticker',
 			'label' => esc_html__('News ticker','haaski-diary'),
 			'description' => esc_html__('Do you want to enable the news ticker?','haaski-diary'),
 		));

		/**
		* Main settins panel > News ticker section > News ticker title option
		 */

		$wp_customize->add_setting( 'haaski_diary_news_ticker_title', array(
			'default' => esc_html__('Breaking news','haaski-diary'),
			'sanitize_callback' => 'sanitize_text_field',
		));

		$wp_customize->add_control( 'haaski_diary_news_ticker_title' , array(
			'type' => 'text',
			'section' => 'haaski_diary_news_ticker',
			'label' => esc_html__('Title','haaski-diary'),
			'description' => esc_html__('Insert the title for the news ticker','haaski-diary'),
		));

		/**
		 * Main settins panel > News ticker section > News ticker category option
		 */

		$wp_customize->add_setting( 'haaski_diary_news_ticker_category', array(
			'default' => 'all',
 			'sanitize_callback' => 'haaski_diary_select_sanitize',
 		));

		$wp_customize->add_control( 'haaski_diary_news_ticker_category' , array(
			'type' => 'select',
			'section' => 'haaski_diary_news_ticker',
			'label' => esc_html__('Category','haaski-diary'),
			'description' => esc_html__('Please select the category of the news ticker.','haaski-diary'),
			'choices'  => haaski_diary_get_categories(),
		));

		/**
		* Main settins panel > News ticker section > News ticker order option
		 */

		$wp_customize->add_setting( 'haaski_diary_news_ticker_order', array(
			'default' => 'date',
			'sanitize_callback' => 'haaski_diary_select_sanitize',
		));

		$wp_customize->add_control( 'haaski_diary_news_ticker_order' , array(
			'type' => 'select',
			'section' => 'haaski_diary_news_ticker',
			'label' => esc_html__('Order by','haaski-diary'),
			'description' => esc_html__('How you want to order the articles?.','haaski-diary'),
			'choices'  => array (
				'title' => esc_html__( 'Post title','haaski-diary'),
				'rand' => esc_html__( 'Randomly','haaski-diary'),
				'comment_count' => esc_html__( 'Comment count','haaski-diary'),
				'date' => esc_html__( 'Post date','haaski-diary'),
			),
		));

		/**
		* Main settins panel > News ticker section > News ticker sort order option
		 */

		$wp_customize->add_setting( 'haaski_diary_news_ticker_sort_order', array(
			'default' => 'desc',
			'sanitize_callback' => 'haaski_diary_select_sanitize',
		));

		$wp_customize->add_control( 'haaski_diary_news_ticker_sort_order' , array(
			'type' => 'select',
			'section' => 'haaski_diary_news_ticker',
			'label' => esc_html__('Sort order','haaski-diary'),
			'description' => esc_html__('Select the order of the articles.','haaski-diary'),
			'choices'  => array (
				'asc' => esc_html__( 'Ascending','haaski-diary'),
				'desc' => esc_html__( 'Descending','haaski-diary'),
			),
		));

		/**
		 * Main settins panel > News ticker section > News ticker limit option
		 */

		$wp_customize->add_setting( 'haaski_diary_news_ticker_limit', array(
			'sanitize_callback' => 'haaski_diary_limit_sanitize',
			'default' => 5,
		));

		$wp_customize->add_control( 'haaski_diary_news_ticker_limit' , array(
			'type' => 'number',
			'section' => 'haaski_diary_news_ticker',
			'label' => esc_html__('Post limit','haaski-diary'),
			'description' => esc_html__('Please select the category of the news ticker.','haaski-diary'),
			'input_attrs' => array('min' => 1)
		));

		/* Typography panel > Google Fonts section
		========================================================================== */

		$wp_customize->add_section( 'haaski_diary_fonts', array(
			'title' => esc_html__( 'Google Fonts','haaski-diary'),
			'panel' => 'typography_panel',
			'priority' => 9,
			'description' => esc_html__('From this section you can select one of the 17 Google Fonts included with Haaski Diary','haaski-diary'),
		));

		/**
		 * Typography panel > Google Fonts section > Site font option
		 */

		$wp_customize->add_setting( 'haaski_diary_body_font_family', array(
			'default' => 'Poppins:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic',
			'sanitize_callback' => 'haaski_diary_select_sanitize',
		));

		$wp_customize->add_control( 'haaski_diary_body_font_family' , array(
			'priority' => 9,
			'type' => 'select',
			'section' => 'haaski_diary_fonts',
			'label' => esc_html__('Site font','haaski-diary'),
			'description' => esc_html__('Choose the font for your website.','haaski-diary'),
			'choices' => haaski_diary_google_fonts(),
		));

		/* Featured links panel > Featured Link #4 section
		========================================================================== */

		$wp_customize->add_section( 'haaski_diary_featured_link_4', array(
			'title' => esc_html__( 'Featured Link #4','haaski-diary'),
			'panel' => 'featured_links_panel',
			'priority' => 10,
			'description' => esc_html__('Featured Link #4','haaski-diary'),
		));

		/**
		 * Featured links panel > Featured Link #4 section > Image option
		 */

		$wp_customize->add_setting( 'haaski_diary_featured_link_4_image', array(
			'default' => '',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'absint'
		));

		$wp_customize->add_control( new WP_Customize_Cropped_Image_Control($wp_customize, 'haaski_diary_featured_link_4_image', array(
			'label' => esc_html__( 'Image','haaski-diary'),
			'mime_type' => 'image',
			'description' => esc_html__( 'Upload the image','haaski-diary'),
			'section' => 'haaski_diary_featured_link_4',
			'settings' => 'haaski_diary_featured_link_4_image',
			'width' => 940,
			'height' => 627,
		)));

		/**
		 * Featured links panel > Featured Link #4 section > Title option
		 */

		$wp_customize->add_setting( 'haaski_diary_featured_link_4_title', array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
		));

		$wp_customize->add_control( 'haaski_diary_featured_link_4_title' , array(
			'type' => 'text',
			'section' => 'haaski_diary_featured_link_4',
			'label' => esc_html__('Title','haaski-diary'),
			'description' => esc_html__('Insert the title of this slide','haaski-diary'),
		));

		/**
		 * Featured links panel > Featured Link #4 section > URL option
		 */

		$wp_customize->add_setting( 'haaski_diary_featured_link_4_url', array(
			'default' => '',
			'sanitize_callback' => 'esc_url_raw',
		));

		$wp_customize->add_control( 'haaski_diary_featured_link_4_url' , array(
			'type' => 'url',
			'section' => 'haaski_diary_featured_link_4',
			'label' => esc_html__('Url','haaski-diary'),
			'description' => esc_html__('Insert the url of this slide','haaski-diary'),
		));

		/* Featured links panel > Featured Link #5 section
		========================================================================== */

		$wp_customize->add_section( 'haaski_diary_featured_link_5', array(
		    'title' => esc_html__( 'Featured Link #5', 'haaski-diary' ),
		    'panel' => 'featured_links_panel',
		    'description' => esc_html__( 'Featured Link #5', 'haaski-diary' ),
		));

		/**
		 * Featured links panel > Featured Link #5 section > Image option
		 */

		$wp_customize->add_setting( 'haaski_diary_featured_link_5_image', array(
		    'default' => '',
		    'capability' => 'edit_theme_options',
		    'sanitize_callback' => 'absint'
		));

		$wp_customize->add_control( new WP_Customize_Cropped_Image_Control( $wp_customize, 'haaski_diary_featured_link_5_image', array(
		    'label' => esc_html__( 'Image', 'haaski-diary' ),
		    'mime_type' => 'image',
		    'description' => esc_html__( 'Upload the image', 'haaski-diary' ),
		    'section' => 'haaski_diary_featured_link_5',
		    'settings' => 'haaski_diary_featured_link_5_image',
		    'width' => 940,
		    'height' => 627,
		)));

		/**
		 * Featured links panel > Featured Link #5 section > Title option
		 */

		$wp_customize->add_setting( 'haaski_diary_featured_link_5_title', array(
		    'default' => '',
		    'sanitize_callback' => 'sanitize_text_field',
		));

		$wp_customize->add_control( 'haaski_diary_featured_link_5_title', array(
		    'type' => 'text',
		    'section' => 'haaski_diary_featured_link_5',
		    'label' => esc_html__( 'Title', 'haaski-diary' ),
		    'description' => esc_html__( 'Insert the title of this slide', 'haaski-diary' ),
		));

		/**
		 * Featured links panel > Featured Link #5 section > URL option
		 */

		$wp_customize->add_setting( 'haaski_diary_featured_link_5_url', array(
		    'default' => '',
		    'sanitize_callback' => 'esc_url_raw',
		));

		$wp_customize->add_control( 'haaski_diary_featured_link_5_url', array(
		    'type' => 'url',
		    'section' => 'haaski_diary_featured_link_5',
		    'label' => esc_html__( 'Url', 'haaski-diary' ),
		    'description' => esc_html__( 'Insert the url of this slide', 'haaski-diary' ),
		));

		/* Featured links panel > Featured Link #6 section
		========================================================================== */

		$wp_customize->add_section( 'haaski_diary_featured_link_6', array(
		    'title' => esc_html__( 'Featured Link #6', 'haaski-diary' ),
		    'panel' => 'featured_links_panel',
		    'description' => esc_html__( 'Featured Link #6', 'haaski-diary' ),
		));

		/**
		 * Featured links panel > Featured Link #6 section > Image option
		 */

		$wp_customize->add_setting( 'haaski_diary_featured_link_6_image', array(
		    'default' => '',
		    'capability' => 'edit_theme_options',
		    'sanitize_callback' => 'absint'
		));

		$wp_customize->add_control( new WP_Customize_Cropped_Image_Control( $wp_customize, 'haaski_diary_featured_link_6_image', array(
		    'label' => esc_html__( 'Image', 'haaski-diary' ),
		    'mime_type' => 'image',
		    'description' => esc_html__( 'Upload the image', 'haaski-diary' ),
		    'section' => 'haaski_diary_featured_link_6',
		    'settings' => 'haaski_diary_featured_link_6_image',
		    'width' => 940,
		    'height' => 627,
		)));

		/**
		 * Featured links panel > Featured Link #6 section > Title option
		 */

		$wp_customize->add_setting( 'haaski_diary_featured_link_6_title', array(
		    'default' => '',
		    'sanitize_callback' => 'sanitize_text_field',
		));

		$wp_customize->add_control( 'haaski_diary_featured_link_6_title', array(
		    'type' => 'text',
		    'section' => 'haaski_diary_featured_link_6',
		    'label' => esc_html__( 'Title', 'haaski-diary' ),
		    'description' => esc_html__( 'Insert the title of this slide', 'haaski-diary' ),
		));

		/**
		 * Featured links panel > Featured Link #6 section > URL option
		 */

		$wp_customize->add_setting( 'haaski_diary_featured_link_6_url', array(
		    'default' => '',
		    'sanitize_callback' => 'esc_url_raw',
		));

		$wp_customize->add_control( 'haaski_diary_featured_link_6_url', array(
		    'type' => 'url',
		    'section' => 'haaski_diary_featured_link_6',
		    'label' => esc_html__( 'Url', 'haaski-diary' ),
		    'description' => esc_html__( 'Insert the url of this slide', 'haaski-diary' ),
		));

		/**
		 * Main settins panel > Social Links and Footer > Enable footer socials option
		 */

		 $wp_customize->add_setting( 'haaski_diary_enable_footer_socials', array(
 			'default' => 'on',
 			'sanitize_callback' => 'haaski_diary_checkbox_sanize',
 		));

 		$wp_customize->add_control( 'haaski_diary_enable_footer_socials' , array(
			'priority' => 1,
 			'type' => 'checkbox',
 			'section' => 'footer_section',
 			'label' => esc_html__('Social links','haaski-diary'),
 			'description' => esc_html__('Do you want to show the social links in the footer?','haaski-diary'),
 		));

		/**
		 * Haaski Diary select sanitize
		 */

		function haaski_diary_select_sanitize ($value, $setting) {

			global $wp_customize;

			$control = $wp_customize->get_control( $setting->id );

			if ( array_key_exists( $value, $control->choices ) ) {

				return $value;

			} else {

				return $setting->default;

			}

		}

		/**
		 * Haaski Diary checkbox sanitize
		 */

		function haaski_diary_checkbox_sanize ($input) {

			return $input ? true : false;

		}

		/**
		 * Haaski Diary limit sanitize
		 */

		function haaski_diary_limit_sanitize($value, $setting) {

			global $wp_customize;

			$getSetting = $wp_customize->get_setting($setting->id);
			$newValue = ($value <= 0) ? $getSetting->default : absint($value);
			return $newValue;

		}

		/**
		 * Haaski Diary date sanitize
		 */

		function haaski_diary_date_sanitize($value, $setting) {

			global $wp_customize;

			$getSetting = $wp_customize->get_setting($setting->id);
			$newValue = (isset($value)) ? sanitize_text_field($value) : $getSetting->default ;
			return $newValue;

		}

	}

	add_action( 'customize_register', 'haaski_diary_customize_register', 11 );

}

/*-----------------------------------------------------------------------------------*/
/* Get post categories */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('haaski_diary_get_categories')) {

	function haaski_diary_get_categories() {

		$args = array(
			'taxonomy' => 'category',
			'hide_empty' => true,
		);

		$return['all'] = esc_html__( 'All categories', 'haaski-diary' );

		foreach ( get_terms($args) as $cat) {
			$return[$cat->term_id] = $cat->name;
		}

		return $return;

	}

}

/*-----------------------------------------------------------------------------------*/
/* Is archive */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('haaski_diary_is_archive')) {

	function haaski_diary_is_archive() {

		if (
			is_category() ||
			is_tag() ||
			is_author() ||
			is_year() ||
			is_month()

		) {

			return true;

		} else {

			return false;

		}

	}

}

/*-----------------------------------------------------------------------------------*/
/* Post class hook */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('haaski_diary_post_class')) {

	function haaski_diary_post_class($classes) {

		if ( !savana_lite_is_single() ) {

			if (
				is_home() ||
				is_archive() ||
				is_search()

			) {

				$classes[] = 'post-container col-md-12';

			}

		} else if ( savana_lite_is_single() && savana_lite_is_woocommerce_active('is_cart') ) {

			$classes[] = 'post-container col-md-12 woocommerce_cart_page';

		} else if ( savana_lite_is_single() && !savana_lite_is_woocommerce_active('is_product') ) {

			$classes[] = 'post-container col-md-12';

		} else if ( is_page() ) {

			$classes[] = 'full';

		}

		if (
			( is_home() ) ||
			( haaski_diary_is_archive() ) ||
			( is_search() )
		) :

			$classes[] = 'post-container-wrap';

		endif;

		return $classes;

	}

	add_filter('post_class', 'haaski_diary_post_class');

}

/*-----------------------------------------------------------------------------------*/
/* Body class hook */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('haaski_diary_body_class_function')) {

	function haaski_diary_body_class_function($classes) {

		if (
			( is_home() ) ||
			( haaski_diary_is_archive() ) ||
			( is_search() )
		) :

			$classes[] = 'is_blog_section';

		endif;

		return $classes;

	}

	add_filter('body_class', 'haaski_diary_body_class_function');

}

/*-----------------------------------------------------------------------------------*/
/* Post icon */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('haaski_diary_posticon')) {

	function haaski_diary_posticon() {

		$html = '';

		$icons = array (
			'video' => 'fa fa-play' ,
			'gallery' => 'fa fa-camera' ,
			'audio' => 'fa fa-volume-up' ,
			'chat' => 'fa fa-users',
			'status' => 'fa fa-keyboard-o',
			'image' => 'fa fa-picture-o' ,
			'quote' => 'fa fa-quote-left',
			'link' => 'fa fa-external-link',
			'aside' => 'fa fa-file-text-o',
		);

		if ( get_post_format() ) {

			$html .= '<i class="'.esc_attr($icons[get_post_format()]).'"></i> ';
			$html .= ucfirst( strtolower( esc_html(get_post_format()) ));

		} else {

			$html .= '<i class="fa fa-pencil-square-o"></i> ';
			$html .= esc_html__( 'Article','haaski-diary');

		}

		return $html;

	}

}

/*-----------------------------------------------------------------------------------*/
/* Get posts on slideshow */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('haaski_diary_get_posts_on_slideshow')) {

	function haaski_diary_get_posts_on_slideshow() {

		return intval(savana_lite_setting('haaski_diary_featured_posts_items', 3)) * 6;

	}

}

/*-----------------------------------------------------------------------------------*/
/* Exclude featured posts on homepage */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('haaski_diary_exclude_featured_posts_on_home')) {

	function haaski_diary_exclude_featured_posts_on_home(&$query) {

		if (
			(
				$query->is_home() &&
				$query->is_main_query() &&
				(
					savana_lite_setting('haaski_diary_exclude_slideshow_posts_on_loop', true) == true &&
					strstr(savana_lite_setting('haaski_diary_post_slideshow_layout','layout-1'), 'layout' ) == true
				)
			)
		){

			$offset = haaski_diary_get_posts_on_slideshow();

			$ppp = get_option('posts_per_page');

			if ( $query->is_paged ) {

				$page_offset = $offset + ( ($query->query_vars['paged']-1) * $ppp );
				$query->set('offset', $page_offset );

			}
			else {
				$query->set('offset',$offset);
			}

		}

	}

	add_action('pre_get_posts', 'haaski_diary_exclude_featured_posts_on_home', 1 );

}

/*-----------------------------------------------------------------------------------*/
/* Adjust offset pagination */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('haaski_diary_adjust_offset_pagination')) {

	function haaski_diary_adjust_offset_pagination($found_posts, $query) {

		$offset = haaski_diary_get_posts_on_slideshow();

		if (
			(
				$query->is_home() &&
				$query->is_main_query() &&
				(
					savana_lite_setting('haaski_diary_exclude_slideshow_posts_on_loop', true) == true &&
					strstr(savana_lite_setting('haaski_diary_post_slideshow_layout','layout-1'), 'layout' ) == true
				)
			)
		){
			return $found_posts - $offset;
		}

		return $found_posts;

	}

	add_filter('found_posts', 'haaski_diary_adjust_offset_pagination', 1, 2 );

}

/*-----------------------------------------------------------------------------------*/
/* Get featured links */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('haaski_diary_get_featured_links')) {

	function haaski_diary_get_featured_links() {

		$temp = '';
		$count = 0;

		for ($i = 1; $i <= 6; $i++) {

			if ($i <=3 ) {
				$themeSlug = 'savana_lite_';
			} else {
				$themeSlug = 'haaski_diary_';
			}

			if (savana_lite_setting($themeSlug . 'featured_link_' . $i . '_image')) :

	        $featured_image = esc_attr(savana_lite_setting($themeSlug . 'featured_link_' . $i . '_image'));
	        $featured_link = wp_get_attachment_url($featured_image);
					$featured_title = savana_lite_setting($themeSlug . 'featured_link_' . $i . '_title');
					$featured_url = savana_lite_setting($themeSlug . 'featured_link_' . $i . '_url');

	        $temp .= '<div class="featured-link-item">';

	        if ($featured_url) :

	            $temp .= '<a href="' . esc_url($featured_url) . '"></a>';

	        endif;

	        $temp .= '<img src="' . esc_url($featured_link) . '" alt="' . esc_attr($featured_title) . '">';

	        if ($featured_title) :

	            $temp .= '<div class="featured-link-title">';
	            $temp .= '<h6>' . esc_html($featured_title) . '</h6>';
	            $temp .= '</div>';

	        endif;

	        $temp .= '</div>';

					$count++;

	    endif;

		}

		$html  = '<div class="featured-links-parent featured-elements-' . $count . '">';
		$html .= $temp;
		$html .= '</div>';

		return $html;

	}

}

/*-----------------------------------------------------------------------------------*/
/* Get current date */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('haaski_diary_get_current_date')) {

	function haaski_diary_get_current_date() {

			$date_format = esc_attr(savana_lite_setting('haaski_diary_topbar_date_format', 'l, F j Y'));

			if(strtotime(wp_date($date_format))){
				$current_date = wp_date($date_format);
			} else {
				$current_date = wp_date('l, F j Y');
			}

			return $current_date;

	}

}

?>
