<?php
/**
 * The Template Name: Home Page
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package Gymnastics Center
 */

get_header(); ?>

<div id="content" >
    <?php
        $gymnastics_center_banner = get_theme_mod('gymnastics_center_banner', false);
        $gymnastics_center_banner_pageboxes = get_theme_mod('gymnastics_center_banner_pageboxes', false);

        if ($gymnastics_center_banner && $gymnastics_center_banner_pageboxes) { ?>
        <section id="banner-cat" class="position-relative py-5">
            <?php
            $gymnastics_center_querymed = new WP_Query(array(
                'page_id' => esc_attr($gymnastics_center_banner_pageboxes)
            ));
            while ($gymnastics_center_querymed->have_posts()) : $gymnastics_center_querymed->the_post(); ?>
                <div class="container">
                    <div class="row wow zoomIn" data-wow-delay=".4s">
                        <div class="col-xl-6 col-lg-6 col-md-7 col-12 align-self-center">
                            <div class="bannerbox">
                                <div class="container">
                                    <div class="banner-innr-box text-lg-start text-md-start text-center">
                                        <h1 class="mb-3 text-capitalize banner-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>
                                        <?php
                                            $gymnastics_center_trimexcerpt = get_the_excerpt();
                                            $gymnastics_center_shortexcerpt = wp_trim_words($gymnastics_center_trimexcerpt, 38);
                                            echo '<p class="banner-content mb-4">' . esc_html($gymnastics_center_shortexcerpt) . '</p>';
                                        ?>
                                        <div class="bannerbtn">
                                            <?php
                                                $gymnastics_center_button_text = get_theme_mod('gymnastics_center_button_text', 'Flip Into Action');
                                                $gymnastics_center_button_link_banner = esc_url(get_theme_mod('gymnastics_center_button_link_banner', get_permalink()));
                                                if ($gymnastics_center_button_text || !empty($gymnastics_center_button_link_banner)) { ?>
                                                <?php if ($gymnastics_center_button_text != '') { ?>
                                                    <a href="<?php echo esc_url($gymnastics_center_button_link_banner); ?>" class="button">
                                                        <?php echo esc_html($gymnastics_center_button_text); ?>
                                                        <span class="screen-reader-text"><?php echo esc_html($gymnastics_center_button_text); ?></span>
                                                    </a>
                                                <?php } ?>
                                            <?php } ?>
                                        </div>
                                        <?php if (get_theme_mod('gymnastics_center_banner_bottom_text') != "") { ?>
                                            <div class="banner-btm-box mt-5 position-relative">
                                                <p class="banner-btm-text mb-3"><?php echo esc_html(get_theme_mod('gymnastics_center_banner_bottom_text')); ?></p>
                                                <?php if (get_theme_mod('gymnastics_center_banner_review_img') || get_theme_mod('gymnastics_center_banner_review_text') != "") { ?>
                                                    <div class="d-flex align-items-center gap-4 review-box py-2 px-4 justify-content-lg-start justify-content-md-start justify-content-center">
                                                        <div class="bnr-review-img">
                                                            <img src="<?php echo esc_url(get_theme_mod('gymnastics_center_banner_review_img')); ?>" alt="<?php echo esc_attr( 'Review Image', 'gymnastics-center'); ?>"/> 
                                                        </div>
                                                        <div class="banner-review-text">
                                                            <p class="mb-0 text-capitalize"><?php echo esc_html(get_theme_mod('gymnastics_center_banner_review_text')); ?></p>
                                                        </div>
                                                    </div>
                                                <?php } ?>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-5 col-12 align-self-center text-center">
                            <?php if (has_post_thumbnail()) { ?>
                                <div class="banner-bg-img position-relative">
                                    <?php the_post_thumbnail('full bnr-inner-img'); ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <?php if (get_theme_mod('gymnastics_center_banner_left_text') != "") { ?>
                    <p class="left-text mb-0 position-absolute text-uppercase wow zoomIn" data-wow-delay=".4s"><?php echo esc_html(get_theme_mod('gymnastics_center_banner_left_text')); ?></p>
                <?php } ?>
            <?php endwhile;
                wp_reset_postdata();
            ?>
        </section>
    <?php } ?>

    <!-- Offer Section -->
    <?php
        $gymnastics_center_hide_offer_section = get_theme_mod('gymnastics_center_disabled_offer_section', false);
        $gymnastics_center_offer_category = get_theme_mod('gymnastics_center_offer_cat', '0');
        if ($gymnastics_center_hide_offer_section){ ?>
        <section id="offer-section" class="position-relative py-5 mb-5">
            <div class="container">
                <?php if (get_theme_mod('gymnastics_center_offer_text') != "" || get_theme_mod('gymnastics_center_offer_title') != "") { ?>
                    <div class="blog-bx mb-4 position-relative text-center wow fadeInDown" data-wow-delay=".4s">
                        <h2 class="offer-title text-capitalize mb-3"><?php echo esc_html(get_theme_mod('gymnastics_center_offer_title')); ?></h2>
                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/offer-img.png" class="title-img" alt="<?php echo esc_attr('Image', 'gymnastics-center'); ?>"/>
                        <p class="offer-text mt-3"><?php echo esc_html(get_theme_mod('gymnastics_center_offer_text')); ?></p>
                    </div> 
                <?php } ?>
                <div class="offer-main-box gap-4 wow zoomIn" data-wow-delay=".4s">
                    <div class="row">
                        <?php if ($gymnastics_center_offer_category !== '0') : ?>
                            <?php
                            $gymnastics_center_page_query = new WP_Query(array(
                                'category_name' => esc_attr($gymnastics_center_offer_category),
                                'posts_per_page' => 3,
                            ));
                            while ($gymnastics_center_page_query->have_posts()) :
                                $gymnastics_center_page_query->the_post(); ?>
                                <div class="col-xl-4 col-lg-4 col-md-4 col-12 px-lg-4 mb-4">
                                    <div class="offer-content">
                                        <div class="row">
                                            <div class="offer-inner-content">
                                                <div class="offer-img position-relative">
                                                    <?php if (has_post_thumbnail()) {
                                                        the_post_thumbnail('full', array('class' => 'post-image'));
                                                    } else { ?>
                                                        <div class="offer-img-bg"></div>
                                                    <?php } ?>
                                                    <div class="offer-text-box text-center position-absolute">
                                                        <div class="offer-text-inner">
                                                            <h3 class="offer-title text-capitalize mb-4">
                                                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                            </h3>
                                                            <p class="offer-excerpt mb-4"><?php echo esc_html(get_the_excerpt()); ?></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile; wp_reset_postdata(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
    <?php } ?>
</div>
<?php get_footer(); ?>