<?php
/**
 * @package Gymnastics Center
 */
?>

<?php
    $gymnastics_center_post_date = esc_html(get_the_date());
    
    $gymnastics_center_author_name = esc_html(get_the_author());

    $gymnastics_center_single_post_show_date     = get_theme_mod('gymnastics_center_single_post_date', true);
    $gymnastics_center_single_post_show_comments = get_theme_mod('gymnastics_center_single_post_comment', true);
    $gymnastics_center_single_post_show_author   = get_theme_mod('gymnastics_center_single_post_author', true);
    $gymnastics_center_single_post_show_time     = get_theme_mod('gymnastics_center_single_post_time', true);
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('single-post'); ?>>
    
    <?php 
    $gymnastics_center_designation = get_post_meta($post->ID, 'gymnastics_center_designation', true);
    
    if ($gymnastics_center_designation) : ?>
        <p class="serv-content"><?php echo esc_html($gymnastics_center_designation); ?></p>
    <?php endif; ?>
    <?php if (has_post_thumbnail() ){ ?>
        <div class="post-thumb">
           <?php the_post_thumbnail(); ?>
        </div>
    <?php } ?>

    <?php if ('post' == get_post_type()) : ?>
        <?php if ( $gymnastics_center_single_post_show_date || $gymnastics_center_single_post_show_comments || $gymnastics_center_single_post_show_author || $gymnastics_center_single_post_show_time ) : ?>
            <div class="postmeta">
                <?php if ($gymnastics_center_single_post_show_date) : ?>
                <div class="post-date">
                    <i class="fas fa-calendar-alt"></i> &nbsp;<?php echo esc_html($gymnastics_center_post_date); ?>
                </div>
                <?php endif; ?>
                <?php if ($gymnastics_center_single_post_show_comments) : ?>
                <div class="post-comment">&nbsp;
                    <span><?php echo esc_html(get_theme_mod('gymnastics_center_single_post_metabox_seperator', '|'));?></span>
                    <i class="fa fa-comment"></i> &nbsp; <?php comments_number(); ?>
                </div>
                <?php endif; ?>
                <?php if ($gymnastics_center_single_post_show_author) : ?>
                    <div class="post-author">&nbsp;
                        <span><?php echo esc_html(get_theme_mod('gymnastics_center_single_post_metabox_seperator', '|'));?></span>
                        <i class="fas fa-user"></i> &nbsp; <?php echo esc_html($gymnastics_center_author_name); ?>
                    </div>
                <?php endif; ?>
                <?php if ($gymnastics_center_single_post_show_time) : ?>
                    <div class="post-time">&nbsp;
                        <span><?php echo esc_html(get_theme_mod('gymnastics_center_single_post_metabox_seperator', '|'));?></span>
                        <i class="fas fa-clock"></i> &nbsp; <?php echo get_the_time(); ?>
                    </div>
                <?php endif; ?>
            </div> 
        <?php endif; ?>
    <?php endif; ?>
    <div class="entry-content">
        <?php the_content(); ?>
        <?php
            wp_link_pages( array(
                'before' => '<div class="page-links">' . __( 'Pages:', 'gymnastics-center' ),
                'after'  => '</div>',
            ) );
        ?>
        <div class="tags"><?php the_tags(); ?></div>
    </div>
    <footer class="entry-meta">
        <?php edit_post_link( __( 'Edit', 'gymnastics-center' ), '<span class="edit-link">', '</span>' ); ?>
    </footer>
</article>