<?php
/*
 * @package Gymnastics Center
 */


 function gymnastics_center_admin_enqueue_scripts() {
    wp_enqueue_style( 'gymnastics-center-admin-style', esc_url( get_template_directory_uri() ).'/css/addon.css' );
}
add_action( 'admin_enqueue_scripts', 'gymnastics_center_admin_enqueue_scripts' );

function gymnastics_center_theme_info_menu_link() {

    $gymnastics_center_theme = wp_get_theme();
    add_theme_page(
        sprintf( esc_html__( 'Welcome to %1$s', 'gymnastics-center' ), $gymnastics_center_theme->get( 'Name' )),
        esc_html__( 'Theme Demo Import', 'gymnastics-center' ),'edit_theme_options','gymnastics-center','gymnastics_center_theme_info_page'
    );
}
add_action( 'admin_menu', 'gymnastics_center_theme_info_menu_link' );

function gymnastics_center_theme_info_page() {

    $gymnastics_center_theme = wp_get_theme();
    ?>
<div class="wrap theme-info-wrap">
    <h1><?php printf( esc_html__( 'Welcome to %1$s', 'gymnastics-center' ), esc_html($gymnastics_center_theme->get( 'Name' ))); ?>
    </h1>
    <p class="theme-description">
    <?php esc_html_e( 'Do you want to configure this theme? Look no further, our easy-to-follow theme documentation will walk you through it.', 'gymnastics-center' ); ?>
    </p>
    <div class="columns-wrapper clearfix theme-demo">
        <div class="column column-quarter clearfix start-box"> 
            <div class="demo-import">
                <div class="theme-name">
                    <h2><?php echo esc_html( $gymnastics_center_theme->get( 'Name' ) ); ?></h2>
                    <p class="version"><?php esc_html_e( 'Version', 'gymnastics-center' ); ?>: <?php echo esc_html( wp_get_theme()->get( 'Version' ) ); ?></p>	
                </div>
                <?php require get_parent_theme_file_path( '/inc/demo-content.php' ); ?>
                <div id="demo-import-loader">
                    <img src="<?php echo esc_url(get_template_directory_uri() . '/images/status.gif'); ?>" alt="<?php echo esc_attr( 'Loading...', 'gymnastics-center'); ?>" />
                </div>
            </div>
        </div>
        <div class="column column-first clearfix">
            <div class="important-link">
                <div class="main-box columns-wrapper clearfix">
                    <div class="themelink column column-third clearfix">
                        <p><strong><?php esc_html_e( 'Pro version of our theme', 'gymnastics-center' ); ?></strong></p>
                        <p><?php esc_html_e( 'Are you excited for our theme? Then we will proceed for pro version of theme.', 'gymnastics-center' ); ?></p>
                        <a class="get-premium" href="<?php echo esc_url( GYMNASTICS_CENTER_PREMIUM_PAGE ); ?>" target="_blank">
                        <?php esc_html_e( 'Go To Premium', 'gymnastics-center' ); ?>
                        </a>
                    </div>

                    <div class="themelink column column-third clearfix">
                        <p><strong><?php esc_html_e( 'Need Help?', 'gymnastics-center' ); ?></strong></p>
                        <p><?php esc_html_e( 'Go to our support forum to help you out in case of queries and doubts regarding our theme.', 'gymnastics-center' ); ?></p>
                        <a href="<?php echo esc_url( GYMNASTICS_CENTER_SUPPORT ); ?>" target="_blank">
                        <?php esc_html_e( 'Contact Us', 'gymnastics-center' ); ?>
                        </a>
                    </div>

                    <div class="themelink column column-third clearfix">
                        <p><strong><?php esc_html_e( 'Check Our Demo', 'gymnastics-center' ); ?></strong></p>
                        <p><?php esc_html_e( 'Here, you can view a live demonstration of our premium theme.', 'gymnastics-center' ); ?></p>
                        <a href="<?php echo esc_url( GYMNASTICS_CENTER_PRO_DEMO ); ?>" target="_blank">
                        <?php esc_html_e( 'Premium Demo', 'gymnastics-center' ); ?>
                        </a>
                    </div>
                </div>
                <hr>
                <div class="main-box columns-wrapper clearfix">
                    <div class="themelink column column-third clearfix">
                        <p><strong><?php esc_html_e( 'Check all classic features', 'gymnastics-center' ); ?></strong></p>
                        <p><?php esc_html_e( 'Explore all our 90+ Premium Themes Collections', 'gymnastics-center' ); ?></p>
                        <a href="<?php echo esc_url( GYMNASTICS_CENTER_THEME_PAGE ); ?>" target="_blank">
                        <?php esc_html_e( 'Theme Page', 'gymnastics-center' ); ?>
                        </a>
                    </div>

                    <div class="themelink column column-third clearfix">
                        <p><strong><?php esc_html_e( 'Leave us a review', 'gymnastics-center' ); ?></strong></p>
                        <p><?php esc_html_e( 'Are you enjoying our theme? We would love to hear your feedback.', 'gymnastics-center' ); ?></p>
                        <a href="<?php echo esc_url( GYMNASTICS_CENTER_REVIEW ); ?>" target="_blank">
                        <?php esc_html_e( 'Rate This Theme', 'gymnastics-center' ); ?>
                        </a>
                    </div>

                    <div class="themelink column column-third clearfix">
                        <p><strong><?php esc_html_e( 'Theme Documentation', 'gymnastics-center' ); ?></strong></p>
                        <p><?php esc_html_e( 'Need more details? Please check our full documentation for detailed theme setup.', 'gymnastics-center' ); ?></p>
                        <a href="<?php echo esc_url( GYMNASTICS_CENTER_THEME_DOCUMENTATION ); ?>" target="_blank">
                        <?php esc_html_e( 'Documentation', 'gymnastics-center' ); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="getting-started">
        <div class="section">
            <h3><?php printf( esc_html__( 'Getting started with %s', 'gymnastics-center' ),
            esc_html($gymnastics_center_theme->get( 'Name' ))); ?></h3>
            <div class="columns-wrapper clearfix">
                <div class="column column-half clearfix">
                    <div class="section themelink">
                        <div class="">
                            <a class="" href="<?php echo esc_url( GYMNASTICS_CENTER_PREMIUM_PAGE ); ?>" target="_blank"><?php esc_html_e( 'Get Premium', 'gymnastics-center' ); ?></a>
                            <a href="<?php echo esc_url( GYMNASTICS_CENTER_PRO_DEMO ); ?>" target="_blank"><?php esc_html_e( 'View Demo', 'gymnastics-center' ); ?></a>
                            <a class="get-premium" href="<?php echo esc_url( GYMNASTICS_CENTER_BUNDLE_PAGE ); ?>" target="_blank"><?php esc_html_e( 'Bundle of 90+ Themes at $99', 'gymnastics-center' ); ?></a>
                        </div>
                        <div class="theme-description-1"><?php echo esc_html($gymnastics_center_theme->get( 'Description' )); ?></div>
                    </div>
                </div>
                <div class="column column-half clearfix">
                    <img src="<?php echo esc_url( $gymnastics_center_theme->get_screenshot() ); ?>" alt=""/>
                </div>
            </div>
        </div>
    </div>
    <hr>
    <div id="theme-author">
      <p><?php
        printf( esc_html__( '%1$s is proudly brought to you by %2$s. If you like this theme, %3$s :)', 'gymnastics-center' ),
            esc_html($gymnastics_center_theme->get( 'Name' )),
            '<a target="_blank" href="' . esc_url( 'https://www.theclassictemplates.com/', 'gymnastics-center' ) . '">classictemplate</a>',
            '<a target="_blank" href="' . esc_url(GYMNASTICS_CENTER_REVIEW ) . '" title="' . esc_attr__( 'Rate it', 'gymnastics-center' ) . '">' . esc_html_x( 'rate it', 'If you like this theme, rate it', 'gymnastics-center' ) . '</a>'
        );
        ?></p>
    </div>
</div>
<?php
}
?>