<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package Gymnastics Center
 */
?>

<div id="sidebar">    
    <?php if ( ! dynamic_sidebar( 'sidebar-1' ) ) : ?>
        <aside role="complementary" aria-label="<?php esc_attr_e('sidebar1', 'gymnastics-center'); ?>" id="search" class="widget">
            <h3 class="widget-title"><?php esc_html_e( 'Search', 'gymnastics-center' ); ?></h3>
            <?php get_search_form(); ?>
        </aside>
        <aside role="complementary" aria-label="<?php esc_attr_e('sidebar2', 'gymnastics-center'); ?>" id="archives" class="widget">
            <h3 class="widget-title"><?php esc_html_e( 'Archives', 'gymnastics-center' ); ?></h3>
            <ul>
                <?php wp_get_archives( array( 'type' => 'monthly' ) ); ?>
            </ul>
        </aside>
        <aside role="complementary" aria-label="<?php esc_attr_e('sidebar3', 'gymnastics-center'); ?>" id="categories" class="widget"> 
            <h3 class="widget-title"><?php esc_html_e( 'Categories', 'gymnastics-center' ); ?></h3>          
            <ul>
                <?php wp_list_categories('title_li=');  ?>
            </ul>
        </aside>
        <aside role="complementary" aria-label="<?php esc_attr_e('sidebar4', 'gymnastics-center'); ?>" id="meta" class="widget">
            <h3 class="widget-title"><?php esc_html_e( 'Meta', 'gymnastics-center' ); ?></h3>
            <ul>
                <?php wp_register(); ?>
                <li><?php wp_loginout(); ?></li>
                <?php wp_meta(); ?>
            </ul>
        </aside>
    <?php endif; // end sidebar widget area ?>  
</div>