<div class="theme-offer">
   <?php
        // Check if the demo import has been completed
        $gymnastics_center_demo_import_completed = get_option('gymnastics_center_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($gymnastics_center_demo_import_completed) {
            echo '<br>';
            echo '<div class="success">Demo Import Successful</div>';
            echo '<br>';
            echo '<hr>';
            echo '<br>';
            echo '<span>' . esc_html__( 'You can now visit your site or customize it further.', 'gymnastics-center' ) . '</span>';
            echo '<br>';
            echo '<br>';
            echo '<br>';
            echo '<div class="view-site-btn">';
            echo '<a href="' . esc_url(home_url()) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">View Site</a>';
            echo '<a href="' . esc_url( admin_url('customize.php') ) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">Customize Demo Content</a>';
            echo '</div>';
        }
     // POST and update the customizer and other related data of Gymnastics Center
    if ( isset( $_POST['submit'] ) ) {

        // Check if Classic Blog Grid plugin is installed
        if (!is_plugin_active('classic-blog-grid/classic-blog-grid.php')) {
            // Plugin slug and file path for Classic Blog Grid
            $gymnastics_center_plugin_slug = 'classic-blog-grid';
            $gymnastics_center_plugin_file = 'classic-blog-grid/classic-blog-grid.php';
        
            // Check if Classic Blog Grid is installed and activated
            if ( ! is_plugin_active( $gymnastics_center_plugin_file ) ) {
        
                // Check if Classic Blog Grid is installed
                $gymnastics_center_installed_plugins = get_plugins();
                if ( ! isset( $gymnastics_center_installed_plugins[ $gymnastics_center_plugin_file ] ) ) {
        
                    // Include necessary files to install plugins
                    include_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );
                    include_once( ABSPATH . 'wp-admin/includes/file.php' );
                    include_once( ABSPATH . 'wp-admin/includes/misc.php' );
                    include_once( ABSPATH . 'wp-admin/includes/class-wp-upgrader.php' );
        
                    // Download and install Classic Blog Grid
                    $gymnastics_center_upgrader = new Plugin_Upgrader();
                    $gymnastics_center_upgrader->install( 'https://downloads.wordpress.org/plugin/classic-blog-grid.latest-stable.zip' );
                }
        
                // Activate the Classic Blog Grid plugin after installation (if needed)
                activate_plugin( $gymnastics_center_plugin_file );
            }
        }

        // ------- Create Main Menu --------
        $gymnastics_center_menuname = 'Primary Menu'; 
        $gymnastics_center_bpmenulocation = 'primary';
        $gymnastics_center_menu_exists = wp_get_nav_menu_object($gymnastics_center_menuname);

        if (!$gymnastics_center_menu_exists) {
            // Create a new menu
            $gymnastics_center_menu_id = wp_create_nav_menu($gymnastics_center_menuname);

            // Define pages to be created
            $gymnastics_center_pages = array(
                'home' => array(
                    'title' => 'Home',
                    'template' => '/templates/template-home-page.php'
                ),
                'about' => array(
                    'title' => 'About',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'services' => array(
                    'title' => 'Services',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'projects' => array(
                    'title' => 'Projects',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'blog' => array(
                    'title' => 'Blog',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'pages' => array(
                    'title' => 'Pages',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'contact' => array(
                    'title' => 'Contact',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
            );

            $gymnastics_center_page_ids = array();

            // Loop through the pages and create them if they don’t exist
            foreach ($gymnastics_center_pages as $gymnastics_center_slug => $gymnastics_center_data) {
                $gymnastics_center_existing_page = get_page_by_path($gymnastics_center_slug);

                if ($gymnastics_center_existing_page) {
                    // If the page already exists, use its ID
                    $gymnastics_center_page_id = $gymnastics_center_existing_page->ID;
                } else {
                    // Create a new page
                    $gymnastics_center_page_data = array(
                        'post_type'    => 'page',
                        'post_title'   => $gymnastics_center_data['title'],
                        'post_content' => isset($gymnastics_center_data['content']) ? $gymnastics_center_data['content'] : '',
                        'post_status'  => 'publish',
                        'post_author'  => get_current_user_id(), // Set author dynamically
                        'post_name'    => $gymnastics_center_slug,
                    );

                    $gymnastics_center_page_id = wp_insert_post($gymnastics_center_page_data);

                    // Assign custom page template if specified
                    if (!empty($gymnastics_center_data['template'])) {
                        update_post_meta($gymnastics_center_page_id, '_wp_page_template', $gymnastics_center_data['template']);
                    }
                }

                // Store the page IDs
                $gymnastics_center_page_ids[$gymnastics_center_slug] = $gymnastics_center_page_id;
            }

            // Set homepage and blog page
            update_option('page_for_posts', $gymnastics_center_page_ids['blog']);
            update_option('page_on_front', $gymnastics_center_page_ids['home']);
            update_option('show_on_front', 'page');

            // Define menu items
            $gymnastics_center_menu_items = array(
                'home',
                'about',
                'services',
                'projects',
                'blog',
                'pages',
                'contact'
            );

            // Add menu items dynamically
            foreach ($gymnastics_center_menu_items as $gymnastics_center_slug) {
                wp_update_nav_menu_item($gymnastics_center_menu_id, 0, array(
                    'menu-item-title' => esc_html($gymnastics_center_pages[$gymnastics_center_slug]['title']),
                    'menu-item-url' => get_permalink($gymnastics_center_page_ids[$gymnastics_center_slug]),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $gymnastics_center_page_ids[$gymnastics_center_slug],
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type',
                ));
            }

            // Assign menu to theme location
            $gymnastics_center_locations = get_theme_mod('nav_menu_locations', array());
            $gymnastics_center_locations[$gymnastics_center_bpmenulocation] = $gymnastics_center_menu_id;
            set_theme_mod('nav_menu_locations', $gymnastics_center_locations);
        }

        //Logo
        set_theme_mod( 'gymnastics_center_the_custom_logo', esc_url( get_template_directory_uri().'/images/Logo.png'));

        //Header Section
        set_theme_mod('gymnastics_center_enable_topbar', true);        
        set_theme_mod('gymnastics_center_topbar_text', 'From Floor to Vault, We’ve Got Your Journey Covered.');   
        set_theme_mod('gymnastics_center_email_address', 'GraceMotion@example.com');   
        set_theme_mod('gymnastics_center_phone_number', '+1234567890');   
        set_theme_mod( 'gymnastics_center_facebook_url', 'https://www.facebook.com');
        set_theme_mod( 'gymnastics_center_instagram_url', 'https://www.instagram.com');
        set_theme_mod( 'gymnastics_center_linkedin_url', 'https://www.linkedin.com');
        set_theme_mod( 'gymnastics_center_youtube_url', 'https://www.youtube.com');

       //Slider Section
       set_theme_mod( 'gymnastics_center_banner', true);
       set_theme_mod('gymnastics_center_button_text', 'Flip Into Action');   
       set_theme_mod('gymnastics_center_button_link_banner', '#');   
       set_theme_mod('gymnastics_center_banner_bottom_text', 'Whether you\'re a beginner or an elite athlete, our personalized gymnastics programs are designed to refine your skills and elevate your passion.'); 
       set_theme_mod('gymnastics_center_banner_review_text', 'Happy Students');   
       set_theme_mod('gymnastics_center_banner_left_text', 'GYMNASTICS'); 
       set_theme_mod( 'gymnastics_center_banner_review_img', esc_url( get_template_directory_uri().'/images/review.png'));

        // Function to fetch or create a page using WP_Query
        function get_or_create_page_by_title( $gymnastics_center_page_title, $gymnastics_center_page_content = '' ) {
            $gymnastics_center_args = array(
                'post_type'      => 'page',
                'title'          => $gymnastics_center_page_title,
                'post_status'    => 'publish',
                'posts_per_page' => 1,
                'fields'         => 'ids'
            );
            $gymnastics_center_query = new WP_Query( $gymnastics_center_args );

            if ( ! empty( $gymnastics_center_query->posts ) ) {
                return $gymnastics_center_query->posts[0];
            } else {
                // Create the page if it doesn't exist
                $gymnastics_center_page_id = wp_insert_post( array(
                    'post_type'    => 'page',
                    'post_title'   => $gymnastics_center_page_title,
                    'post_content' => $gymnastics_center_page_content,
                    'post_status'  => 'publish',
                    'post_author'  => 1
                ));
                return $gymnastics_center_page_id;
            }
        }

        // Create Page
        $gymnastics_center_page_title = 'Balance. Strength. Elegance.';
        $gymnastics_center_page_content = 'Train with top gymnastics coaches and reach new heights in strength, flexibility, and performance.';
        $gymnastics_center_page_id = get_or_create_page_by_title( $gymnastics_center_page_title, $gymnastics_center_page_content );

        if ( $gymnastics_center_page_id ) {
            set_theme_mod( 'gymnastics_center_banner_pageboxes', $gymnastics_center_page_id );
        } else {
            error_log('Failed to create or fetch the "Welcome to Corporate Business Theme" page.');
        }

        $gymnastics_center_image_url = get_template_directory_uri().'/images/slider.png';
        $gymnastics_center_image_id = media_sideload_image($gymnastics_center_image_url, $gymnastics_center_page_id, null, 'id');
        if (!is_wp_error($gymnastics_center_image_id)) {
            // Set the downloaded image as the post's featured image
            set_post_thumbnail($gymnastics_center_page_id, $gymnastics_center_image_id);
        }  

       //Offer Section
       set_theme_mod('gymnastics_center_disabled_offer_section', true);  
       set_theme_mod('gymnastics_center_offer_title', 'What We Offer');   
       set_theme_mod('gymnastics_center_offer_text', 'we offer everything needed to become a confident gymnast.');  

        $gymnastics_center_featured_category_id = wp_create_category('Gymnastics');

        // Set the created category in the theme mod
        set_theme_mod('gymnastics_center_offer_cat', 'Gymnastics');

        $gymnastics_center_titles = array('Beginner Gymnastics','Artistic Gymnastics','Private Coaching');
        $gymnastics_center_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.';

        // Create posts for each team member
        foreach ($gymnastics_center_titles as $gymnastics_center_index => $gymnastics_center_title) {
            $gymnastics_center_post_data = array(
                'post_title'   => wp_strip_all_tags($gymnastics_center_title),
                'post_content' => $gymnastics_center_content,
                'post_status'  => 'publish',
                'post_type'    => 'post',
                'post_category'=> array($gymnastics_center_featured_category_id),
            );

            $gymnastics_center_post_id = wp_insert_post($gymnastics_center_post_data);

            if (!is_wp_error($gymnastics_center_post_id)) {
                // Set the post thumbnail
                $gymnastics_center_image_url = get_template_directory_uri() . '/images/service' . ($gymnastics_center_index + 1) . '.png';
                $gymnastics_center_image_id = media_sideload_image($gymnastics_center_image_url, $gymnastics_center_post_id, null, 'id');
                if (!is_wp_error($gymnastics_center_image_id)) {
                    set_post_thumbnail($gymnastics_center_post_id, $gymnastics_center_image_id);
                }

            }
        }

        // Show success message and the "View Site" button
        update_option('gymnastics_center_demo_import_completed', true);
        echo '<br>';
        echo '<div class="success">Demo Import Successful</div>';
        echo '<br>';
        echo '<hr>';
        echo '<br>';
        echo '<span>' . esc_html__( 'You can now visit your site or customize it further.', 'gymnastics-center' ) . '</span>';
        echo '<br>';
    }
     ?>
    <ul>
        <li>
        <?php 
        // Check if the form is submitted
        if ( !isset( $_POST['submit'] ) ) : ?>
            <!-- Show demo importer form only if it's not submitted -->
            <?php if (!get_option('gymnastics_center_demo_import_completed')) : ?>
                <span><?php echo esc_html( 'Click on the below content to get demo content installed.', 'gymnastics-center' ); ?></span>
                <br><br>
                <hr><br>
                <b class="note"><?php echo esc_html('Note :', 'gymnastics-center' ); ?></b><br><br>
                <small><b><?php echo esc_html('Please take a backup if your website is already live with data. This importer will overwrite existing data.', 'gymnastics-center' ); ?></b></small><br><br>
                <form id="demo-importer-form" action="" method="POST" onsubmit="return runDemoImport();">
                    <input type="submit" name="submit" value="<?php echo esc_attr('Run Importer','gymnastics-center'); ?>" class="button button-primary button-large">
                </form>
                <script type="text/javascript">
                    function runDemoImport() {
                        if (confirm('Do you really want to do this?')) {
                            document.getElementById('demo-import-loader').style.display = 'block';
                            return true;
                        }
                        return false;
                    }
                </script>
             <?php endif; ?>
         <?php 
        endif; 

        // Show "View Site" button after form submission
        if ( isset( $_POST['submit'] ) ) {
        echo '<div class="view-site-btn">';
        echo '<a href="' . esc_url(home_url()) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">View Site</a>';
        echo '<a href="' . esc_url( admin_url('customize.php') ) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">Customize Demo Content</a>';
        echo '</div>';
        }
        ?>
        </li>
    </ul>
 </div>



 