<?php
/**
 * Gymnastics Center Theme Customizer
 *
 * @package Gymnastics Center
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function gymnastics_center_customize_register( $wp_customize ) {

	function gymnastics_center_sanitize_dropdown_pages( $page_id, $setting ) {
  		$page_id = absint( $page_id );
  		return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
	}

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

	wp_enqueue_style('gymnastics-center-customize-controls', trailingslashit(esc_url(get_template_directory_uri())).'/css/customize-controls.css');

	// Enable / Disable Logo
	$wp_customize->add_setting('gymnastics_center_logo_enable',array(
		'default' => true,
		'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
	));
	$wp_customize->add_control( 'gymnastics_center_logo_enable', array(
		'settings' => 'gymnastics_center_logo_enable',
		'section'   => 'title_tagline',
		'label'     => __('Enable Logo','gymnastics-center'),
		'type'      => 'checkbox'
	));

	//Logo
    $wp_customize->add_setting('gymnastics_center_logo_width', array(
        'default' => 200,
        'transport' => 'refresh',
        'sanitize_callback' => 'gymnastics_center_sanitize_integer'
    ));
    $wp_customize->add_control(new Gymnastics_Center_Slider_Custom_Control($wp_customize, 'gymnastics_center_logo_width', array(
    	'label'          => __( 'Logo Width', 'gymnastics-center'),
        'section' => 'title_tagline',
        'settings' => 'gymnastics_center_logo_width',
        'input_attrs' => array(
            'step' => 1,
            'min' => 0,
            'max' => 200,
        ),
    )));

	// color site title
	$wp_customize->add_setting('gymnastics_center_sitetitle_color',array(
		'default' => '',
		'sanitize_callback' => 'gymnastics_center_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));

	$wp_customize->add_control( 'gymnastics_center_sitetitle_color', array(
	   'settings' => 'gymnastics_center_sitetitle_color',
	   'section'   => 'title_tagline',
	   'label' => __('Site Title Color', 'gymnastics-center'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('gymnastics_center_title_enable',array(
		'default' => false,
		'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
	));
	$wp_customize->add_control( 'gymnastics_center_title_enable', array(
	   'settings' => 'gymnastics_center_title_enable',
	   'section'   => 'title_tagline',
	   'label'     => __('Enable Site Title','gymnastics-center'),
	   'type'      => 'checkbox'
	));

	// color site tagline
	$wp_customize->add_setting('gymnastics_center_sitetagline_color',array(
		'default' => '',
		'sanitize_callback' => 'gymnastics_center_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_sitetagline_color', array(
	   'settings' => 'gymnastics_center_sitetagline_color',
	   'section'   => 'title_tagline',
	   'label' => __('Site Tagline Color', 'gymnastics-center'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('gymnastics_center_tagline_enable',array(
		'default' => false,
		'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
	));
	$wp_customize->add_control( 'gymnastics_center_tagline_enable', array(
	   'settings' => 'gymnastics_center_tagline_enable',
	   'section'   => 'title_tagline',
	   'label'     => __('Enable Site Tagline','gymnastics-center'),
	   'type'      => 'checkbox'
	));

	// woocommerce section
	$wp_customize->add_section('gymnastics_center_woocommerce_page_settings', array(
		'title'    => __('WooCommerce Page Settings', 'gymnastics-center'),
		'priority' => null,
		'panel'    => 'woocommerce',
	));

	$wp_customize->add_setting('gymnastics_center_shop_page_sidebar',array(
		'default' => false,
		'sanitize_callback'	=> 'gymnastics_center_sanitize_checkbox'
	 ));
	 $wp_customize->add_control('gymnastics_center_shop_page_sidebar',array(
		'type' => 'checkbox',
		'label' => __(' Check To Enable Shop page sidebar','gymnastics-center'),
		'section' => 'gymnastics_center_woocommerce_page_settings',
	 ));

    // shop page sidebar alignment
    $wp_customize->add_setting('gymnastics_center_shop_page_sidebar_position', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'gymnastics_center_sanitize_choices',
	));
	$wp_customize->add_control('gymnastics_center_shop_page_sidebar_position',array(
		'type'           => 'radio',
		'label'          => __('Shop Page Sidebar', 'gymnastics-center'),
		'section'        => 'gymnastics_center_woocommerce_page_settings',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'gymnastics-center'),
			'Right Sidebar' => __('Right Sidebar', 'gymnastics-center'),
		),
	));	 

	$wp_customize->add_setting('gymnastics_center_wooproducts_nav',array(
		'default' => 'Yes',
		'sanitize_callback'	=> 'gymnastics_center_sanitize_choices'
	 ));
	 $wp_customize->add_control('gymnastics_center_wooproducts_nav',array(
		'type' => 'select',
		'label' => __('Shop Page Products Navigation','gymnastics-center'),
		'choices' => array(
			 'Yes' => __('Yes','gymnastics-center'),
			 'No' => __('No','gymnastics-center'),
		 ),
		'section' => 'gymnastics_center_woocommerce_page_settings',
	 ));

	 $wp_customize->add_setting( 'gymnastics_center_single_page_sidebar',array(
		'default' => false,
		'sanitize_callback'	=> 'gymnastics_center_sanitize_checkbox'
    ) );
    $wp_customize->add_control('gymnastics_center_single_page_sidebar',array(
    	'type' => 'checkbox',
       	'label' => __('Check To Enable Single Product Page Sidebar','gymnastics-center'),
		'section' => 'gymnastics_center_woocommerce_page_settings'
    ));

	// single product page sidebar alignment
    $wp_customize->add_setting('gymnastics_center_single_product_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'gymnastics_center_sanitize_choices',
	));
	$wp_customize->add_control('gymnastics_center_single_product_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Single product Page Sidebar', 'gymnastics-center'),
		'section'        => 'gymnastics_center_woocommerce_page_settings',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'gymnastics-center'),
			'Right Sidebar' => __('Right Sidebar', 'gymnastics-center'),
		),
	));

	$wp_customize->add_setting('gymnastics_center_related_product_enable',array(
		'default' => true,
		'sanitize_callback'	=> 'gymnastics_center_sanitize_checkbox'
	));
	$wp_customize->add_control('gymnastics_center_related_product_enable',array(
		'type' => 'checkbox',
		'label' => __('Check To Enable Related product','gymnastics-center'),
		'section' => 'gymnastics_center_woocommerce_page_settings',
	));

	$wp_customize->add_setting( 'gymnastics_center_woo_product_img_border_radius', array(
        'default'              => '0',
        'transport'            => 'refresh',
        'sanitize_callback'    => 'gymnastics_center_sanitize_integer'
    ) );
    $wp_customize->add_control(new Gymnastics_Center_Slider_Custom_Control( $wp_customize, 'gymnastics_center_woo_product_img_border_radius',array(
		'label'	=> esc_html__('Woo Product Img Border Radius','gymnastics-center'),
		'section'=> 'gymnastics_center_woocommerce_page_settings',
		'settings'=>'gymnastics_center_woo_product_img_border_radius',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 100,
        ),
	)));

	// Add a setting for number of products per row
    $wp_customize->add_setting('gymnastics_center_products_per_row', array(
	    'default'   => '4',
	    'transport' => 'refresh',
	    'sanitize_callback' => 'gymnastics_center_sanitize_integer'  
    ));

   	$wp_customize->add_control('gymnastics_center_products_per_row', array(
	   'label'    => __('Products Per Row', 'gymnastics-center'),
	   'section'  => 'gymnastics_center_woocommerce_page_settings',
	   'settings' => 'gymnastics_center_products_per_row',
	   'type'     => 'select',
	   'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
	  ),
   	) );
   
   	// Add a setting for the number of products per page
	$wp_customize->add_setting('gymnastics_center_products_per_page', array(
		'default'   => '8',
		'transport' => 'refresh',
		'sanitize_callback' => 'gymnastics_center_sanitize_integer'
	));

	$wp_customize->add_control('gymnastics_center_products_per_page', array(
		'label'    => __('Products Per Page', 'gymnastics-center'),
		'section'  => 'gymnastics_center_woocommerce_page_settings',
		'settings' => 'gymnastics_center_products_per_page',
		'type'     => 'number',
		'input_attrs' => array(
			'min'  => 1,
			'step' => 1,
		),
	));

	//Theme Options
	$wp_customize->add_panel( 'gymnastics_center_panel_area', array(
		'priority' => 10,
		'capability' => 'edit_theme_options',
		'title' => __( 'Theme Options Panel', 'gymnastics-center' ),
	) );

	//Site Layout Section
	$wp_customize->add_section('gymnastics_center_site_layoutsec',array(
		'title'	=> __('Manage Site Layout Section ','gymnastics-center'),
		'description' => __('<p class="sec-title">Manage Site Layout Section</p>','gymnastics-center'),
		'priority'	=> 1,
		'panel' => 'gymnastics_center_panel_area',
	));

	$wp_customize->add_setting('gymnastics_center_preloader',array(
		'default' => false,
		'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
	));
	$wp_customize->add_control( 'gymnastics_center_preloader', array(
	   'section'   => 'gymnastics_center_site_layoutsec',
	   'label'	=> __('Check to Show preloader','gymnastics-center'),
	   'type'      => 'checkbox'
 	));		

	$wp_customize->add_setting('gymnastics_center_box_layout',array(
		'default' => false,
		'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
	));
	$wp_customize->add_control( 'gymnastics_center_box_layout', array(
	   'section'   => 'gymnastics_center_site_layoutsec',
	   'label'	=> __('Check to Show Box Layout','gymnastics-center'),
	   'type'      => 'checkbox'
 	));

	// Add Settings and Controls for Page Layout
    $wp_customize->add_setting('gymnastics_center_sidebar_page_layout',array(
		'default' => 'full',
	 	'sanitize_callback' => 'gymnastics_center_sanitize_choices'
	));
	$wp_customize->add_control('gymnastics_center_sidebar_page_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Page Sidebar Position', 'gymnastics-center'),
		'section' => 'gymnastics_center_site_layoutsec',
		'choices' => array(
			'full' => __('Full','gymnastics-center'),
			'left' => __('Left','gymnastics-center'),
			'right' => __('Right','gymnastics-center'),
		),
	));

	$wp_customize->add_setting( 'gymnastics_center_site_layoutsec_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('gymnastics_center_site_layoutsec_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(GYMNASTICS_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'gymnastics_center_site_layoutsec'
	));

	//Global Color
	$wp_customize->add_section('gymnastics_center_global_color', array(
		'title'    => __('Manage Global Color Section', 'gymnastics-center'),
		'panel'    => 'gymnastics_center_panel_area',
	));

	$wp_customize->add_setting('gymnastics_center_first_color', array(
		'default'           => '#D51542',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gymnastics_center_first_color', array(
		'label'    => __('Theme Color One', 'gymnastics-center'),
		'section'  => 'gymnastics_center_global_color',
		'settings' => 'gymnastics_center_first_color',
	)));

	$wp_customize->add_setting( 'gymnastics_center_global_color_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('gymnastics_center_global_color_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(GYMNASTICS_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'gymnastics_center_global_color'
	));

	// Header Section
	$wp_customize->add_section('gymnastics_center_topbar_section',array(
	    'title' => __('Manage Header Section','gymnastics-center'),
	    'description' => __('<p class="sec-title">Manage Header Section</p>', 'gymnastics-center'),
	    'priority'  => null,
	    'panel' => 'gymnastics_center_panel_area',
	));	

	$wp_customize->add_setting('gymnastics_center_enable_topbar',array(
		'default' => false,
		'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_enable_topbar', array(
	   'settings' => 'gymnastics_center_enable_topbar',
	   'section'   => 'gymnastics_center_topbar_section',
	   'label'     => __('Check To Enable This Section','gymnastics-center'),
	   'type'      => 'checkbox'
	));

	$wp_customize->add_setting('gymnastics_center_topbar_text', array(
	    'default'           => '',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('gymnastics_center_topbar_text', array(
	    'settings' => 'gymnastics_center_topbar_text',
	    'section'  => 'gymnastics_center_topbar_section',
	    'label'    => __('Add Topbar Text', 'gymnastics-center'),
	    'type'     => 'text',
	));

 	$wp_customize->add_setting('gymnastics_center_email_address',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_email',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_email_address', array(
	   'settings' => 'gymnastics_center_email_address',
	   'section'   => 'gymnastics_center_topbar_section',
	   'label' => __('Add Email Address', 'gymnastics-center'),
	   'type'      => 'text'
	));

 	$wp_customize->add_setting('gymnastics_center_phone_number',array(
		'default' => '',
		'sanitize_callback' => 'gymnastics_center_sanitize_phone_number',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_phone_number', array(
	   'settings' => 'gymnastics_center_phone_number',
	   'section'   => 'gymnastics_center_topbar_section',
	   'label' => __('Add Phone Number', 'gymnastics-center'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting('gymnastics_center_facebook_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_facebook_url', array(
	   'settings' => 'gymnastics_center_facebook_url',
	   'section'   => 'gymnastics_center_topbar_section',
	   'label' => __('Add Facebook URL', 'gymnastics-center'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('gymnastics_center_instagram_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_instagram_url', array(
	   'settings' => 'gymnastics_center_instagram_url',
	   'section'   => 'gymnastics_center_topbar_section',
	   'label' => __('Add Instagram URL', 'gymnastics-center'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('gymnastics_center_linkedin_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_linkedin_url', array(
	   'settings' => 'gymnastics_center_linkedin_url',
	   'section'   => 'gymnastics_center_topbar_section',
	   'label' => __('Add Linkedin URL', 'gymnastics-center'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('gymnastics_center_youtube_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_youtube_url', array(
	   'settings' => 'gymnastics_center_youtube_url',
	   'section'   => 'gymnastics_center_topbar_section',
	   'label' => __('Add Youtube URL', 'gymnastics-center'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('gymnastics_center_stickyheader',array(
		'default' => false,
		'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
	));
	$wp_customize->add_control( 'gymnastics_center_stickyheader', array(
	   'section'   => 'gymnastics_center_topbar_section',
	   'label'	=> __('Check To Show Sticky Header','gymnastics-center'),
	   'type'      => 'checkbox'
 	));

	$wp_customize->add_setting( 'gymnastics_center_topbar_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('gymnastics_center_topbar_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(GYMNASTICS_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'gymnastics_center_topbar_section'
	));

	// Banner Section
	$wp_customize->add_section('gymnastics_center_banner_section',array(
	    'title' => __('Manage Banner Section','gymnastics-center'),
	    'priority'  => null,
	    'description'	=> __('<p class="sec-title">Manage Banner Section</p> Select Page from the Dropdowns for banner, Also use the given image dimension (1920 x 600).','gymnastics-center'),
	    'panel' => 'gymnastics_center_panel_area',
	));	

	$wp_customize->add_setting('gymnastics_center_banner',array(
		'default' => false,
		'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_banner', array(
	   'settings' => 'gymnastics_center_banner',
	   'section'   => 'gymnastics_center_banner_section',
	   'label'     => __('Check To Enable This Section','gymnastics-center'),
	   'type'      => 'checkbox'
	));

	// Page Dropdown
	$wp_customize->add_setting('gymnastics_center_banner_pageboxes', array(
	    'default'           => '0',
	    'capability'        => 'edit_theme_options',
	    'sanitize_callback' => 'gymnastics_center_sanitize_dropdown_pages',
	));
	$wp_customize->add_control('gymnastics_center_banner_pageboxes', array(
	    'type'     => 'dropdown-pages',
	    'label'    => __('Select Page to display Banner', 'gymnastics-center'),
	    'section'  => 'gymnastics_center_banner_section',
	));

	// Button Text
	$wp_customize->add_setting('gymnastics_center_button_text', array(
	    'default'           => 'Flip Into Action',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('gymnastics_center_button_text', array(
	    'settings' => 'gymnastics_center_button_text',
	    'section'  => 'gymnastics_center_banner_section',
	    'label'    => __('Add Banner Button Text', 'gymnastics-center'),
	    'type'     => 'text',
	));

	// Button Link
	$wp_customize->add_setting('gymnastics_center_button_link_banner', array(
	    'default'           => '',
	    'sanitize_callback' => 'esc_url_raw',
	));
	$wp_customize->add_control('gymnastics_center_button_link_banner', array(
	    'label'    => __('Add Banner Button Link', 'gymnastics-center'),
	    'section'  => 'gymnastics_center_banner_section',
	    'type'     => 'url',
	));

	$wp_customize->add_setting('gymnastics_center_banner_bottom_text', array(
	    'default'           => '',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('gymnastics_center_banner_bottom_text', array(
	    'settings' => 'gymnastics_center_banner_bottom_text',
	    'section'  => 'gymnastics_center_banner_section',
	    'label'    => __('Add Banner Bottom Text', 'gymnastics-center'),
	    'type'     => 'text',
	));

	$wp_customize->add_setting('gymnastics_center_banner_review_img',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'gymnastics_center_banner_review_img',array(
	    'label' => __('Add Review Image','gymnastics-center'),
	    'description'	=> __('Use the given image dimension (150px x 35px).','gymnastics-center'),
	    'section' => 'gymnastics_center_banner_section'
	)));

	$wp_customize->add_setting('gymnastics_center_banner_review_text', array(
	    'default'           => '',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('gymnastics_center_banner_review_text', array(
	    'settings' => 'gymnastics_center_banner_review_text',
	    'section'  => 'gymnastics_center_banner_section',
	    'label'    => __('Add Review Text', 'gymnastics-center'),
	    'type'     => 'text',
	));

	$wp_customize->add_setting('gymnastics_center_banner_left_text', array(
	    'default'           => '',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('gymnastics_center_banner_left_text', array(
	    'settings' => 'gymnastics_center_banner_left_text',
	    'section'  => 'gymnastics_center_banner_section',
	    'label'    => __('Add Left Text', 'gymnastics-center'),
	    'type'     => 'text',
	));

	$wp_customize->add_setting( 'gymnastics_center_banner_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('gymnastics_center_banner_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(GYMNASTICS_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'gymnastics_center_banner_section'
	));

	// Offer Section
	$wp_customize->add_section('gymnastics_center_offer_section', array(
	    'title'       => __('Manage Offer Section', 'gymnastics-center'),
	    'description' => __('<p class="sec-title">Manage Offer Section</p>', 'gymnastics-center'),
	    'priority'    => null,
	    'panel'       => 'gymnastics_center_panel_area',
	));

	$wp_customize->add_setting('gymnastics_center_disabled_offer_section', array(
	    'default'           => false,
	    'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('gymnastics_center_disabled_offer_section', array(
	    'settings' => 'gymnastics_center_disabled_offer_section',
	    'section'  => 'gymnastics_center_offer_section',
	    'label'    => __('Check To Enable Section', 'gymnastics-center'),
	    'type'     => 'checkbox',
	));

	$wp_customize->add_setting('gymnastics_center_offer_title', array(
	    'default'           => '',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('gymnastics_center_offer_title', array(
	    'settings' => 'gymnastics_center_offer_title',
	    'section'  => 'gymnastics_center_offer_section',
	    'label'    => __('Add Section Title', 'gymnastics-center'),
	    'type'     => 'text',
	));

	$wp_customize->add_setting('gymnastics_center_offer_text', array(
	    'default'           => '',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('gymnastics_center_offer_text', array(
	    'settings' => 'gymnastics_center_offer_text',
	    'section'  => 'gymnastics_center_offer_section',
	    'label'    => __('Add Section Text', 'gymnastics-center'),
	    'type'     => 'text',
	));

	$gymnastics_center_categories = get_categories();
	$gymnastics_center_offer_cat_post = array();
	$gymnastics_center_offer_cat_post['0'] = 'Select';

	foreach ($gymnastics_center_categories as $gymnastics_center_category) {
	    $gymnastics_center_offer_cat_post[$gymnastics_center_category->slug] = $gymnastics_center_category->name;
	}

	$wp_customize->add_setting('gymnastics_center_offer_cat', array(
	    'default' => '0',
	    'sanitize_callback' => 'gymnastics_center_sanitize_choices',
	));
	$wp_customize->add_control('gymnastics_center_offer_cat', array(
	    'type'    => 'select',
	    'choices' => $gymnastics_center_offer_cat_post,
	    'label'   => __('Select Category to display Post', 'gymnastics-center'),
	    'section' => 'gymnastics_center_offer_section',
	));

	$wp_customize->add_setting( 'gymnastics_center_offer_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('gymnastics_center_offer_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(GYMNASTICS_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'gymnastics_center_offer_section'
	));

	//Blog post
	$wp_customize->add_section('gymnastics_center_blog_post_settings',array(
        'title' => __('Manage Post Section', 'gymnastics-center'),
        'priority' => null,
        'panel' => 'gymnastics_center_panel_area'
    ) );

	$wp_customize->add_setting('gymnastics_center_metafields_date', array(
	    'default' => true,
	    'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
	));
	$wp_customize->add_control('gymnastics_center_metafields_date', array(
	    'settings' => 'gymnastics_center_metafields_date', 
	    'section'   => 'gymnastics_center_blog_post_settings',
	    'label'     => __('Check to Enable Date', 'gymnastics-center'),
	    'type'      => 'checkbox',
	));

	$wp_customize->add_setting('gymnastics_center_metafields_comments', array(
		'default' => true,
		'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
	));	
	$wp_customize->add_control('gymnastics_center_metafields_comments', array(
		'settings' => 'gymnastics_center_metafields_comments',
		'section'  => 'gymnastics_center_blog_post_settings',
		'label'    => __('Check to Enable Comments', 'gymnastics-center'),
		'type'     => 'checkbox',
	));

	$wp_customize->add_setting('gymnastics_center_metafields_author', array(
		'default' => true,
		'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
	));
	$wp_customize->add_control('gymnastics_center_metafields_author', array(
		'settings' => 'gymnastics_center_metafields_author',
		'section'  => 'gymnastics_center_blog_post_settings',
		'label'    => __('Check to Enable Author', 'gymnastics-center'),
		'type'     => 'checkbox',
	));		

	$wp_customize->add_setting('gymnastics_center_metafields_time', array(
		'default' => true,
		'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
	));
	$wp_customize->add_control('gymnastics_center_metafields_time', array(
		'settings' => 'gymnastics_center_metafields_time',
		'section'  => 'gymnastics_center_blog_post_settings',
		'label'    => __('Check to Enable Time', 'gymnastics-center'),
		'type'     => 'checkbox',
	));	

	$wp_customize->add_setting('gymnastics_center_metabox_seperator',array(
		'default' => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gymnastics_center_metabox_seperator',array(
		'type' => 'text',
		'label' => __('Metabox Seperator','gymnastics-center'),
		'description' => __('Ex: "/", "|", "-", ...','gymnastics-center'),
		'section' => 'gymnastics_center_blog_post_settings'
	)); 

    // Add Settings and Controls for Post Layout
	$wp_customize->add_setting('gymnastics_center_sidebar_post_layout',array(
		'default' => 'right',
		'sanitize_callback' => 'gymnastics_center_sanitize_choices'
	));
	$wp_customize->add_control('gymnastics_center_sidebar_post_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Post Sidebar Position', 'gymnastics-center'),
		'description'   => __('This option work for blog page, archive page and search page.', 'gymnastics-center'),
		'section' => 'gymnastics_center_blog_post_settings',
		'choices' => array(
			'full' => __('Full','gymnastics-center'),
			'left' => __('Left','gymnastics-center'),
			'right' => __('Right','gymnastics-center'),
			'three-column' => __('Three Columns','gymnastics-center'),
			'four-column' => __('Four Columns','gymnastics-center'),
			'grid' => __('Grid Layout','gymnastics-center')
     ),
	) );

	$wp_customize->add_setting('gymnastics_center_blog_post_description_option',array(
    	'default'   => 'Excerpt Content', 
        'sanitize_callback' => 'gymnastics_center_sanitize_choices'
	));
	$wp_customize->add_control('gymnastics_center_blog_post_description_option',array(
        'type' => 'radio',
        'label' => __('Post Description Length','gymnastics-center'),
        'section' => 'gymnastics_center_blog_post_settings',
        'choices' => array(
            'No Content' => __('No Content','gymnastics-center'),
            'Excerpt Content' => __('Excerpt Content','gymnastics-center'),
            'Full Content' => __('Full Content','gymnastics-center'),
        ),
	) );

	$wp_customize->add_setting('gymnastics_center_blog_post_thumb',array(
        'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('gymnastics_center_blog_post_thumb',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Show / Hide Blog Post Thumbnail', 'gymnastics-center'),
        'section'     => 'gymnastics_center_blog_post_settings',
    ));

    $wp_customize->add_setting( 'gymnastics_center_blog_post_page_image_box_shadow', array(
        'default'              => '0',
        'transport'            => 'refresh',
        'sanitize_callback'    => 'gymnastics_center_sanitize_integer'
    ) );
    $wp_customize->add_control(new Gymnastics_Center_Slider_Custom_Control( $wp_customize, 'gymnastics_center_blog_post_page_image_box_shadow',array(
		'label'	=> esc_html__('Blog Page Image Box Shadow','gymnastics-center'),
		'section'=> 'gymnastics_center_blog_post_settings',
		'settings'=>'gymnastics_center_blog_post_page_image_box_shadow',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 100,
        ),
	)));

	$wp_customize->add_setting( 'gymnastics_center_blog_post_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('gymnastics_center_blog_post_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(GYMNASTICS_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'gymnastics_center_blog_post_settings'
	));

	//Single Post Settings
	$wp_customize->add_section('gymnastics_center_single_post_settings',array(
		'title' => __('Manage Single Post Section', 'gymnastics-center'),
		'priority' => null,
		'panel' => 'gymnastics_center_panel_area'
	));

	$wp_customize->add_setting( 'gymnastics_center_single_page_breadcrumb',array(
		'default' => true,
        'sanitize_callback'	=> 'gymnastics_center_sanitize_checkbox',
	));
	$wp_customize->add_control('gymnastics_center_single_page_breadcrumb',array(
       'section' => 'gymnastics_center_single_post_settings',
	   'label' => __( 'Check To Enable Breadcrumb','gymnastics-center' ),
	   'type' => 'checkbox'
    ));	

	$wp_customize->add_setting('gymnastics_center_single_post_date',array(
		'default' => true,
		'sanitize_callback'	=> 'gymnastics_center_sanitize_checkbox'
	));
	$wp_customize->add_control('gymnastics_center_single_post_date',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Date ','gymnastics-center'),
		'section' => 'gymnastics_center_single_post_settings'
	));	

	$wp_customize->add_setting('gymnastics_center_single_post_author',array(
		'default' => true,
		'sanitize_callback'	=> 'gymnastics_center_sanitize_checkbox'
	));
	$wp_customize->add_control('gymnastics_center_single_post_author',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Author','gymnastics-center'),
		'section' => 'gymnastics_center_single_post_settings'
	));

	$wp_customize->add_setting('gymnastics_center_single_post_comment',array(
		'default' => true,
		'sanitize_callback'	=> 'gymnastics_center_sanitize_checkbox'
	));
	$wp_customize->add_control('gymnastics_center_single_post_comment',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Comments','gymnastics-center'),
		'section' => 'gymnastics_center_single_post_settings'
	));	

	$wp_customize->add_setting('gymnastics_center_single_post_time',array(
		'default' => true,
		'sanitize_callback'	=> 'gymnastics_center_sanitize_checkbox'
	));
	$wp_customize->add_control('gymnastics_center_single_post_time',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Time','gymnastics-center'),
		'section' => 'gymnastics_center_single_post_settings'
	));	

	$wp_customize->add_setting('gymnastics_center_single_post_metabox_seperator',array(
		'default' => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gymnastics_center_single_post_metabox_seperator',array(
		'type' => 'text',
		'label' => __('Metabox Seperator','gymnastics-center'),
		'description' => __('Ex: "/", "|", "-", ...','gymnastics-center'),
		'section' => 'gymnastics_center_single_post_settings'
	)); 

	$wp_customize->add_setting('gymnastics_center_sidebar_single_post_layout',array(
    	'default' => 'right',
    	 'sanitize_callback' => 'gymnastics_center_sanitize_choices'
	));
	$wp_customize->add_control('gymnastics_center_sidebar_single_post_layout',array(
   		'type' => 'radio',
    	'label'     => __('Single post sidebar layout', 'gymnastics-center'),
     	'section' => 'gymnastics_center_single_post_settings',
     	'choices' => array(
			'full' => __('Full','gymnastics-center'),
			'left' => __('Left','gymnastics-center'),
			'right' => __('Right','gymnastics-center'),
     ),
	));

	$wp_customize->add_setting( 'gymnastics_center_single_post_page_image_box_shadow', array(
        'default'              => '0',
        'transport'            => 'refresh',
        'sanitize_callback'    => 'gymnastics_center_sanitize_integer'
    ) );
    $wp_customize->add_control(new Gymnastics_Center_Slider_Custom_Control( $wp_customize, 'gymnastics_center_single_post_page_image_box_shadow',array(
		'label'	=> esc_html__('Single Post Image Box Shadow','gymnastics-center'),
		'section'=> 'gymnastics_center_single_post_settings',
		'settings'=>'gymnastics_center_single_post_page_image_box_shadow',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 100,
        ),
	)));

	$wp_customize->add_setting( 'gymnastics_center_single_post_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('gymnastics_center_single_post_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(GYMNASTICS_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'gymnastics_center_single_post_settings'
	));

	//Page Settings
	$wp_customize->add_section('gymnastics_center_page_settings',array(
		'title' => __('Manage Page Section', 'gymnastics-center'),
		'priority' => null,
		'panel' => 'gymnastics_center_panel_area'
	));

	// Add Settings and Controls for Page Layout
	$wp_customize->add_setting('gymnastics_center_sidebar_page_layout',array(
		'default' => 'full',
			'sanitize_callback' => 'gymnastics_center_sanitize_choices'
	));
	$wp_customize->add_control('gymnastics_center_sidebar_page_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Page Sidebar Position', 'gymnastics-center'),
		'section' => 'gymnastics_center_page_settings',
		'choices' => array(
			'left' => __('Left','gymnastics-center'),
			'right' => __('Right','gymnastics-center'),
			'full' => __('No Sidebar','gymnastics-center')
	),
	));	

	// 404 Page Settings
	$wp_customize->add_section('gymnastics_center_page_not_found', array(
		'title'	=> __('Manage 404 Page Section','gymnastics-center'),
		'priority'	=> null,
		'panel' => 'gymnastics_center_panel_area',
	));
	
	$wp_customize->add_setting('gymnastics_center_page_not_found_heading',array(
		'default'=> __('404 Not Found','gymnastics-center'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gymnastics_center_page_not_found_heading',array(
		'label'	=> __('404 Heading','gymnastics-center'),
		'section'=> 'gymnastics_center_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('gymnastics_center_page_not_found_content',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('gymnastics_center_page_not_found_content',array(
		'label'	=> __('404 Text','gymnastics-center'),
		'input_attrs' => array(
			'placeholder' => __( 'Looks like you have taken a wrong turn.....Don\'t worry... it happens to the best of us.', 'gymnastics-center' ),
		),
		'section'=> 'gymnastics_center_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'gymnastics_center_page_not_found_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('gymnastics_center_page_not_found_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(GYMNASTICS_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'gymnastics_center_page_not_found'
	));

	// Footer Section
	$wp_customize->add_section('gymnastics_center_footer', array(
		'title'	=> __('Manage Footer Section','gymnastics-center'),
		'description'	=> __('<p class="sec-title">Manage Footer Section</p>','gymnastics-center'),
		'priority'	=> null,
		'panel' => 'gymnastics_center_panel_area',
	));

	$wp_customize->add_setting('gymnastics_center_footer_widget', array(
	    'default' => true,
	    'sanitize_callback' => 'gymnastics_center_sanitize_checkbox',
	));
	$wp_customize->add_control('gymnastics_center_footer_widget', array(
	    'settings' => 'gymnastics_center_footer_widget',
	    'section'   => 'gymnastics_center_footer',
	    'label'     => __('Check to Enable Footer Widget', 'gymnastics-center'),
	    'type'      => 'checkbox',
	));

	//  footer bg color
	$wp_customize->add_setting('gymnastics_center_footerbg_color',array(
		'default' => '',
		'sanitize_callback' => 'gymnastics_center_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_footerbg_color', array(
		'settings' => 'gymnastics_center_footerbg_color',
		'section'   => 'gymnastics_center_footer',
		'label' => __('Footer Background Color', 'gymnastics-center'),
		'type'      => 'color'
	));

	$wp_customize->add_setting('gymnastics_center_footer_bg_image',array(
        'default'   => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'gymnastics_center_footer_bg_image',array(
        'label' => __('Footer Background Image','gymnastics-center'),
        'section' => 'gymnastics_center_footer',
    )));

	$wp_customize->add_setting('gymnastics_center_footer_img_position',array(
		'default' => 'center center',
		'transport' => 'refresh',
		'sanitize_callback' => 'gymnastics_center_sanitize_choices'
	));
	$wp_customize->add_control('gymnastics_center_footer_img_position',array(
		'type' => 'select',
		'label' => __('Footer Image Position','gymnastics-center'),
		'section' => 'gymnastics_center_footer',
		'choices' 	=> array(
			'center center'   => esc_html__( 'Center', 'gymnastics-center' ),
			'center top'   => esc_html__( 'Top', 'gymnastics-center' ),
			'left center'   => esc_html__( 'Left', 'gymnastics-center' ),
			'right center'   => esc_html__( 'Right', 'gymnastics-center' ),
			'center bottom'   => esc_html__( 'Bottom', 'gymnastics-center' ),
		),
	));	

	$wp_customize->add_setting('gymnastics_center_footer_widget_areas',array(
		'default'           => 4,
		'sanitize_callback' => 'gymnastics_center_sanitize_choices',
	));
	$wp_customize->add_control('gymnastics_center_footer_widget_areas',array(
		'type'        => 'radio',
		'section' => 'gymnastics_center_footer',
		'label'       => __('Footer widget area', 'gymnastics-center'),
		'choices' => array(
		   '1'     => __('One', 'gymnastics-center'),
		   '2'     => __('Two', 'gymnastics-center'),
		   '3'     => __('Three', 'gymnastics-center'),
		   '4'     => __('Four', 'gymnastics-center')
		),
	));

	$wp_customize->add_setting('gymnastics_center_copyright_line',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control( 'gymnastics_center_copyright_line', array(
	   'section' 	=> 'gymnastics_center_footer',
	   'label'	 	=> __('Copyright Line','gymnastics-center'),
	   'type'    	=> 'text',
	   'priority' 	=> null,
    ));

	$wp_customize->add_setting('gymnastics_center_copyright_link',array(
    	'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control( 'gymnastics_center_copyright_link', array(
	   'section' 	=> 'gymnastics_center_footer',
	   'label'	 	=> __('Copyright Link','gymnastics-center'),
	   'type'    	=> 'text',
	   'priority' 	=> null,
    ));

	//  footer coypright color
	$wp_customize->add_setting('gymnastics_center_footercoypright_color',array(
		'default' => '',
		'sanitize_callback' => 'gymnastics_center_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_footercoypright_color', array(
	   'settings' => 'gymnastics_center_footercoypright_color',
	   'section'   => 'gymnastics_center_footer',
	   'label' => __('Coypright Color', 'gymnastics-center'),
	   'type'      => 'color'
	));

	//  footer title color
	$wp_customize->add_setting('gymnastics_center_footertitle_color',array(
		'default' => '',
		'sanitize_callback' => 'gymnastics_center_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_footertitle_color', array(
	   'settings' => 'gymnastics_center_footertitle_color',
	   'section'   => 'gymnastics_center_footer',
	   'label' => __('Title Color', 'gymnastics-center'),
	   'type'      => 'color'
	));

	//  footer description color
	$wp_customize->add_setting('gymnastics_center_footerdescription_color',array(
		'default' => '',
		'sanitize_callback' => 'gymnastics_center_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_footerdescription_color', array(
	   'settings' => 'gymnastics_center_footerdescription_color',
	   'section'   => 'gymnastics_center_footer',
	   'label' => __('Description Color', 'gymnastics-center'),
	   'type'      => 'color'
	));

	//  footer list color
	$wp_customize->add_setting('gymnastics_center_footerlist_color',array(
		'default' => '',
		'sanitize_callback' => 'gymnastics_center_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_footerlist_color', array(
	   'settings' => 'gymnastics_center_footerlist_color',
	   'section'   => 'gymnastics_center_footer',
	   'label' => __('List Color', 'gymnastics-center'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('gymnastics_center_scroll_hide', array(
        'default' => true,
        'sanitize_callback' => 'gymnastics_center_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'gymnastics_center_scroll_hide',array(
        'label'          => __( 'Check To Show Scroll To Top', 'gymnastics-center' ),
        'section'        => 'gymnastics_center_footer',
        'settings'       => 'gymnastics_center_scroll_hide',
        'type'           => 'checkbox',
    )));

	$wp_customize->add_setting('gymnastics_center_scroll_position',array(
        'default' => 'Right',
        'sanitize_callback' => 'gymnastics_center_sanitize_choices'
    ));
    $wp_customize->add_control('gymnastics_center_scroll_position',array(
        'type' => 'radio',
        'section' => 'gymnastics_center_footer',
        'label'	 	=> __('Scroll To Top Positions','gymnastics-center'),
        'choices' => array(
            'Right' => __('Right','gymnastics-center'),
            'Left' => __('Left','gymnastics-center'),
            'Center' => __('Center','gymnastics-center')
        ),
    ) );

	$wp_customize->add_setting('gymnastics_center_scroll_text',array(
		'default'	=> __('TOP','gymnastics-center'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));	
	$wp_customize->add_control('gymnastics_center_scroll_text',array(
		'label'	=> __('Scroll To Top Button Text','gymnastics-center'),
		'section'	=> 'gymnastics_center_footer',
		'type'		=> 'text'
	));

	$wp_customize->add_setting( 'gymnastics_center_scroll_top_shape', array(
		'default'           => 'circle',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	
	$wp_customize->add_control( 'gymnastics_center_scroll_top_shape', array(
		'label'    => __( 'Scroll to Top Button Shape', 'gymnastics-center' ),
		'section'  => 'gymnastics_center_footer',
		'settings' => 'gymnastics_center_scroll_top_shape',
		'type'     => 'radio',
		'choices'  => array(
			'box'        => __( 'Box', 'gymnastics-center' ),
			'curved' => __( 'Curved', 'gymnastics-center'),
			'circle'     => __( 'Circle', 'gymnastics-center' ),
		),
	) );

	$wp_customize->add_setting( 'gymnastics_center_scroll_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('gymnastics_center_scroll_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(GYMNASTICS_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'gymnastics_center_footer'
	));

	// Footer Social Section
	$wp_customize->add_section('gymnastics_center_footer_social_icons', array(
		'title'	=> __('Manage Footer Social Section','gymnastics-center'),
		'description'	=> __('<p class="sec-title">Manage Footer Social Section</p>','gymnastics-center'),
		'priority'	=> null,
		'panel' => 'gymnastics_center_panel_area',
	));

	$wp_customize->add_setting('gymnastics_center_footer_facebook_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_footer_facebook_link', array(
		'settings' => 'gymnastics_center_footer_facebook_link',
		'section'   => 'gymnastics_center_footer_social_icons',
		'label' => __('Facebook Link', 'gymnastics-center'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('gymnastics_center_footer_instagram_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_footer_instagram_link', array(
		'settings' => 'gymnastics_center_footer_instagram_link',
		'section'   => 'gymnastics_center_footer_social_icons',
		'label' => __('Instagram Link', 'gymnastics-center'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('gymnastics_center_footer_pinterest_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_footer_pinterest_link', array(
		'settings' => 'gymnastics_center_footer_pinterest_link',
		'section'   => 'gymnastics_center_footer_social_icons',
		'label' => __('Pinterest Link', 'gymnastics-center'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('gymnastics_center_footer_twitter_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_footer_twitter_link', array(
		'settings' => 'gymnastics_center_footer_twitter_link',
		'section'   => 'gymnastics_center_footer_social_icons',
		'label' => __('Twitter Link', 'gymnastics-center'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('gymnastics_center_footer_youtube_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'gymnastics_center_footer_youtube_link', array(
		'settings' => 'gymnastics_center_footer_youtube_link',
		'section'   => 'gymnastics_center_footer_social_icons',
		'label' => __('Youtube Link', 'gymnastics-center'),
		'type'      => 'url'
	));

	$wp_customize->add_setting( 'gymnastics_center_footer_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('gymnastics_center_footer_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(GYMNASTICS_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'gymnastics_center_footer_social_icons'
	));

	// Google Fonts
	$wp_customize->add_section( 'gymnastics_center_google_fonts_section', array(
		'title'       => __( 'Google Fonts', 'gymnastics-center' ),
		'priority'    => 24,
	) );

	$font_choices = array(
		'' => 'No Fonts',
		'Kaushan Script:' => 'Kaushan Script',
		'Emilys Candy:' => 'Emilys Candy',
		'Poppins:0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900' => 'Poppins',
		'Source Sans Pro:400,700,400italic,700italic' => 'Source Sans Pro',
		'Open Sans:400italic,700italic,400,700' => 'Open Sans',
		'Oswald:400,700' => 'Oswald',
		'Playfair Display:400,700,400italic' => 'Playfair Display',
		'Montserrat:400,700' => 'Montserrat',
		'Raleway:400,700' => 'Raleway',
		'Droid Sans:400,700' => 'Droid Sans',
		'Lato:400,700,400italic,700italic' => 'Lato',
		'Arvo:400,700,400italic,700italic' => 'Arvo',
		'Lora:400,700,400italic,700italic' => 'Lora',
		'Merriweather:400,300italic,300,400italic,700,700italic' => 'Merriweather',
		'Oxygen:400,300,700' => 'Oxygen',
		'PT Serif:400,700' => 'PT Serif',
		'PT Sans:400,700,400italic,700italic' => 'PT Sans',
		'PT Sans Narrow:400,700' => 'PT Sans Narrow',
		'Cabin:400,700,400italic' => 'Cabin',
		'Fjalla One:400' => 'Fjalla One',
		'Francois One:400' => 'Francois One',
		'Josefin Sans:400,300,600,700' => 'Josefin Sans',
		'Libre Baskerville:400,400italic,700' => 'Libre Baskerville',
		'Arimo:400,700,400italic,700italic' => 'Arimo',
		'Ubuntu:400,700,400italic,700italic' => 'Ubuntu',
		'Bitter:400,700,400italic' => 'Bitter',
		'Droid Serif:400,700,400italic,700italic' => 'Droid Serif',
		'Roboto:400,400italic,700,700italic' => 'Roboto',
		'Open Sans Condensed:700,300italic,300' => 'Open Sans Condensed',
		'Roboto Condensed:400italic,700italic,400,700' => 'Roboto Condensed',
		'Roboto Slab:400,700' => 'Roboto Slab',
		'Yanone Kaffeesatz:400,700' => 'Yanone Kaffeesatz',
		'Rokkitt:400' => 'Rokkitt',
	);

	$wp_customize->add_setting( 'gymnastics_center_headings_fonts', array(
		'sanitize_callback' => 'gymnastics_center_sanitize_fonts',
	));
	$wp_customize->add_control( 'gymnastics_center_headings_fonts', array(
		'type' => 'select',
		'description' => __('Select your desired font for the headings.', 'gymnastics-center'),
		'section' => 'gymnastics_center_google_fonts_section',
		'choices' => $font_choices
	));

	$wp_customize->add_setting( 'gymnastics_center_body_fonts', array(
		'sanitize_callback' => 'gymnastics_center_sanitize_fonts'
	));
	$wp_customize->add_control( 'gymnastics_center_body_fonts', array(
		'type' => 'select',
		'description' => __( 'Select your desired font for the body.', 'gymnastics-center' ),
		'section' => 'gymnastics_center_google_fonts_section',
		'choices' => $font_choices
	));
  
}
add_action( 'customize_register', 'gymnastics_center_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function gymnastics_center_customize_preview_js() {
	wp_enqueue_script( 'gymnastics_center_customizer', esc_url(get_template_directory_uri()) . '/js/customize-preview.js', array( 'customize-preview' ), '20161510', true );
}
add_action( 'customize_preview_init', 'gymnastics_center_customize_preview_js' );
