<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div class="container">
 *
 * @package Gymnastics Center
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php if ( function_exists( 'wp_body_open' ) ) {
  wp_body_open();
} else {
  do_action( 'wp_body_open' );
} ?>

<?php if ( get_theme_mod('gymnastics_center_preloader', false) != "") { ?>
  <div id="preloader">
    <div id="status">&nbsp;</div>
  </div>
<?php }?>

<a class="screen-reader-text skip-link" href="#content"><?php esc_html_e( 'Skip to content', 'gymnastics-center' ); ?></a>

<div id="pageholder" <?php if( get_theme_mod( 'gymnastics_center_box_layout', false) != "" ) { echo 'class="boxlayout"'; } ?>>

<div class="mainhead<?php if( get_theme_mod( 'gymnastics_center_stickyheader', false) == 1) { ?> is-sticky-on"<?php } else { ?>close-sticky <?php } ?>">
  <div class="main-header">
    <?php if ( get_theme_mod('gymnastics_center_enable_topbar', false)) { ?>
      <div class="topbar py-2">
        <div class="container">
          <div class="row">
            <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-12 col-sm-12 col-12 align-self-center top-main-text text-lg-start text-md-center text-center">
              <?php if (get_theme_mod('gymnastics_center_topbar_text') != "") { ?>
                <p class="topbar-text mb-0"><i class="fa-solid fa-bullhorn me-2"></i><?php echo esc_html(get_theme_mod('gymnastics_center_topbar_text')); ?></p>
              <?php } ?>
            </div>
            <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-4 col-sm-6 col-12 align-self-center top-mail text-lg-start text-md-start text-sm-start text-center">
              <?php if ( get_theme_mod('gymnastics_center_email_address')) { ?>
                <a class="mail" href="mailto:<?php echo esc_attr( get_theme_mod('gymnastics_center_email_address') ); ?>"><i class="fa-regular fa-envelope me-2"></i><?php echo esc_html(get_theme_mod ('gymnastics_center_email_address')); ?></a>
              <?php } ?>
            </div>
            <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-6 col-12 align-self-center text-lg-end text-md-end text-sm-end text-center top-phone">
              <?php if ( get_theme_mod('gymnastics_center_phone_number')) { ?>
                <a class="phone-no" href="tel:<?php echo esc_attr( get_theme_mod('gymnastics_center_phone_number')); ?>"><i class="fas fa-phone me-2"></i><?php echo esc_html(get_theme_mod ('gymnastics_center_phone_number')); ?></a>
              <?php } ?>
            </div>
            <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-12 col-12 align-self-center d-flex justify-content-lg-end justify-content-md-end justify-content-center gap-3 align-items-center header-social-icons">
              <?php if ( get_theme_mod('gymnastics_center_facebook_url')) { ?>
                <a href="<?php echo esc_url(get_theme_mod ('gymnastics_center_facebook_url')); ?>" target="_blank" class="text-capitalize"><i class="fa-brands fa-facebook-f"></i></a>
              <?php }?>
              <?php if ( get_theme_mod('gymnastics_center_instagram_url')) { ?>
                <a href="<?php echo esc_url(get_theme_mod ('gymnastics_center_instagram_url')); ?>" target="_blank" class="text-capitalize"><i class="fa-brands fa-instagram"></i></a>
              <?php }?>
              <?php if ( get_theme_mod('gymnastics_center_linkedin_url')) { ?>
                <a href="<?php echo esc_url(get_theme_mod ('gymnastics_center_linkedin_url')); ?>" target="_blank" class="text-capitalize"><i class="fa-brands fa-linkedin-in"></i></a>
              <?php }?>
              <?php if ( get_theme_mod('gymnastics_center_youtube_url')) { ?>
                <a href="<?php echo esc_url(get_theme_mod ('gymnastics_center_youtube_url')); ?>" target="_blank" class="text-capitalize"><i class="fa-brands fa-youtube"></i></a>
              <?php }?>
            </div>
          </div>
        </div>
      </div>
    <?php }?>
    <div class="header-bg">
      <div class="container">
        <div class="row">
          <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-6 col-12 logo-box align-self-center py-1 text-lg-start text-md-start text-center">
            <div class="logo">
              <?php if (get_theme_mod('gymnastics_center_logo_enable', true)) { ?>
                <?php gymnastics_center_the_custom_logo(); ?>
              <?php } ?>
              <div class="site-branding-text">
                <?php if (get_theme_mod('gymnastics_center_title_enable', false)) { ?>
                  <?php if (is_front_page() && is_home()) : ?>
                    <h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></h1>
                  <?php else : ?>
                    <p class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></p>
                  <?php endif; ?>
                <?php } ?>
                <?php $gymnastics_center_description = get_bloginfo('description', 'display');
                if ($gymnastics_center_description || is_customize_preview()) : ?>
                  <?php if (get_theme_mod('gymnastics_center_tagline_enable', false)) { ?>
                    <span class="site-description"><?php echo esc_html($gymnastics_center_description); ?></span>
                  <?php } ?>
                <?php endif; ?>
              </div>
            </div>
          </div>
          <div class="col-xxl-9 col-xl-9 col-lg-9 col-md-6 col-sm-6 col-12 main-menu-box">
            <div class="menu-sec">
              <div class="toggle-nav text-center">
                <?php if (has_nav_menu('primary')) { ?>
                  <button role="tab"><?php esc_html_e('Menu', 'gymnastics-center'); ?></button>
                <?php } ?>
              </div>
              <div id="mySidenav" class="nav sidenav">
                <nav id="site-navigation" class="main-nav" role="navigation" aria-label="<?php esc_attr_e('Top Menu', 'gymnastics-center'); ?>">
                  <ul class="mobile_nav">
                    <?php wp_nav_menu(array(
                      'theme_location' => 'primary',
                      'container_class' => 'main-menu',
                      'items_wrap' => '%3$s',
                      'fallback_cb' => 'wp_page_menu',
                    )); ?>
                  </ul>
                  <a href="javascript:void(0)" class="close-button"><?php esc_html_e('CLOSE', 'gymnastics-center'); ?></a>
                </nav>
              </div>
            </div>
          </div>
          
        </div>
      </div>
    </div>
  </div>
</div>