<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package Gymnastics Center
 */
?>
<div id="footer">
  <?php 
    $gymnastics_center_footer_widget_enabled = get_theme_mod('gymnastics_center_footer_widget', true);
    if ($gymnastics_center_footer_widget_enabled !== false && $gymnastics_center_footer_widget_enabled !== '') { ?>
    <?php 
        $gymnastics_center_widget_areas = get_theme_mod('gymnastics_center_footer_widget_areas', '4');
        if ($gymnastics_center_widget_areas == '3') {
            $gymnastics_center_cols = 'col-lg-4 col-md-6';
        } elseif ($gymnastics_center_widget_areas == '4') {
            $gymnastics_center_cols = 'col-lg-3 col-md-6';
        } elseif ($gymnastics_center_widget_areas == '2') {
            $gymnastics_center_cols = 'col-lg-6 col-md-6';
        } else {
            $gymnastics_center_cols = 'col-lg-12 col-md-12';
        }
    ?>
    <div class="footer-widget">
        <div class="container">
          <div class="row">
            <!-- Footer 1 -->
            <div class="<?php echo esc_attr($gymnastics_center_cols); ?> footer-block">
                <?php if (is_active_sidebar('footer-1')) : ?>
                    <?php dynamic_sidebar('footer-1'); ?>
                <?php else : ?>
                    <aside id="categories" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer1', 'gymnastics-center'); ?>">
                        <h3 class="widget-title"><?php esc_html_e('Categories', 'gymnastics-center'); ?></h3>
                        <ul>
                            <?php wp_list_categories('title_li='); ?>
                        </ul>
                    </aside>
                <?php endif; ?>
            </div>

            <!-- Footer 2 -->
            <div class="<?php echo esc_attr($gymnastics_center_cols); ?> footer-block">
                <?php if (is_active_sidebar('footer-2')) : ?>
                    <?php dynamic_sidebar('footer-2'); ?>
                <?php else : ?>
                    <aside id="archives" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer2', 'gymnastics-center'); ?>">
                        <h3 class="widget-title"><?php esc_html_e('Archives', 'gymnastics-center'); ?></h3>
                        <ul>
                            <?php wp_get_archives(array('type' => 'monthly')); ?>
                        </ul>
                    </aside>
                <?php endif; ?>
            </div>

            <!-- Footer 3 -->
            <div class="<?php echo esc_attr($gymnastics_center_cols); ?> footer-block">
                <?php if (is_active_sidebar('footer-3')) : ?>
                    <?php dynamic_sidebar('footer-3'); ?>
                <?php else : ?>
                    <aside id="meta" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer3', 'gymnastics-center'); ?>">
                        <h3 class="widget-title"><?php esc_html_e('Meta', 'gymnastics-center'); ?></h3>
                        <ul>
                            <?php wp_register(); ?>
                            <li><?php wp_loginout(); ?></li>
                            <?php wp_meta(); ?>
                        </ul>
                    </aside>
                <?php endif; ?>
            </div>

            <!-- Footer 4 -->
            <div class="<?php echo esc_attr($gymnastics_center_cols); ?> footer-block">
                <?php if (is_active_sidebar('footer-4')) : ?>
                    <?php dynamic_sidebar('footer-4'); ?>
                <?php else : ?>
                    <aside id="search-widget" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer4', 'gymnastics-center'); ?>">
                        <h3 class="widget-title"><?php esc_html_e('Search', 'gymnastics-center'); ?></h3>
                        <?php the_widget('WP_Widget_Search'); ?>
                    </aside>
                <?php endif; ?>
            </div>
          </div>
        </div>
    </div>

    <?php } ?>
    <div class="clear"></div>
    <div class="copywrap text-center">
        <?php $gymnastics_center_social_links_present = get_theme_mod('gymnastics_center_footer_facebook_link') || get_theme_mod('gymnastics_center_footer_instagram_link') || get_theme_mod('gymnastics_center_footer_pinterest_link') || get_theme_mod('gymnastics_center_footer_twitter_link') || get_theme_mod('gymnastics_center_footer_youtube_link'); ?>
        <div class="container copywrap-info <?php echo $gymnastics_center_social_links_present ? '' : 'center-content'; ?>">
            <p>
                <a href="<?php 
                $gymnastics_center_copyright_link = get_theme_mod('gymnastics_center_copyright_link', '');
                if (empty($gymnastics_center_copyright_link)) {
                    echo esc_url('https://www.theclassictemplates.com/products/gymnastics-center');
                } else {
                    echo esc_url($gymnastics_center_copyright_link);
                } ?>" target="_blank">
                <?php echo esc_html(get_theme_mod('gymnastics_center_copyright_line', __('Gymnastics Center Theme', 'gymnastics-center'))); ?>
                </a> 
                <?php echo esc_html('By Classic Templates', 'gymnastics-center'); ?>
            </p>
            <?php if ( $gymnastics_center_social_links_present ) { ?>
                <div class="footer-social d-flex gap-3">
                    <?php if ( get_theme_mod('gymnastics_center_footer_facebook_link') ) { ?>
                        <a title="<?php echo esc_attr('facebook', 'gymnastics-center'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('gymnastics_center_footer_facebook_link')); ?>"><i class="fa-brands fa-facebook-f"></i></a> 
                    <?php } ?>
                    <?php if ( get_theme_mod('gymnastics_center_footer_instagram_link') ) { ?> 
                        <a title="<?php echo esc_attr('instagram', 'gymnastics-center'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('gymnastics_center_footer_instagram_link')); ?>"><i class="fa-brands fa-instagram"></i></a>
                    <?php } ?>
                    <?php if ( get_theme_mod('gymnastics_center_footer_pinterest_link') ) { ?>
                        <a title="<?php echo esc_attr('pinterest', 'gymnastics-center'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('gymnastics_center_footer_pinterest_link')); ?>"><i class="fa-brands fa-pinterest"></i></a>
                    <?php } ?>
                    <?php if ( get_theme_mod('gymnastics_center_footer_twitter_link') ) { ?> 
                        <a title="<?php echo esc_attr('twitter', 'gymnastics-center'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('gymnastics_center_footer_twitter_link')); ?>"><i class="fa-brands fa-twitter"></i></a>
                    <?php } ?>
                    <?php if ( get_theme_mod('gymnastics_center_footer_youtube_link') ) { ?>
                        <a title="<?php echo esc_attr('youtube', 'gymnastics-center'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('gymnastics_center_footer_youtube_link')); ?>"><i class="fa-brands fa-youtube"></i></a>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>
    </div>
</div>

<?php if(get_theme_mod('gymnastics_center_scroll_hide',true)){ ?>
    <a id="button"><?php echo esc_html( get_theme_mod('gymnastics_center_scroll_text',__('TOP', 'gymnastics-center' )) ); ?></a>
<?php } ?>
  
<?php wp_footer(); ?>
</body>
</html>
