<?php


/**
 * Gutentools Agency functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @subpackage Gutentools Agency
 * @since Gutentools Agency 1.0
 */

 function Gutentools_Agency_block_assets(){
    // Enqueue theme stylesheet for the front-end.
    wp_enqueue_style( 'gutentools-style', get_stylesheet_directory_uri() . '/style.css', array(), wp_get_theme()->get( 'Version' ) );
	wp_enqueue_script('gutentools-main-script', get_stylesheet_directory_uri() . '/assets/js/script.js', array('jquery'), '1.0.0', true);
}

add_action('enqueue_block_assets', 'Gutentools_Agency_block_assets');

// register own theme pattern

function Gutentools_Agency_register_pattern_category() {

	$patterns = array();

	$block_pattern_categories = array(
		'gutentools-agency' => array( 'label' => __( 'Gutentools Agency', 'gutentools-agency' ) )
	);

	$block_pattern_categories = apply_filters( 'Gutentools_Agency_block_pattern_categories', $block_pattern_categories );

	foreach ( $block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties );
		}
	}
}

add_action( 'init', 'Gutentools_Agency_register_pattern_category');