<?php
/**
 * Enqueue the style.css file.
 * 
 * @since 1.0.0
 */
function guten_bizz_style() {
	wp_enqueue_style(
		'guten-bizz-style',
		get_stylesheet_uri(),
		array(),
		wp_get_theme()->get( 'Version' )
	);
}
add_action( 'wp_enqueue_scripts', 'guten_bizz_style' );

/**
 * Register custom block styles.
 * 
 * @since 1.0.0
 */
function guten_bizz_register_block_styles() {
	// Register a custom style for the paragraph block.
	register_block_style(
		'core/paragraph',
		array(
			'name'  => 'fancy-paragraph',
			'label' => __( 'Fancy Paragraph', 'guten-bizz' ),
		)
	);

	// Register a custom style for the image block.
	register_block_style(
		'core/image',
		array(
			'name'  => 'rounded-image',
			'label' => __( 'Rounded Image', 'guten-bizz' ),
		)
	);
}
add_action( 'init', 'guten_bizz_register_block_styles' );

/**
 * Register custom block patterns.
 * 
 * @since 1.0.0
 */
function guten_bizz_register_block_patterns() {
	// Register a custom block pattern.
	register_block_pattern(
		'guten-bizz/fancy-pattern',
		array(
			'title'       => __( 'Fancy Pattern', 'guten-bizz' ),
			'description' => _x( 'A custom pattern with a heading and paragraph.', 'Block pattern description', 'guten-bizz' ),
			'content'     => '<!-- wp:heading --><h2>' . __( 'Welcome to Our Site', 'guten-bizz' ) . '</h2><!-- /wp:heading -->'
			                . '<!-- wp:paragraph --><p>' . __( 'This is a custom block pattern with a heading and a paragraph.', 'guten-bizz' ) . '</p><!-- /wp:paragraph -->',
		)
	);
}
add_action( 'init', 'guten_bizz_register_block_patterns' );
