<?php 
/**
 * The template for functions 
 *
 * @version    1.7.6
 * @package    gripvine
 * @author     Zidithemes
 * @copyright  Copyright (C) 2021 zidithemes.com All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * 
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }


require get_template_directory() . "/inc/gripvine-options.php";

function gripvine_setup(){
	
		// ADD THEME SUPPORT
	add_theme_support( 'title-tag' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( "custom-header" );
	add_theme_support( "custom-background" );
	add_theme_support( 'post-thumbnails' );
	add_theme_support('woocommerce');



	//REGISTER NAV MENUS
	register_nav_menus(
	    array(
	      'primary-menu' => __( 'Primary Menu', 'gripvine' ),
	    )
	  );

	// SET CONTENT WIDTH
	if ( ! isset( $content_width ) ) $content_width = 600;
	 


	load_theme_textdomain( 'gripvine' );


}

add_action('after_setup_theme', 'gripvine_setup');

// Load styles
function gripvine_load_styles_scripts(){
	// NOTE:   SOME OF THESE SCRIPTS ARE HOSTED ON A CDN AND ARE NOT STORED LOCALLY... SO THIS THEME MAY NOT RENDER PROPERLY IF YOU ARE NOT CONNECTED TO THE INTERNET
	
		wp_enqueue_style( 'gripvine-style', get_template_directory_uri() . '/style.css');

		wp_enqueue_style( 'gripvine-noto-google-fonts-style', 'https://fonts.googleapis.com/css?family=Noto+Sans');

		wp_enqueue_script('gripvine-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js' );

		if ( is_singular() ) wp_enqueue_script( "comment-reply" );
	
}

add_action('wp_enqueue_scripts', 'gripvine_load_styles_scripts');


function gripvine_pingback_wrap() {

		if ( is_singular() && pings_open() ) {
			echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
		}

}
add_action( 'wp_head', 'gripvine_pingback_wrap' );





if (!function_exists('gripvine_admin_style')) {
	function gripvine_admin_style($hook) {
		
		if ('appearance_page_gripvine_theme_info_options' === $hook) {
			wp_enqueue_style('gripvine-admin-script-style', get_template_directory_uri() . '/css/gripvine-admin.css');
		}
	}
}
add_action('admin_enqueue_scripts', 'gripvine_admin_style');




// Creating the sidebar
function gripvine_menu_init() {


register_sidebar(
		array(
                'name' 			=> esc_html__('Sidebar Widgets', 'gripvine'),
                'id'    		=> 'sidebar_id',
                'class'       	=> '',
				'description' 	=> esc_html__('Add sidebar widgets here', 'gripvine'),
				'before_widget' => '<div class="sidebar-items">',
				'after_widget' 	=> '</div>',
				'before_title' 	=> '<h2>',
				'after_title' 	=> '</h2>',
	));


	register_sidebar(array(
                'name' 			=> esc_html__('Left Footer', 'gripvine'),
                'id'    		=> 'left_footer',
                'class' 		=> '',
				'description' 	=> esc_html__('Add widgets here', 'gripvine'),
				'before_widget' => '<li>',
				'after_widget' 	=> '</li>',
				'before_title' 	=> '<h2>',
				'after_title' 	=> '</h2>',
	));
	
	register_sidebar(array(
                'name' 			=> esc_html__('Middle Footer', 'gripvine'),
                'id'    		=> 'middle_footer',
                'class' 		=> '',
				'description' 	=> esc_html__('Add widgets here', 'gripvine'),
				'before_widget' => '<li>',
				'after_widget' 	=> '</li>',
				'before_title'	=> '<h2>',
				'after_title' 	=> '</h2>',
	));
	
	register_sidebar(array(
                'name' 			=> esc_html__('Right Footer', 'gripvine'),
                'id'    		=> 'right_footer',
                'class' 		=> '',
				'description' 	=> esc_html__('Add widgets here', 'gripvine'),
				'before_widget' => '<li>',
				'after_widget' 	=> '</li>',
				'before_title' 	=> '<h2>',
				'after_title' 	=> '</h2>',
	));
	
	register_sidebar(array(
                'name' 			=> esc_html__('Fourth Footer', 'gripvine'),
                'id'    		=> 'fourth_footer',
                'class' 		=> '',
				'description' 	=> esc_html__('Add widgets here', 'gripvine'),
				'before_widget' => '<li>',
				'after_widget' 	=> '</li>',
				'before_title' 	=> '<h2>',
				'after_title' 	=> '</h2>',
	));

	register_sidebar(array(
                'name' 			=> esc_html__('Full Width Footer', 'gripvine'),
                'id'    		=> 'full_width_footer',
                'class' 		=> '',
				'description' 	=> esc_html__('Add widgets here', 'gripvine'),
				'before_widget' => '<li>',
				'after_widget' 	=> '</li>',
				'before_title' 	=> '<h2>',
				'after_title' 	=> '</h2>',
	));

}
add_action('widgets_init', 'gripvine_menu_init');

// this increases or decreaes the length of the excerpt on the index page
function gripvine_excerpt_length( $length ) {
	if ( is_admin() ) {
		return $length;
	}
	return 20;
}

add_filter( 'excerpt_length', 'gripvine_excerpt_length', 999 );

function gripvine_excerpt_more( $more ) {
    return '';
}
add_filter( 'excerpt_more', 'gripvine_excerpt_more' );



/**
 * Fix skip link focus in IE11.
 *
 * This does not enqueue the script because it is tiny and because it is only for IE11,
 * thus it does not warrant having an entire dedicated blocking script being loaded.
 *
 * @link https://git.io/vWdr2
 */
function gripvine_skip_link_focus_fix() {
	// The following is minified via `terser --compress --mangle -- js/skip-link-focus-fix.js`.
	?>
	<script>
	/(trident|msie)/i.test(navigator.userAgent)&&document.getElementById&&window.addEventListener&&window.addEventListener("hashchange",function(){var t,e=location.hash.substring(1);/^[A-z0-9_-]+$/.test(e)&&(t=document.getElementById(e))&&(/^(?:a|select|input|button|textarea)$/i.test(t.tagName)||(t.tabIndex=-1),t.focus())},!1);
	</script>
	<?php
}
add_action( 'wp_print_footer_scripts', 'gripvine_skip_link_focus_fix' );
