<?php

/**
 * The template for displaying Social Icons
 *
 * @package Catch Themes
 * @subpackage Gridalicious
 * @since Gridalicious 0.1
 */

if (! function_exists('gridalicious_get_social_icons')) :
	/**
	 * Generate social icons.
	 *
	 * @since Gridalicious 0.1
	 */
	function gridalicious_get_social_icons()
	{
		if ((!$output = get_transient('gridalicious_social_icons'))) {
			$output	= '';

			$options 	= gridalicious_get_theme_options(); // Get options

			//Pre defined Social Icons Link Start
			$pre_def_social_icons 	=	gridalicious_get_social_icons_list();

			foreach ($pre_def_social_icons as $key => $item) {
				if (isset($options[$key]) && '' != $options[$key]) {
					$value = $options[$key];

					if (
						'email_link' == $key
						|| 'website_link' == $key
						|| 'phone_link' == $key
						|| 'handset_link' == $key
						|| 'feed_link' == $key
						|| 'mobile_link' == $key
						|| 'cart_link' == $key
						|| 'cart_link' == $key
						|| 'cloud_link' == $key
						|| 'link_link' == $key
					) {
						$output .= '<a class="font-awesome fa-solid fa-' . sanitize_key($item['fa_class']) . '" target="_blank" title="' . esc_attr($item['label']) . '" href="' . esc_attr($value) . '"><span class="screen-reader-text">' . esc_attr($item['label']) . '</span> </a>';
					} else {
						$output .= '<a class="font-awesome fa-brands fa-' . sanitize_key($item['fa_class']) . '" target="_blank" title="' . esc_attr($item['label']) . '" href="' . esc_url($value) . '"><span class="screen-reader-text">' . esc_attr($item['label']) . '</span> </a>';
					}
				}
			}
			//Pre defined Social Icons Link End

			//Custom Social Icons Link End
			set_transient('gridalicious_social_icons', $output, 86940);
		}
		return $output;
	} // gridalicious_get_social_icons
endif;
