<?php
if ( ! class_exists( 'Green_Farm_Elementor_Plugin_Activation_WPElemento_Importer' ) ) {
    /**
     * Green_Farm_Elementor_Plugin_Activation_WPElemento_Importer initial setup
     *
     * @since 1.6.2
     */

    class Green_Farm_Elementor_Plugin_Activation_WPElemento_Importer {

        private static $green_farm_elementor_instance;
        public $green_farm_elementor_action_count;
        public $green_farm_elementor_recommended_actions;

        /** Initiator **/
        public static function get_instance() {
          if ( ! isset( self::$green_farm_elementor_instance) ) {
            self::$green_farm_elementor_instance = new self();
          }
          return self::$green_farm_elementor_instance;
        }

        /*  Constructor */
        public function __construct() {

            add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

            // ---------- wpelementoimpoter Plugin Activation -------
            add_filter( 'green_farm_elementor_recommended_plugins', array($this, 'green_farm_elementor_recommended_elemento_importer_plugins_array') );

            $green_farm_elementor_actions                   = $this->green_farm_elementor_get_recommended_actions();
            $this->green_farm_elementor_action_count        = $green_farm_elementor_actions['count'];
            $this->green_farm_elementor_recommended_actions = $green_farm_elementor_actions['actions'];

            add_action( 'wp_ajax_create_pattern_setup_builder', array( $this, 'create_pattern_setup_builder' ) );
        }

        public function green_farm_elementor_recommended_elemento_importer_plugins_array($green_farm_elementor_plugins){
            $green_farm_elementor_plugins[] = array(
                    'name'     => esc_html__('WPElemento Importer', 'green-farm-elementor'),
                    'slug'     =>  'wpelemento-importer',
                    'function' => 'WPElemento_Importer_ThemeWhizzie',
                    'desc'     => esc_html__('We highly recommend installing the WPElemento Importer plugin for importing the demo content with Elementor.', 'green-farm-elementor'),               
            );
            return $green_farm_elementor_plugins;
        }

        public function enqueue_scripts() {
            wp_enqueue_script('updates');      
            wp_register_script( 'green-farm-elementor-plugin-activation-script', esc_url(get_template_directory_uri()) . '/includes/getstart/js/plugin-activation.js', array('jquery') );
            wp_localize_script('green-farm-elementor-plugin-activation-script', 'green_farm_elementor_plugin_activate_plugin',
                array(
                    'installing' => esc_html__('Installing', 'green-farm-elementor'),
                    'activating' => esc_html__('Activating', 'green-farm-elementor'),
                    'error' => esc_html__('Error', 'green-farm-elementor'),
                    'ajax_url' => esc_url(admin_url('admin-ajax.php')),
                    'wpelementoimpoter_admin_url' => esc_url(admin_url('admin.php?page=wpelemento-importer-tgmpa-install-plugins')),
                    'addon_admin_url' => esc_url(admin_url('admin.php?page=wpelementoimporter-wizard'))
                )
            );
            wp_enqueue_script( 'green-farm-elementor-plugin-activation-script' );

        }

        // --------- Plugin Actions ---------
        public function green_farm_elementor_get_recommended_actions() {

            $green_farm_elementor_act_count  = 0;
            $green_farm_elementor_actions_todo = get_option( 'recommending_actions', array());

            $green_farm_elementor_plugins = $this->green_farm_elementor_get_recommended_plugins();

            if ($green_farm_elementor_plugins) {
                foreach ($green_farm_elementor_plugins as $green_farm_elementor_key => $green_farm_elementor_plugin) {
                    $green_farm_elementor_action = array();
                    if (!isset($green_farm_elementor_plugin['slug'])) {
                        continue;
                    }

                    $green_farm_elementor_action['id']   = 'install_' . $green_farm_elementor_plugin['slug'];
                    $green_farm_elementor_action['desc'] = '';
                    if (isset($green_farm_elementor_plugin['desc'])) {
                        $green_farm_elementor_action['desc'] = $green_farm_elementor_plugin['desc'];
                    }

                    $green_farm_elementor_action['name'] = '';
                    if (isset($green_farm_elementor_plugin['name'])) {
                        $green_farm_elementor_action['title'] = $green_farm_elementor_plugin['name'];
                    }

                    $green_farm_elementor_link_and_is_done  = $this->green_farm_elementor_get_plugin_buttion($green_farm_elementor_plugin['slug'], $green_farm_elementor_plugin['name'], $green_farm_elementor_plugin['function']);
                    $green_farm_elementor_action['link']    = $green_farm_elementor_link_and_is_done['button'];
                    $green_farm_elementor_action['is_done'] = $green_farm_elementor_link_and_is_done['done'];
                    if (!$green_farm_elementor_action['is_done'] && (!isset($green_farm_elementor_actions_todo[$green_farm_elementor_action['id']]) || !$green_farm_elementor_actions_todo[$green_farm_elementor_action['id']])) {
                        $green_farm_elementor_act_count++;
                    }
                    $green_farm_elementor_recommended_actions[] = $green_farm_elementor_action;
                    $green_farm_elementor_actions_todo[]        = array('id' => $green_farm_elementor_action['id'], 'watch' => true);
                }
                return array('count' => $green_farm_elementor_act_count, 'actions' => $green_farm_elementor_recommended_actions);
            }

        }

        public function green_farm_elementor_get_recommended_plugins() {

            $green_farm_elementor_plugins = apply_filters('green_farm_elementor_recommended_plugins', array());
            return $green_farm_elementor_plugins;
        }

        public function green_farm_elementor_get_plugin_buttion($slug, $name, $function) {
                $green_farm_elementor_is_done      = false;
                $green_farm_elementor_button_html  = '';
                $green_farm_elementor_is_installed = $this->is_plugin_installed($slug);
                $green_farm_elementor_plugin_path  = $this->get_plugin_basename_from_slug($slug);
                $green_farm_elementor_is_activeted = (class_exists($function)) ? true : false;
                if (!$green_farm_elementor_is_installed) {
                    $green_farm_elementor_plugin_install_url = add_query_arg(
                        array(
                            'action' => 'install-plugin',
                            'plugin' => $slug,
                        ),
                        self_admin_url('update.php')
                    );
                    $green_farm_elementor_plugin_install_url = wp_nonce_url($green_farm_elementor_plugin_install_url, 'install-plugin_' . esc_attr($slug));
                    $green_farm_elementor_button_html        = sprintf('<a class="green-farm-elementor-plugin-install install-now button-secondary button" data-slug="%1$s" href="%2$s" aria-label="%3$s" data-name="%4$s">%5$s</a>',
                        esc_attr($slug),
                        esc_url($green_farm_elementor_plugin_install_url),
                        sprintf(esc_html__('Install %s Now', 'green-farm-elementor'), esc_html($name)),
                        esc_html($name),
                        esc_html__('Install & Activate', 'green-farm-elementor')
                    );
                } elseif ($green_farm_elementor_is_installed && !$green_farm_elementor_is_activeted) {

                    $green_farm_elementor_plugin_activate_link = add_query_arg(
                        array(
                            'action'        => 'activate',
                            'plugin'        => rawurlencode($green_farm_elementor_plugin_path),
                            'plugin_status' => 'all',
                            'paged'         => '1',
                            '_wpnonce'      => wp_create_nonce('activate-plugin_' . $green_farm_elementor_plugin_path),
                        ), self_admin_url('plugins.php')
                    );

                    $green_farm_elementor_button_html = sprintf('<a class="green-farm-elementor-plugin-activate activate-now button-primary button" data-slug="%1$s" href="%2$s" aria-label="%3$s" data-name="%4$s">%5$s</a>',
                        esc_attr($slug),
                        esc_url($green_farm_elementor_plugin_activate_link),
                        sprintf(esc_html__('Activate %s Now', 'green-farm-elementor'), esc_html($name)),
                        esc_html($name),
                        esc_html__('Activate', 'green-farm-elementor')
                    );
                } elseif ($green_farm_elementor_is_activeted) {
                    $green_farm_elementor_button_html = sprintf('<div class="action-link button disabled"><span class="dashicons dashicons-yes"></span> %s</div>', esc_html__('Active', 'green-farm-elementor'));
                    $green_farm_elementor_is_done     = true;
                }

                return array('done' => $green_farm_elementor_is_done, 'button' => $green_farm_elementor_button_html);
            }
        public function is_plugin_installed($slug) {
            $green_farm_elementor_installed_plugins = $this->get_installed_plugins(); // Retrieve a list of all installed plugins (WP cached).
            $green_farm_elementor_file_path         = $this->get_plugin_basename_from_slug($slug);
            return (!empty($green_farm_elementor_installed_plugins[$green_farm_elementor_file_path]));
        }
        public function get_plugin_basename_from_slug($slug) {
            $green_farm_elementor_keys = array_keys($this->get_installed_plugins());
            foreach ($green_farm_elementor_keys as $green_farm_elementor_key) {
                if (preg_match('|^' . $slug . '/|', $green_farm_elementor_key)) {
                    return $green_farm_elementor_key;
                }
            }
            return $slug;
        }

        public function get_installed_plugins() {

            if (!function_exists('get_plugins')) {
                require_once ABSPATH . 'wp-admin/includes/plugin.php';
            }

            return get_plugins();
        }
        public function create_pattern_setup_builder() {

            $edit_page = admin_url().'post-new.php?post_type=page&create_pattern=true';
            echo json_encode(['page_id'=>'','edit_page_url'=> $edit_page ]);

            exit;
        }

    }
}
/**
 * Kicking this off by calling 'get_instance()' method
 */
Green_Farm_Elementor_Plugin_Activation_WPElemento_Importer::get_instance();