<?php

function get_page_id_by_title($green_farm_elementor_pagename){
  $green_farm_elementor_args = array(
 'post_type' => 'page',
 'posts_per_page' => 1,
 'title' => $green_farm_elementor_pagename
  );
  $green_farm_elementor_query = new WP_Query( $green_farm_elementor_args );    $green_farm_elementor_page_id = '1';
 if (isset($green_farm_elementor_query->post->ID)) {
      $green_farm_elementor_page_id = $green_farm_elementor_query->post->ID;
  } return $green_farm_elementor_page_id;
}
//about theme info
add_action( 'admin_menu', 'green_farm_elementor_gettingstarted' );
function green_farm_elementor_gettingstarted() {
	add_theme_page( esc_html__('Green Farm Elementor', 'green-farm-elementor'), esc_html__('Green Farm Elementor', 'green-farm-elementor'), 'edit_theme_options', 'green_farm_elementor_about', 'green_farm_elementor_mostrar_guide');
}

// Add a Custom CSS file to WP Admin Area
function green_farm_elementor_admin_theme_style() {
	wp_enqueue_style('green-farm-elementor-custom-admin-style', esc_url(get_template_directory_uri()) . '/includes/getstart/getstart.css');
	wp_enqueue_script('green-farm-elementor-tabs', esc_url(get_template_directory_uri()) . '/includes/getstart/js/tab.js');
	wp_enqueue_style( 'font-awesome-css', get_template_directory_uri().'/assets/css/fontawesome-all.css' );

	// Admin notice code START
	wp_register_script('green-farm-elementor-notice', esc_url(get_template_directory_uri()) . '/includes/getstart/js/notice.js', array('jquery'), time(), true);
	wp_enqueue_script('green-farm-elementor-notice');
	// Admin notice code END
}
add_action('admin_enqueue_scripts', 'green_farm_elementor_admin_theme_style');

// Changelog
if ( ! defined( 'GREEN_FARM_ELEMENTOR_CHANGELOG_URL' ) ) {
    define( 'GREEN_FARM_ELEMENTOR_CHANGELOG_URL', get_template_directory() . '/readme.txt' );
}

function green_farm_elementor_changelog_screen() {
	global $wp_filesystem;
	$green_farm_elementor_changelog_file = apply_filters( 'green_farm_elementor_changelog_file', GREEN_FARM_ELEMENTOR_CHANGELOG_URL );

	if ( $green_farm_elementor_changelog_file && is_readable( $green_farm_elementor_changelog_file ) ) {
		WP_Filesystem();
		$green_farm_elementor_changelog = $wp_filesystem->get_contents( $green_farm_elementor_changelog_file );
		$green_farm_elementor_changelog_list = green_farm_elementor_parse_changelog( $green_farm_elementor_changelog );

		
		echo '<div id="green-farm-elementor-changelog-container">';
		echo wp_kses_post( $green_farm_elementor_changelog_list );
		echo '</div>';
		echo '<button id="green-farm-elementor-load-more" class="button button-primary" style="margin-top:15px;">Load More</button>';
	}
}

function green_farm_elementor_parse_changelog( $green_farm_elementor_content ) {
	$green_farm_elementor_content = explode ( '== ', $green_farm_elementor_content );
	$green_farm_elementor_changelog_isolated = '';

	foreach ( $green_farm_elementor_content as $key => $green_farm_elementor_value ) {
		if ( strpos( $green_farm_elementor_value, 'Changelog ==' ) === 0 ) {
	    	$green_farm_elementor_changelog_isolated = str_replace( 'Changelog ==', '', $green_farm_elementor_value );
	    }
	}

	$green_farm_elementor_changelog_array = explode( '= ', $green_farm_elementor_changelog_isolated );
	unset( $green_farm_elementor_changelog_array[0] );

	$green_farm_elementor_changelog = '<div class="changelog">';
	foreach ( $green_farm_elementor_changelog_array as $green_farm_elementor_value ) {
		$green_farm_elementor_value = preg_replace( '/\n+/', '</span><span>', $green_farm_elementor_value );
		$green_farm_elementor_value = '<div class="block-changelog"><span class="heading">= ' . $green_farm_elementor_value . '</span></div>';
		$green_farm_elementor_changelog .= str_replace( '<span></span>', '', $green_farm_elementor_value );
	}
	$green_farm_elementor_changelog .= '</div>';

	return wp_kses_post( $green_farm_elementor_changelog );
}

//guidline for about theme
function green_farm_elementor_mostrar_guide() { 
	//custom function about theme customizer
	$green_farm_elementor_return = add_query_arg( array()) ;
	$green_farm_elementor_theme = wp_get_theme( 'green-farm-elementor' );
	?>
<div class="container-getstarted">
		<div class="inner-side-content1">
			<div class="tab-outer-box">
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/includes/getstart/images/sticky-header-logo.png" />
			</div>
		    <div class="coupon-container-box-left">
			    <div class="iner-sidebar-pro-btn">
				    <span class="premium-btn"><a href="<?php echo esc_url( GREEN_FARM_ELEMENTOR_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Premium Theme', 'green-farm-elementor'); ?></a>
				    </span>
			    </div>
		    </div>
        </div>					
   <div class="top-head">
	    <div class="top-title">
		     <h2><?php esc_html_e( 'Green Farm Elementor', 'green-farm-elementor' ); ?></h2>
		     <h4><?php esc_html_e( 'Welcome to WP Elemento Theme!', 'green-farm-elementor' ); ?></h4>
		     <p><?php esc_html_e( 'Click on the quick start button to import the demo.', 'green-farm-elementor' ); ?></p>
			    <div class="iner-sidebar-pro-btn">
					<?php if(!class_exists('WPElemento_Importer_ThemeWhizzie')){
						$green_farm_elementor_plugin_ins = Green_Farm_Elementor_Plugin_Activation_WPElemento_Importer::get_instance();
						$green_farm_elementor_actions = $green_farm_elementor_plugin_ins->green_farm_elementor_recommended_actions;
					?>
					<div class="green-farm-elementor-recommended-plugins ">
						<div class="green-farm-elementor-action-list">
							<?php if ($green_farm_elementor_actions): foreach ($green_farm_elementor_actions as $green_farm_elementor_key => $green_farm_elementor_actionValue): ?>
									<div class="green-farm-elementor-action" id="<?php echo esc_attr($green_farm_elementor_actionValue['id']);?>">
										<div class="action-inner plugin-activation-redirect">
											<?php echo wp_kses_post($green_farm_elementor_actionValue['link']); ?>
										</div>
									</div>
								<?php endforeach;
							endif; ?>
						</div>
					</div>
				   <?php }else{ ?>
					<span class="quick-btn">
				    <?php if (isset($_GET['imported']) && $_GET['imported'] == 'true'): ?>
                        <a href="<?php echo esc_url( site_url() ); ?>" target="_blank"><?php esc_html_e('Visit Site', 'green-farm-elementor'); ?></a>
						<?php
						$green_farm_elementor_page_id = get_page_id_by_title('Home');
						?>
						<a href="<?php echo esc_url( admin_url('post.php?post=' . $green_farm_elementor_page_id . '&action=elementor') ); ?>" 
							target="_blank" class="elementor-edit-btn"><?php esc_html_e('Edit With Elementor', 'green-farm-elementor'); ?>
						</a>
                    <?php else: ?>
                        <a href="<?php echo esc_url( admin_url('admin.php?page=wpelementoimporter-wizard') ); ?>"><?php esc_html_e('Quick Start', 'green-farm-elementor'); ?></a>
                    <?php endif; ?>
					<?php } ?>
				   </span>
				    <span class="premium-btn"><a href="<?php echo esc_url( GREEN_FARM_ELEMENTOR_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Premium', 'green-farm-elementor'); ?></a>
				    </span>
				    <span class="demo-btn"><a href="<?php echo esc_url( GREEN_FARM_ELEMENTOR_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'green-farm-elementor'); ?></a>
				    </span>
				    <span class="doc-btn"><a href="<?php echo esc_url( GREEN_FARM_ELEMENTOR_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e('Theme Bundle at $79', 'green-farm-elementor'); ?></a>
				    </span>
			    </div>
            </div>			
		<div class="inner-side-content">
			<div class="tab-outer-box">
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png" />
			</div>
			<div class="top-right">
			  <span class="version"><?php esc_html_e( 'Version', 'green-farm-elementor' ); ?>: <?php echo esc_html($green_farm_elementor_theme['Version']);?></span>
		    </div>
		</div>
    </div>
    <div class="inner-cont">
	    <div class="tab-outer-box1">
		   <div class="tab-inner-box">
			   <div class= "bundle-box">
				    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/includes/getstart/images/bundle.png"/>
				    <h1><?php esc_html_e('ELEMENTOR WORDPRESS THEME BUNDLE', 'green-farm-elementor'); ?></h1>
			     <div>
				    <p class="product-price"><?php esc_html_e('Price:', 'green-farm-elementor'); ?>
                        <span class="regular-price"><?php esc_html_e('$1,999.00', 'green-farm-elementor'); ?></span>
                        <span class="sale-price"><?php esc_html_e('$79.00', 'green-farm-elementor'); ?></span>
                    </p>
					<p><?php esc_html_e('The Elementor WordPress Theme Bundle offers a stunning collection of 76+ Premium Elementor Themes', 'green-farm-elementor'); ?></p>
                 </div>
				</div> 
			    <div class="offer-box"> 
				    <div class="offer1-box">
                       <span class="off-text1"><a href="<?php echo esc_url( GREEN_FARM_ELEMENTOR_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e('Buy Bundle at 20% Discount', 'green-farm-elementor'); ?></a></span>
				    </div> 
		        </div>
			</div>	
		</div>	
		<div class="tab-outer-box2">
			<div class="tab-outer-box-2-1">
			  <h3><?php esc_html_e( 'Customizer Setting', 'green-farm-elementor' ); ?></h3>
			  <div class="lite-theme-inner">
				<div>
					<h3><?php esc_html_e('Theme Customizer', 'green-farm-elementor'); ?></h3>
					<p><?php esc_html_e('To begin customizing your website, start by clicking "Customize".', 'green-farm-elementor'); ?></p>
					<div class="info-link">
					   <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Open customizer', 'green-farm-elementor'); ?></a>
					</div>
				</div>
				<div>
					<h3><?php esc_html_e('Help Docs', 'green-farm-elementor'); ?></h3>
					<p><?php esc_html_e('The complete procedure to configure and manage a WordPress Website from the beginning is shown in this documentation .', 'green-farm-elementor'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( GREEN_FARM_ELEMENTOR_FREE_THEME_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'green-farm-elementor'); ?></a>
					</div>
				</div>
				<div>
					<h3><?php esc_html_e('Need Support?', 'green-farm-elementor'); ?></h3>
					<p><?php esc_html_e('Our dedicated team is well prepared to help you out in case of queries and doubts regarding our theme.', 'green-farm-elementor'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( GREEN_FARM_ELEMENTOR_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support Forum', 'green-farm-elementor'); ?></a>
					</div>
				</div>
				<div>
					<h3><?php esc_html_e('Reviews & Testimonials', 'green-farm-elementor'); ?></h3>
					<p> <?php esc_html_e('All the features and aspects of this WordPress Theme are phenomenal. I\'d recommend this theme to all.', 'green-farm-elementor'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( GREEN_FARM_ELEMENTOR_REVIEW ); ?>" target="_blank"><?php esc_html_e('Review', 'green-farm-elementor'); ?></a>
					</div>
				</div>
            </div>	
		</div>
			<div class="tab-outer-box-2-2">
			  <h3><?php esc_html_e( 'Link to customizer', 'green-farm-elementor' ); ?></h3>
				<div class="first-row">
					<div class="row-box">
						<div class="row-box1">
							<span class="dashicons dashicons-buddicons-buddypress-logo"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=custom_logo') ); ?>" target="_blank"><?php esc_html_e('Upload your Website logo','green-farm-elementor'); ?></a>
						</div>
						<div class="row-box2">
							<span class="dashicons dashicons-menu"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=nav_menus') ); ?>" target="_blank"><?php esc_html_e('Edit Your Menus','green-farm-elementor'); ?></a>
						</div>
					</div>
							
					<div class="row-box">
						<div class="row-box1">
							<span class="dashicons dashicons-align-center"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=header_image') ); ?>" target="_blank"><?php esc_html_e('Add Header Image','green-farm-elementor'); ?></a>
						</div>
						<div class="row-box2">
							<span class="dashicons dashicons-screenoptions"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=widgets') ); ?>" target="_blank"><?php esc_html_e('Add Footer Widget','green-farm-elementor'); ?></a>
						</div>
					</div>
				</div>
            </div>	
			<div class="tab-outer-box-2-3">
				<h3><?php esc_html_e( 'Change log', 'green-farm-elementor' ); ?></h3>	
		     <?php green_farm_elementor_changelog_screen(); ?>
          </div>	
        </div>
    </div>
</div>	
<?php } ?>