<?php Global $THEME, $post; Get_Header(); The_Post(); WP_Enqueue_Script('comment-reply', Null, Null, Null, True); ?>

<article <?php Post_Class() ?> >
  <div class="page-header">
    <h1>
      <?php The_Title() ?>
      <?php Edit_Post_Link( Null, '<small class="edit">(', ')</small>') ?>
    </h1>
  </div>

  <?php Get_Template_Part('post-meta') ?>

  <?php If (!Empty($post->post_excerpt)): ?>
  <div class="excerpt"><?php The_Excerpt() ?></div>
  <?php EndIf ?>

  <?php If (Has_Post_Thumbnail()): ?>
  <?php The_Post_Thumbnail('large', Array('class' => 'keyvisual thumbnail')) ?>
  <?php EndIf ?>

  <div class="entry"><?php The_Content() ?></div>

  <?php $THEME->WP_Link_Pages('page-navigation') ?>

  <ul class="post pager">
    <?php Previous_Post_Link('<li class="previous">%link</li>', '&laquo; '.$THEME->t('Previous Post')) ?>
    <?php Next_Post_Link('<li class="next">%link</li>', $THEME->t('Next Post').' &raquo;') ?>
  </ul>

  <?php If ($biography = Get_The_Author_Meta('description')): ?>
  <div class="author-details panel panel-default">
    <div class="panel-heading">
      <h3 class="panel-title"><?php Echo $THEME->t('About the Author') ?></h3>
    </div>
    <div class="panel-body">
      <div class="col-sm-3"><?php Echo Get_Avatar(Null, 237) ?></div>
        <div class="col-sm-9"><h4><?php The_Author_Posts_Link() ?></h4>
        <p><?php Echo $biography ?></p>
      </div>
    </div>
  </div>
  <?php EndIf ?>

  <?php Comments_Template() ?>

</article>

<?php Get_Footer();