<?php Global $THEME, $wp_query;

$pagination = Paginate_Links(Array(
  'base' => Get_PageNum_Link(0) . '%_%',
  'format' => '?paged=%#%',
  'current' => Get_Query_Var('paged') ? IntVal(Get_Query_Var('paged')) : 1,
  'total' => IntVal($wp_query->max_num_pages),
  'type' => 'array'
));

If (!Empty($pagination)): ?>
<ul class="archive pagination">
  <?php ForEach ($pagination As $page_link):
    $active = StrPos($page_link, 'page-numbers current') !== False;
    $disabled = StrPos($page_link, 'page-numbers dots') !== False;
  ?>
  <li class="<?php Echo $active ? 'active' : '' ?> <?php Echo $disabled ? 'disabled' : '' ?>">
    <?php Echo $page_link ?>
  </li>
  <?php EndForEach ?>
</ul>
<?php EndIf;