<?php

Namespace WordPress\Theme\Gray_and_Square;

# Define the Master Theme
class Core {
  var $body_class = Array();
  var $sidebars = Array();

  function __construct(){
    # Get ready to translate
    Add_Action('after_setup_theme', Array($this, 'Load_TextDomain'));

    # Register Menus, Widgets, Sidebars
    Add_Action('after_setup_theme', Array($this, 'Define_Theme_Sidebars'));
    Add_Action('after_setup_theme', Array($this, 'Define_Content_Width'));
    Add_Action('widgets_init', Array($this, 'Register_Sidebars'), 99);

  	# Add theme support
  	Add_Theme_Support('automatic-feed-links');
    Add_Theme_Support('html5', Array('comment-list', 'comment-form', 'search-form', 'gallery', 'caption'));
    Add_Theme_Support('post-thumbnails');
    Add_Theme_Support('custom-background');
    Add_Theme_Support('custom-header', Array(
      'flex-width' => True,
      'width' => 1920,
      'flex-height' => True,
      'height' => 240,
      'header-text' => True,
      'default-text-color' => '000000',
      'admin-preview-callback' => function(){ PrintF('<iframe src="%s" style="width:100%%; height:400px"></iframe>', Home_Url()); }
    ));

    # Some Filter and Actions
    Add_Filter('body_class', Array($this, 'Filter_Body_Class'));
    Add_Filter('wp_get_attachment_image_attributes', Array($this, 'Filter_Attachment_Image_Attributes'), 10, 2);
    Add_Filter('search_template', Array($this, 'Filter_Search_Template'));
    Add_Filter('tiny_mce_before_init', Array($this, 'Filter_Tiny_MCE_Init'));

    # Load Javascripts & Styles
    Add_Action('wp_enqueue_scripts', Array($this, 'Enqueue_Styles_and_Scripts'));
    Add_Action('admin_enqueue_scripts', Array($this, 'Enqueue_Admin_Styles_and_Scripts'));
    Add_Action('wp_default_scripts', Array($this, 'Move_jQuery_to_Footer'));

		# Customize Login page
		Add_Action('login_enqueue_scripts', Array ($this, 'Login_Enqueue_Scripts'));
		Add_Filter('login_headerurl', Array ($this, 'Login_Header_URL'));
		Add_Filter('login_headertitle', Array($this, 'Login_Header_Title'));

		# Remove Actions
		Add_Action('widgets_init', Array($this, 'Remove_Recent_Comments_Inline_Style'));

    # Image sizes
    Add_Image_Size('loop-thumbnail', 275, 350, True);
    Add_Image_Size('loop-banner', 720, 300, True);
  }

  function Remove_Recent_Comments_Inline_Style(){
		Global $wp_widget_factory;
    Remove_Action('wp_head', Array($wp_widget_factory->widgets['WP_Widget_Recent_Comments'], 'recent_comments_style'));
	}

  function Get_Custom_Header(){
    $header = Get_Custom_Header();
    $header->textcolor = get_header_textcolor();
    return $header;
  }

  function Load_TextDomain(){
    $locale = Apply_Filters('theme_locale', Get_Locale(), __CLASS__);
    If (Is_Child_Theme()) Load_Textdomain (__CLASS__, Get_Template_Directory().'/language/' . $locale . '.mo');
    Load_Textdomain (__CLASS__, Get_Stylesheet_Directory().'/language/' . $locale . '.mo');
  }

  function t ($text, $context = ''){
    # Translates the string $text with context $context
    If ($context == '')
      return __ ($text, __CLASS__);
    Else
      return _x ($text, $context, __CLASS__);
  }

  function Define_Theme_Sidebars(){
    $empty_notice = $this->t('If you do not want to use this sidebar, just leave it empty.');
    $this->Add_Sidebar('sidebar-left', $this->t('Left'), SPrintF('%s %s', $this->t('This is the left sidebar.'), $empty_notice));
    $this->Add_Sidebar('sidebar-right', $this->t('Right'), SPrintF('%s %s', $this->t('This is the right sidebar.'), $empty_notice));
  }

  function Add_Sidebar($id, $title, $description = Null, $args = Array()){
    $this->sidebars[$id] = (Object) Array_Merge(Array(
      'id'            => $id,
      'title'         => $title,
      'description'   => $description,
      'before_widget' => '<aside id="%1$s" class="panel-body widget %2$s">',
      'after_widget'  => '</aside>',
      'before_title'  => '<h3 class="widget-title">',
      'after_title'   => '</h3>'
    ), $args);
  }

  function Delete_Sidebar($id){
    Unset($this->sidebars[$id]);
  }

  function Register_Sidebars(){
    ForEach($this->sidebars AS $sidebar){
      Register_sidebar (Array(
        'id'            => $sidebar->id,
        'name'          => $sidebar->title,
        'description'   => $sidebar->description,
        'before_widget' => $sidebar->before_widget,
        'after_widget'  => $sidebar->after_widget,
        'before_title'  => $sidebar->before_title,
        'after_title'   => $sidebar->after_title,
      ));
    }
  }

  function Has_Left_Sidebar(){
    return Is_Active_Sidebar('sidebar-left');
  }

  function Has_Right_Sidebar(){
    return Is_Active_Sidebar('sidebar-right');
  }

  function Define_Content_Width(){
    Global $content_width;

    If ($this->Has_Left_Sidebar() && $this->Has_Right_Sidebar())
      $content_width = 555;
    ElseIf (!$this->Has_Left_Sidebar() && !$this->Has_Right_Sidebar())
      $content_width = 1140;
    Else
      $content_width = 848;
  }

  function Enqueue_Admin_Styles_and_Scripts(){
    Add_Editor_Style(Get_StyleSheet_Uri());
  }

  function Enqueue_Styles_and_Scripts(){
    # Dequeue scripts and styles we do not need
    WP_Dequeue_Style('contact-form-7'); # We define our own style for the contact form 7 elements

    WP_Enqueue_Script('theme', $this->Locate_File_URI('assets/js/theme.js'), Array('jquery'), Null, True);
    WP_Enqueue_Style('dashicons');
    WP_Enqueue_Style('theme', Get_StyleSheet_Uri());
  }

  function Move_jQuery_To_Footer($wp_scripts){
    Global $pagenow;
    If (!Is_Admin() && $pagenow != 'wp-login.php'){
      $wp_scripts->registered['jquery'] = Clone $wp_scripts->registered['jquery-core'];
      $wp_scripts->registered['jquery']->handle = 'jquery';
      $wp_scripts->add_data('jquery', 'group', 1);
      $wp_scripts->remove('jquery-migrate');
      $wp_scripts->remove('jquery-core');
    }
  }

  function Filter_Body_Class($class){
    $class = Array_Merge($class, $this->body_class);
    return $class;
  }

  function Add_Body_Class($class){
    $this->body_class[] = $class;
  }

  function Filter_Tiny_MCE_Init($tiny_init){
    If ($this->Has_Left_Sidebar() && $this->Has_Right_Sidebar())
      $tiny_init['body_class'] = 'content-width-6';
    ElseIf (!$this->Has_Left_Sidebar() && !$this->Has_Right_Sidebar())
      $tiny_init['body_class'] = 'content-width-12';
    Else
      $tiny_init['body_class'] = 'content-width-9';

    return $tiny_init;
  }

  function Login_Enqueue_Scripts(){
    WP_Enqueue_Style('theme', Get_Stylesheet_Uri());
  }

  function Login_Header_URL($url){ return Home_Url(); }

  function Login_Header_Title($title){ return get_option('blogname'); }

  function Filter_Attachment_Image_Attributes($attr, $attachment){
    return Array_Merge(Array(
      'title' => $attr['alt']
    ), $attr);
  }

  function Filter_Search_Template($template){
    $post_type_search_template = Locate_Template(SPrintF('search-%s.php', Get_Query_Var('post_type')));
    If (!Empty($post_type_search_template))
      return $post_type_search_template;
    Else
      return $template;
  }

  function WP_Link_Pages($class = False){
    WP_Link_Pages(Array(
      'before' => SPrintF('<ul class="pagination %s">', $class),
      'after' => '</ul>'
    ));
  }

  function Render_Sidebar ($sidebar_name){
    If (Is_Active_Sidebar($sidebar_name)): ?>
    <div class="sidebar <?php Echo $sidebar_name ?>">
      <?php Dynamic_Sidebar($sidebar_name) ?>
    </div>
    <?php Else:
      return False;
    EndIf;
  }

  function Locate_File ($file){
    If (SubStr($file, 0, 1) != '/')
      $file = '/' . $file;

		If (File_Exists(Get_Stylesheet_Directory() . $file))
			return Get_Stylesheet_Directory() . $file;

		ElseIf (File_Exists(Get_Template_Directory() . $file))
			return Get_Template_Directory() . $file;

		Else
      return False;
	}

  function Locate_File_URI ($file){
    If (SubStr($file, 0, 1) != '/')
      $file = '/' . $file;

		If (File_Exists(get_stylesheet_directory() . $file))
			return get_stylesheet_directory_uri() . $file;

		ElseIf (File_Exists(get_template_directory() . $file))
			return get_template_directory_uri() . $file;

		Else
      return False;
	}

} /* End of Class */