<?php

Namespace WordPress\Theme\Gray_and_Square;

class Bootstrap_WP_Formats {

  function __construct(){
    Add_Filter('wp_link_pages_args', Array($this, 'Filter_WP_Link_Pages_Args'));
    Add_Filter('wp_link_pages_link', Array($this, 'Filter_WP_Link_Pages_Link'), 10, 2);
  }

  function Filter_WP_Link_Pages_Args($args){
    Global $page, $numpages;
    If ($page > 1)
      $args['before'] .= SPrintF('<li>%s%s&laquo;%s</a></li>', _WP_Link_Page($page-1), $args['link_before'], $args['link_after']);
    Else
      $args['before'] .= '<li class="disabled"><a>&laquo;</a></li>';

    If ($page < $numpages)
      $args['after'] = SPrintF('<li>%s%s&raquo;%s</a></li>', _WP_Link_Page($page+1), $args['link_before'], $args['link_after']) . $args['after'];
    Else
      $args['after'] = '<li class="disabled"><a>&raquo;</a></li>' . $args['after'];

    return $args;
  }

  function Filter_WP_Link_Pages_Link($link, $page_number){
    Global $page, $numpages;
    If ($page_number == $page)
      return SPrintF('<li class="active"><a>%s</a></li>', $link);
    Else
      return SPrintF('<li>%s</li>', $link);
  }

}