<?php Global $THEME ?>

<?php If (Have_Comments()): ?>

	<h2 id="comments"><?php Comments_Number() ?></h2>

	<p><?php PrintF($THEME->t('You can follow any responses to this entry through the <a href="%s">RSS 2.0</a> feed.'), Get_Post_Comments_Feed_Link()) ?></p>

  <?php Get_Template_Part('pagination', 'comments') ?>

	<div class="commentlist">
	<?php wp_list_comments(Array(
    'callback' => function($comment, $args, $depth){
      Global $comment;
      $comment->args = $args;
      $comment->depth = $depth;
      Get_Template_Part('comments-single');
    },
    'end-callback' => function(){ /* No closing tag, please. Thanks. */ }
  )) ?>
	</div>

  <?php Get_Template_Part('pagination', 'comments') ?>

<?php EndIf;

Comments_Open() && Comment_Form(Array(
  'fields' => Apply_Filters('comment_form_default_fields', Array(

    'author' => SPrintF('
      <p class="input-group">
        <span class="input-group-addon">
          <label for="author" class="glyphicon glyphicon-user"></label>
        </span>
        <input type="text" name="author" id="author" class="form-control" placeholder="%s">
      </p>', $THEME->t('Your name')),

    'email' => SPrintF('
      <p class="input-group">
        <span class="input-group-addon">
          <label for="email" class="glyphicon glyphicon-envelope"></label>
        </span>
        <input type="email" name="email" id="email" class="form-control" placeholder="%s">
      </p>', $THEME->t('Your email address')),

    'url' => SPrintF('
      <p class="input-group">
        <span class="input-group-addon">
          <label for="url" class="glyphicon glyphicon-globe"></label>
        </span>
        <input type="text" name="url" id="url" class="form-control" placeholder="%s">
      </p>', $THEME->t('Your website url'))

  )),

  'comment_field' => SPrintF('
    <p class="comment-form-comment input-group">
      <span class="input-group-addon">
        <label for="comment" class="glyphicon glyphicon-comment"></label>
      </span>
      <textarea id="comment" name="comment" cols="45" rows="8" aria-required="true" class="form-control" placeholder="%s"></textarea>
    </p>', $THEME->t('Your comment'))

));