<?php
/* Sidebar */
if(!isset($content_width)) $content_width = 500;



add_action( 'widgets_init', 'Grayandgold_register_sidebars' );

function Grayandgold_register_sidebars() {

	/* Register the 'primary' sidebar. */
    register_sidebar(array(
		'id' => 'Sidebar',
		'name' => __( 'Sidebar', 'Grayandgold' ),
		'description' => __( 'This is the primary widget in the sidebar, it is placed in the right column' , 'Grayandgold'),		
        'before_widget' => '<li id="%1$s" class="widget %2$s">',
        'after_widget' => '</li>',
        'before_title' => '<h3 class="widgettitle-sidebar">',
        'after_title' => '</h3>',
    ));

		/* Register the sidebar in the footer, position 'left'. */
	register_sidebar(
		array(
			'id' => 'footer_left',
			'name' => __( 'Footer (Left side)', 'Grayandgold' ),
			'description' => __( 'This is the first widget in the footer, it is placed in the left column' , 'Grayandgold'),
			'before_widget' => '<li id="%1$s" class="widget %2$s">',
			'after_widget' => '</li>',
			'before_title' => '<h3 class="widgettitle">',
			'after_title' => '</h3>',
		)
	);

			/* Register the sidebar in the footer, position 'center'. */
	register_sidebar(
		array(
			'id' => 'footer_center',
			'name' => __( 'Footer (Center)', 'Grayandgold' ),
			'description' => __( 'This is the second  widget in the footer, it is placed in the center column' , 'Grayandgold'),
			'before_widget' => '<li id="%1$s" class="widget %2$s">',
			'after_widget' => '</li>',
			'before_title' => '<h3 class="widgettitle">',
			'after_title' => '</h3>',
		)
	);
	
			/* Register the sidebar in the footer, position 'right'. */
	register_sidebar(
		array(
			'id' => 'footer_right',
			'name' => __( 'Footer (Right side)', 'Grayandgold' ),
			'description' => __( 'This is the third widget in the footer, it is placed in the right column' , 'Grayandgold'),
			'before_widget' => '<li id="%1$s" class="widget %2$s">',
			'after_widget' => '</li>',
			'before_title' => '<h3 class="widgettitle">',
			'after_title' => '</h3>',
		)
	);
}




if (function_exists('wp_nav_menu')) {
add_action( 'init', 'Grayandgold_register_my_menus' );
function Grayandgold_register_my_menus() {
register_nav_menus(
array(
			
			'main-menu' => __( 'Main menu', 'Grayandgold'),
			'top-menu' => __( 'Top Menu', 'Grayandgold' ),
));
}
}

// Make theme available for translation
// Translations can be filed in the /languages/ directory
	load_theme_textdomain( 'Grayandgold', TEMPLATEPATH . '/languages' );
	$locale = get_locale();
	$locale_file = TEMPLATEPATH . "/languages/$locale.php";
	if ( is_readable( $locale_file ) )
		require_once( $locale_file ); 

if ( ! function_exists( 'Grayandgold_comment' ) ) :
/*Comment function */
function Grayandgold_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case '' :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>">
		<div class="comment-author vcard">
			<?php echo get_avatar( $comment, 40 ); ?>
						<?php printf( __( '%s <span class="says">says:</span>', 'Grayandgold' ), sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) ); ?>
		</div><!-- .comment-author .vcard -->
		<?php if ( $comment->comment_approved == '0' ) : ?>
			<em><?php _e( 'Your comment is awaiting moderation.', 'Grayandgold' ); ?></em>
			<br />
		<?php endif; ?>

		<div class="comment-meta commentmetadata"><a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
			<?php
				/* translators: 1: date, 2: time */
				printf( __( '%1$s at %2$s', 'Grayandgold' ), get_comment_date(),  get_comment_time() ); ?></a><?php edit_comment_link( __( 'Edit', 'Grayandgold' ), ' ' );
			?>
		</div><!-- .comment-meta .commentmetadata -->

		<div class="comment-body"><?php comment_text(); ?></div>

		<div class="reply">
			<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'title_reply' => 'Leave a comment',  'reply_text' => __('Reply','Grayandgold'), 'max_depth' => $args['max_depth'] ) ) ); ?>
            
            
		</div><!-- .reply -->
	</div><!-- #comment-##  -->

	<?php
			break;
		case 'pingback'  :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', 'Grayandgold' ); ?> <?php comment_author_link(); ?> <?php edit_post_link(__('Edit', 'Grayandgold' )); ?></p>
	<?php
			break;
	endswitch;
	
}
endif;

if(function_exists('add_theme_support')) {
    add_theme_support('automatic-feed-links');
    add_theme_support('post-thumbnails');
	add_editor_style();

}

define('HEADER_TEXTCOLOR', 'f6aa16');//  Default text color
define('HEADER_IMAGE', '%s/design/header.png');  // %s is theme dir uri, set a default image
define('HEADER_IMAGE_HEIGHT', 170);  // Same for height
define('HEADER_IMAGE_WIDTH', 1600); //  Default image width is actually the div's width

function header_style() {
?>
<style type="text/css">
<?php if ( 'blank' == get_header_textcolor() ) { ?>
#titel {
display: none;
}
#titel { display: none; }
<?php } else { ?>
#titel {
	float: left;
	padding: 0px 0 0 0px;
	color: #FFF;
	width: 855px;
	height:134px;
}
<?php } ?>

#header{
background: url(<?php header_image() ?>) repeat-x;
/*height: <?php echo HEADER_IMAGE_HEIGHT; ?>px;*/
height: 170px;
margin: 0 0;
padding: 0 0;
background-color: #353530;
}
</style>
<?php
}
function admin_header_style() {
?>
<style type="text/css">
#headimg{
background: url(<?php header_image() ?>) repeat-x;
height: <?php echo HEADER_IMAGE_HEIGHT; ?>px;
width:<?php echo HEADER_IMAGE_WIDTH; ?>px;
padding:0 0 0 18px;
}

#headimg h1{
padding-top:40px;
margin: 0;
}
#headimg h1 a{
color:#<?php header_textcolor() ?>;
text-decoration: none;
border-bottom: none;
}
#headimg #desc{
color:#<?php header_textcolor() ?>;
font-size:1em;
margin-top:-0.5em;
}

#desc {
display: none;
}

<?php if ( 'blank' == get_header_textcolor() ) { ?>
#headimg h1, #headimg #desc {
display: none;
}
#headimg h1 a, #headimg #desc {
color:#<?php echo HEADER_TEXTCOLOR ?>;
}
<?php } ?>


</style>
<?php
}
add_custom_image_header('header_style', 'admin_header_style');
add_custom_background();

?>
<?php


function Grayandgold_admin_enqueue_scripts( $hook_suffix ) {
	wp_enqueue_style( 'Grayandgold-theme-options', get_template_directory_uri() . '/inc/theme-options.css', false, '2011-04-28' );

	wp_enqueue_style( 'farbtastic' );
}
add_action( 'admin_print_styles-appearance_page_theme_options', 'Grayandgold_admin_enqueue_scripts' );

/**
 * Register the form setting for our Grayandgold_options array.
 *
 * This function is attached to the admin_init action hook.
 *
 * This call to register_setting() registers a validation callback, Grayandgold_theme_options_validate(),
 * which is used when the option is saved, to ensure that our option values are complete, properly
 * formatted, and safe.
 *
 * We also use this function to add our theme option if it doesn't already exist.
 *
 */
function Grayandgold_theme_options_init() {

	// If we have no options in the database, let's add them now.
	if ( false === Grayandgold_get_theme_options() )
		add_option( 'Grayandgold_theme_options', Grayandgold_get_default_theme_options() );

	register_setting(
		'Grayandgold_options',       // Options group, see settings_fields() call in theme_options_render_page()
		'Grayandgold_theme_options', // Database option, see Grayandgold_get_theme_options()
		'Grayandgold_theme_options_validate' // The sanitization callback, see Grayandgold_theme_options_validate()
	);
}
add_action( 'admin_init', 'Grayandgold_theme_options_init' );

/**
 * Change the capability required to save the 'Grayandgold_options' options group.
 *
 * @see Grayandgold_theme_options_init() First parameter to register_setting() is the name of the options group.
 * @see Grayandgold_theme_options_add_page() The edit_theme_options capability is used for viewing the page.
 *
 * By default, the options groups for all registered settings require the manage_options capability.
 * This filter is required to change our theme options page to edit_theme_options instead.
 * By default, only administrators have either of these capabilities, but the desire here is
 * to allow for finer-grained control for roles and users.
 *
 * @param string $capability The capability used for the page, which is manage_options by default.
 * @return string The capability to actually use.
 */
function Grayandgold_option_page_capability( $capability ) {
	return 'edit_theme_options';
}
add_filter( 'option_page_capability_Grayandgold_options', 'Grayandgold_option_page_capability' );

/**
 * Add our theme options page to the admin menu, including some help documentation.
 *
 * This function is attached to the admin_menu action hook.
 *
 */
function Grayandgold_theme_options_add_page() {
	$theme_page = add_theme_page(
		__( 'Theme Options', 'Grayandgold' ),   // Name of page
		__( 'Theme Options', 'Grayandgold' ),   // Label in menu
		'edit_theme_options',                    // Capability required
		'theme_options',                         // Menu slug, used to uniquely identify the page
		'Grayandgold_theme_options_render_page' // Function that renders the options page
	);


}
add_action( 'admin_menu', 'Grayandgold_theme_options_add_page' );

/**
 * Returns an array of color schemes registered for Grayandgold.
 *
 */
function Grayandgold_color_schemes() {
	$color_scheme_options = array(
		'Grayandgold' => array(
			'value' => 'Grayandgold',
			'label' => __( 'Optimized for 1024*678', 'Grayandgold' ),
			'thumbnail' => get_template_directory_uri() . '/design/small.png'
		),
		'Grayandgold-wide' => array(
			'value' => 'Grayandgold-wide',
			'label' => __( 'Optimized for > 1024*678', 'Grayandgold' ),
			'thumbnail' => get_template_directory_uri() . '/design/large.png',
			'default_link_color' => '#e4741f',
		),

	);

	return apply_filters( 'Grayandgold_color_schemes', $color_scheme_options );
}


function Grayandgold_get_default_theme_options() {
	$default_theme_options = array(
		'color_scheme' => 'Grayandgold',
		'link_color'   => Grayandgold_get_default_link_color( 'Grayandgold' ),
		'theme_layout' => 'content-sidebar',
	);

	

	return apply_filters( 'Grayandgold_default_theme_options', $default_theme_options );
}

/**
 *
 * @param $string $color_scheme Color scheme. Defaults to the active color scheme.
 * @return $string Color.
*/
function Grayandgold_get_default_link_color( $color_scheme = null ) {
	if ( null === $color_scheme ) {
		$options = Grayandgold_get_theme_options();
		$color_scheme = $options['color_scheme'];
	}

	$color_schemes = Grayandgold_color_schemes();
	if ( ! isset( $color_schemes[ $color_scheme ] ) )
		return false;

	
}

/**
 * Returns the options array for Grayandgold.
 *
 */
function Grayandgold_get_theme_options() {
	return get_option( 'Grayandgold_theme_options', Grayandgold_get_default_theme_options() );
}

function Grayandgold_theme_options_render_page() {
	?>
	<div class="wrap">

	<div class="sidebar-name">
<div class="sidebar-name">
<h2><?php _e( 'Available Stylesheets', 'Grayandgold' ); ?></h2>
</div></div>
<div class="postbox">
<div class="inside">
		<?php screen_icon(); ?>
		<h2><?php printf( __( '%s Theme Options', 'Grayandgold' ), get_current_theme() ); ?></h2>
		<?php settings_errors(); ?>

		<form method="post" action="options.php">
			<?php
				settings_fields( 'Grayandgold_options' );
				$options = Grayandgold_get_theme_options();
				$default_options = Grayandgold_get_default_theme_options();
			?><br />

With the Gray and Gold theme you have two options, for different size on the webpage.<br />
The narrow version is optimized for 1024*678 and equal screen resolution.<br />
The wide version is for screen resolutions that a higher than 1024*768, with this version you can add the 728*90 ad from Google adsense and a 250*250 ad in the sidebar.
			<table class="form-table">

				<tr valign="top" class="image-radio-option color-scheme"><th scope="row"><?php _e( 'Color Scheme', 'Grayandgold' ); ?></th>
					<td>
						<fieldset><legend class="screen-reader-text"><span><?php _e( 'Color Scheme', 'Grayandgold' ); ?></span></legend>
						<?php
							foreach ( Grayandgold_color_schemes() as $scheme ) {
								?>
								<div class="layout">
								<label class="description">
									<input type="radio" name="Grayandgold_theme_options[color_scheme]" value="<?php echo esc_attr( $scheme['value'] ); ?>" <?php checked( $options['color_scheme'], $scheme['value'] ); ?> />

									<span>
										<img src="<?php echo esc_url( $scheme['thumbnail'] ); ?>" width="256" height="252" alt="" />
										<?php echo $scheme['label']; ?>
									</span>
								</label>
								</div>
								<?php
							}
						?>
						</fieldset>
					</td>
				</tr>
			</table><?php submit_button(); ?>

			
		</form>
	</div></div></div>
	<?php
}

/**
 * Sanitize and validate form input. Accepts an array, return a sanitized array.
 *
 * @see Grayandgold_theme_options_init()
 * @todo set up Reset Options action
 *
 */
function Grayandgold_theme_options_validate( $input ) {
	$output = $defaults = Grayandgold_get_default_theme_options();

	// Color scheme must be in our array of color scheme options
	if ( isset( $input['color_scheme'] ) && array_key_exists( $input['color_scheme'], Grayandgold_color_schemes() ) )
		$output['color_scheme'] = $input['color_scheme'];

	return apply_filters( 'Grayandgold_theme_options_validate', $output, $input, $defaults );
}

/**
 * Enqueue the styles for the current color scheme.
 *
 */
function Grayandgold_enqueue_color_scheme() {
	$options = Grayandgold_get_theme_options();
	$color_scheme = $options['color_scheme'];

	if ( 'Grayandgold-wide' == $color_scheme )
		wp_enqueue_style( 'Grayandgold-wide', get_template_directory_uri() . '/style-wide.css', array(), null );

	do_action( 'Grayandgold_enqueue_color_scheme', $color_scheme );
}
add_action( 'wp_enqueue_scripts', 'Grayandgold_enqueue_color_scheme' );




