<?php
/**
 * Theme functions and definitions
 *
 * @package grandmart_consultant
 */ 


if ( ! function_exists( 'grandmart_consultant_enqueue_styles' ) ) :
	/**
	 * Load assets.
	 *
	 * @since 1.0.0
	 */
	function grandmart_consultant_enqueue_styles() {
		wp_enqueue_style( 'grandmart-style-parent', get_template_directory_uri() . '/style.css' );
		wp_enqueue_style( 'grandfurnish-style', get_stylesheet_directory_uri() . '/style.css', array( 'grandmart-style-parent' ), '' );
	}
endif;
add_action( 'wp_enqueue_scripts', 'grandmart_consultant_enqueue_styles', 99 );

function grandmart_consultant_remove_action() {
	remove_action( 'grandmart_header_start_action', 'grandmart_header_start', 10 );
}
add_action( 'init', 'grandmart_consultant_remove_action');

if ( ! function_exists( 'grandmart_consultant_theme_defaults' ) ) :
    /**
     * Customize theme defaults.
     *
     * @since 1.0.0
     *
     * @param array $defaults Theme defaults.
     * @param array Custom theme defaults.
     */
    function grandmart_consultant_theme_defaults( $defaults ) {
        $defaults['enable_slider'] = false;
        $defaults['enable_loader'] = false;
        $defaults['service_width'] = 'container-width';

        return $defaults;
    }
endif;
add_filter( 'grandmart_default_theme_options', 'grandmart_consultant_theme_defaults', 99 );

if ( ! function_exists( 'grandmart_consultant_header_start' ) ) :
	/**
	 * Header starts html codes
	 *
	 * @since Mik 1.0.0
	 */
	function grandmart_consultant_header_start() { 
		?>
		<header id="masthead" class="site-header left-align">
		<div class="wrapper">
	<?php }
endif;
add_action( 'grandmart_header_start_action', 'grandmart_consultant_header_start', 10 );


/**
* Start service section
*
* @return string service content
* @since GrandMart 1.0.0
*
*/
function grandmart_render_service_section( $content_details = array() ) {
    if ( empty( $content_details ) )
        return;

    $service_width = grandmart_theme_option( 'service_width', 'full-width' );

    ?>
    <div class="our-services page-section relative <?php echo esc_attr(  $service_width ); ?>">
        <div class="<?php echo 'container-width' == $service_width ? 'wrapper' : ''; ?>">
            <div class="section-content column-3">
                <?php foreach ( $content_details as $content ) : ?>
                    <article class="hentry grid-item">
                        <div class="post-wrapper <?php echo esc_attr( $content['layout'] ); ?>">
                            <?php if ( ! empty( $content['image'] ) ) : ?>
                                <div class="featured-image">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>">
                                        <img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>">
                                    </a>
                                </div><!-- .featured-image -->
                            <?php endif; ?>

                            <div class="entry-container">
                                <header class="entry-header">
                                    <?php if ( ! empty( $content['sub_title'] ) ) : ?>
                                        <p class="subtitle"><?php echo grandmart_santize_allow_span( $content['sub_title'] ); ?></p>
                                    <?php endif; 

                                    if ( ! empty( $content['title'] ) ) : ?>
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    <?php endif; ?>
                                </header>
                            </div><!-- .entry-container -->

                        </div><!-- .post-wrapper -->
                    </article>
                <?php endforeach; ?>
            </div><!-- .section-content -->
        </div><!-- .wrapper -->
    </div><!-- #our-services -->
<?php 
}
