<?php
/**
 * Graceful Times Theme Posts Slider with Dynamic Background from Image Color
 */

function graceful_times_render_post_slider() {
$recent_posts = get_posts(
	array(
		'numberposts' => 4,
		'post_status' => 'publish',
	)
);

if ( empty( $recent_posts ) ) {
	return;
}
?>

<div class="times-slider-container <?php echo esc_attr( graceful_times_blog_options( 'times_slider_width' ) ) === 'wrapped' ? ' wrapped-content': ''; ?> clear-fix">
	<div style="position: relative;">
		<div class="times-slide-nav">
		<span class="times-prev">‹</span>
		<span class="times-next">›</span>
	</div>
	<div class="owl-carousel times-slider-carousel">
		<?php foreach ( $recent_posts as $index => $post ) : ?>
			<?php
			setup_postdata( $post );
			$image_url  = get_the_post_thumbnail_url( $post, 'large' );
			$categories = get_the_category( $post->ID );
			$category   = ! empty( $categories ) ? $categories[0]->name : __( 'Uncategorized', 'graceful-times-blog' );
			?>
			<div class="times-slide">
				<div class="times-slide-left">
					<div class="times-slide-left-content">
						<small><?php echo esc_html( $category ); ?></small>
						<div class="times-spacer">
							<hr/>
						</div>
						<h2>
							<a href="<?php echo esc_url( get_permalink( $post ) ); ?>">
								<?php echo esc_html( get_the_title( $post ) ); ?>
							</a>
						</h2>
						<?php if ( graceful_times_blog_options( 'times_slider_show_excerpt' ) ) : ?>
							<p><?php echo esc_html( wp_trim_words( get_the_excerpt( $post ), 20 ) ); ?></p>
						<?php endif; ?>
						<a class="times-read-button" href="<?php echo esc_url( get_permalink( $post ) ); ?>">
							<?php esc_html_e( 'Read More', 'graceful-times-blog' ); ?>
						</a>
					</div>
				</div>
				<div class="times-slide-right">
					<?php if ( $image_url ) : ?>
						<img class="times-slide-image" src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( get_the_title( $post ) ); ?>" crossorigin="anonymous">
					<?php endif; ?>
				</div>
			</div>

		<?php endforeach; ?>
		<?php wp_reset_postdata(); ?>
	</div>
	</div>
</div>

<?php
}
graceful_times_render_post_slider();