<?php
/**
 * Template part for Latest Posts below Header
 *
 * @package Graceful_Times_Blog
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$graceful_times_posts_width       = graceful_times_blog_options( 'latest_posts_width' );
$graceful_times_posts_width_class = ( 'wrapped' === $graceful_times_posts_width ) ? 'wrapped-content' : '';
?>

<section class="times-posts-section <?php echo esc_attr( $graceful_times_posts_width_class ); ?>">
	<div class="times-posts-wrapper">
		<div class="times-posts-grid">
			<?php
			$graceful_times_latest_args = array(
				'posts_per_page'      => 4,
				'post_status'         => 'publish',
				'ignore_sticky_posts' => true,
			);

			$graceful_times_latest_query = new WP_Query( $graceful_times_latest_args );

			if ( $graceful_times_latest_query->have_posts() ) :
				while ( $graceful_times_latest_query->have_posts() ) :
					$graceful_times_latest_query->the_post();

					$graceful_times_thumb_url    = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_ID(), 'large' ) : '';
					$graceful_times_cats         = get_the_category();
					$graceful_times_cat_name     = ! empty( $graceful_times_cats ) ? $graceful_times_cats[0]->name : '';
					$graceful_times_show_cat     = graceful_times_blog_options( 'latest_posts_show_category' );
					$graceful_times_show_author  = graceful_times_blog_options( 'latest_posts_show_author' );
					$graceful_times_show_date    = graceful_times_blog_options( 'latest_posts_show_date' );
					?>

					<article <?php post_class( 'times-posts-card' ); ?>>
						<a class="times-posts-card-link" href="<?php the_permalink(); ?>" aria-label="<?php echo esc_attr( get_the_title() ); ?>">
							<div class="times-posts-card-image"<?php if ( $graceful_times_thumb_url ) : ?> style="background-image: url('<?php echo esc_url( $graceful_times_thumb_url ); ?>');"<?php endif; ?>>
								<?php if ( ! $graceful_times_thumb_url ) : ?>
									<span class="times-posts-thumb--placeholder"></span>
								<?php endif; ?>
							</div>
							<div class="times-posts-card-overlay">
								<?php if ( $graceful_times_show_cat && $graceful_times_cat_name ) : ?>
									<span class="times-posts-kicker"><?php echo esc_html( $graceful_times_cat_name ); ?></span>
								<?php endif; ?>
								<h2 class="times-posts-title"><?php echo esc_html( get_the_title() ); ?></h2>
								<?php if ( $graceful_times_show_author || $graceful_times_show_date ) : ?>
									<div class="times-posts-meta">
										<?php if ( $graceful_times_show_author ) : ?>
											<span class="times-posts-author"><?php echo esc_html__( 'By', 'graceful-times-blog' ); ?> <?php echo esc_html( get_the_author() ); ?></span>
										<?php endif; ?>
										<?php if ( $graceful_times_show_author && $graceful_times_show_date ) : ?>
											<span class="times-posts-separator">•</span>
										<?php endif; ?>
										<?php if ( $graceful_times_show_date ) : ?>
											<span class="times-posts-date"><?php echo esc_html( get_the_date() ); ?></span>
										<?php endif; ?>
									</div>
								<?php endif; ?>
							</div>
						</a>
					</article>

				<?php endwhile; ?>
				<?php wp_reset_postdata(); ?>
			<?php endif; ?>
		</div>
	</div>
</section>
