<?php
/**
 * Template part for Featured Categories Section
 *
 * @package Graceful_Times_Blog
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$graceful_times_featured_cat_width       = graceful_times_blog_options( 'featured_categories_width' );
$graceful_times_featured_cat_width_class = ( 'wrapped' === $graceful_times_featured_cat_width ) ? 'wrapped-content' : '';
?>

<section class="graceful-times-featured-categories <?php echo esc_attr( $graceful_times_featured_cat_width_class ); ?>">
	<div class="graceful-times-featured-categories-wrapper">
		<div class="graceful-times-featured-categories-grid">
			<?php
			for ( $i = 1; $i <= 4; $i++ ) {
				$graceful_times_cat_id    = graceful_times_blog_options( 'featured_category_' . $i );
				$graceful_times_cat_image = graceful_times_blog_options( 'featured_category_image_' . $i );

				if ( $graceful_times_cat_id && $graceful_times_cat_id !== 'null' ) {
					$graceful_times_category = get_category( $graceful_times_cat_id );

					if ( $graceful_times_category && ! is_wp_error( $graceful_times_category ) ) {
						$graceful_times_cat_link  = get_category_link( $graceful_times_cat_id );
						$graceful_times_cat_name  = $graceful_times_category->name;
						$graceful_times_image_url = '';

						if ( $graceful_times_cat_image ) {
							$graceful_times_image_url = wp_get_attachment_image_url( $graceful_times_cat_image, 'large' );
						}
						?>
						<div class="graceful-times-featured-cat-item">
							<a href="<?php echo esc_url( $graceful_times_cat_link ); ?>" class="graceful-times-featured-cat-link">
								<div class="graceful-times-featured-cat-image" <?php if ( $graceful_times_image_url ) : ?>style="background-image: url('<?php echo esc_url( $graceful_times_image_url ); ?>');"<?php endif; ?>>
									<?php if ( ! $graceful_times_image_url ) : ?>
										<span class="graceful-times-featured-cat-placeholder"></span>
									<?php endif; ?>
								</div>
								<div class="graceful-times-featured-cat-overlay">
									<h3 class="graceful-times-featured-cat-name"><?php echo esc_html( strtoupper( $graceful_times_cat_name ) ); ?></h3>
								</div>
							</a>
						</div>
						<?php
					}
				}
			}
			?>
		</div>
	</div>
</section>
