<?php
/**
 * Graceful Times Blog functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Graceful Times Blog
 */

// ----------------------------------------------------------------------------------
//  Register Front-End Styles And Scripts
// ----------------------------------------------------------------------------------

function graceful_times_blog_enqueue_child_assets() {

    // Parent theme style
    wp_enqueue_style(
        'graceful-style',
        get_template_directory_uri() . '/style.css'
    );

    // Child theme style
    wp_enqueue_style(
        'graceful-times-blog-style',
        get_stylesheet_directory_uri() . '/style.css',
        array( 'graceful-style' ),
        wp_get_theme()->get( 'Version' )
    );

    // Child theme custom JS
    wp_enqueue_script(
        'graceful-times-blog-main', // Handle name
        get_stylesheet_directory_uri() . '/assets/js/times-slider.js',
        array( 'jquery' ), // Dependencies
        wp_get_theme()->get( 'Version' ),
        false // Load in footer
    );

    // Vendor: Color Thief
    wp_enqueue_script(
        'graceful-elite-color-thief',
        get_stylesheet_directory_uri() . '/assets/js/vendors/color-thief/color-thief.min.js',
        array(),
        '2.6.0',
        true
    );
}
add_action( 'wp_enqueue_scripts', 'graceful_times_blog_enqueue_child_assets' );

// ----------------------------------------------------------------------------------
//  Override Parent Theme Defaults
// ----------------------------------------------------------------------------------

/**
 * Override parent theme header width default to full width
 *
 * @param array $defaults Parent theme default options.
 * @return array Modified defaults.
 */
function graceful_times_blog_override_parent_defaults( $defaults ) {
	if ( isset( $defaults['basic_header_width'] ) ) {
		$defaults['basic_header_width'] = 'full';
	}
	return $defaults;
}
add_filter( 'option_graceful_options', 'graceful_times_blog_override_parent_defaults', 10 );

/**
 * Set header width to full on theme activation
 */
function graceful_times_blog_set_header_width() {
	$graceful_times_parent_options = get_option( 'graceful_options', array() );
	
	if ( ! isset( $graceful_times_parent_options['basic_header_width'] ) || 'contained' === $graceful_times_parent_options['basic_header_width'] ) {
		$graceful_times_parent_options['basic_header_width'] = 'full';
		update_option( 'graceful_options', $graceful_times_parent_options );
	}
}
add_action( 'after_switch_theme', 'graceful_times_blog_set_header_width' );

// Load after Theme Setup
function graceful_times_blog_theme_setup() {

    // ----------------------------------------------------------------------------------
    //  Register New Sections in Customizer
    // ----------------------------------------------------------------------------------
    function graceful_times_blog_customize_register( $wp_customize ) {

        /*** Times Latest Posts ***/
        // Times Posts section
        $wp_customize->add_section( 'graceful_times_latest_posts' , array(
            'title'      => esc_html__( 'Times Latest Posts', 'graceful-times-blog' ),
            'priority'   => 26,
            'capability' => 'edit_theme_options'
        ) );

        // Times Posts Enable
        $wp_customize->add_setting( 'graceful_times_blog_options[latest_posts_show]', array(
            'default'    => graceful_times_blog_options( 'latest_posts_show' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_checkboxes'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[latest_posts_show]', array(
            'label'     => esc_html__( 'Enable Latest Posts', 'graceful-times-blog' ),
            'section'   => 'graceful_times_latest_posts',
            'type'      => 'checkbox',
            'priority'  => 1
        ) );

        // Times Latest Posts Width
        $graceful_times_latest_posts_width_choices = array(
            'full'    => esc_html__( 'Full Width', 'graceful-times-blog' ),
            'wrapped' => esc_html__( 'Boxed', 'graceful-times-blog' ),
        );

        $wp_customize->add_setting( 'graceful_times_blog_options[latest_posts_width]', array(
            'default'           => graceful_times_blog_options( 'latest_posts_width' ),
            'type'              => 'option',
            'transport'         => 'refresh',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_select'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[latest_posts_width]', array(
            'label'    => esc_html__( 'Section Width', 'graceful-times-blog' ),
            'section'  => 'graceful_times_latest_posts',
            'type'     => 'select',
            'choices'  => $graceful_times_latest_posts_width_choices,
            'priority' => 2
        ) );

        // Show Category
        $wp_customize->add_setting( 'graceful_times_blog_options[latest_posts_show_category]', array(
            'default'           => graceful_times_blog_options( 'latest_posts_show_category' ),
            'type'              => 'option',
            'transport'         => 'refresh',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_checkboxes'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[latest_posts_show_category]', array(
            'label'    => esc_html__( 'Show Category', 'graceful-times-blog' ),
            'section'  => 'graceful_times_latest_posts',
            'type'     => 'checkbox',
            'priority' => 3
        ) );

        // Show Author
        $wp_customize->add_setting( 'graceful_times_blog_options[latest_posts_show_author]', array(
            'default'           => graceful_times_blog_options( 'latest_posts_show_author' ),
            'type'              => 'option',
            'transport'         => 'refresh',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_checkboxes'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[latest_posts_show_author]', array(
            'label'    => esc_html__( 'Show Author', 'graceful-times-blog' ),
            'section'  => 'graceful_times_latest_posts',
            'type'     => 'checkbox',
            'priority' => 4
        ) );

        // Show Date
        $wp_customize->add_setting( 'graceful_times_blog_options[latest_posts_show_date]', array(
            'default'           => graceful_times_blog_options( 'latest_posts_show_date' ),
            'type'              => 'option',
            'transport'         => 'refresh',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_checkboxes'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[latest_posts_show_date]', array(
            'label'    => esc_html__( 'Show Date', 'graceful-times-blog' ),
            'section'  => 'graceful_times_latest_posts',
            'type'     => 'checkbox',
            'priority' => 5
        ) );


        /*** Featured Categories ***/
        // Featured Categories section
        $wp_customize->add_section( 'graceful_times_featured_categories' , array(
            'title'      => esc_html__( 'Times Featured Categories', 'graceful-times-blog' ),
            'priority'   => 27,
            'capability' => 'edit_theme_options'
        ) );

        // Enable Featured Categories
        $wp_customize->add_setting( 'graceful_times_blog_options[featured_categories_show]', array(
            'default'           => graceful_times_blog_options( 'featured_categories_show' ),
            'type'              => 'option',
            'transport'         => 'refresh',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_checkboxes'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[featured_categories_show]', array(
            'label'    => esc_html__( 'Enable Featured Categories', 'graceful-times-blog' ),
            'section'  => 'graceful_times_featured_categories',
            'type'     => 'checkbox',
            'priority' => 1
        ) );

        // Featured Categories Width
        $graceful_times_featured_cat_width_choices = array(
            'full'    => esc_html__( 'Full Width', 'graceful-times-blog' ),
            'wrapped' => esc_html__( 'Boxed', 'graceful-times-blog' ),
        );

        $wp_customize->add_setting( 'graceful_times_blog_options[featured_categories_width]', array(
            'default'           => graceful_times_blog_options( 'featured_categories_width' ),
            'type'              => 'option',
            'transport'         => 'refresh',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_select'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[featured_categories_width]', array(
            'label'    => esc_html__( 'Section Width', 'graceful-times-blog' ),
            'section'  => 'graceful_times_featured_categories',
            'type'     => 'select',
            'choices'  => $graceful_times_featured_cat_width_choices,
            'priority' => 2
        ) );

        // Background Color
        $wp_customize->add_setting( 'graceful_times_blog_options[featured_categories_bg_color]', array(
            'default'           => graceful_times_blog_options( 'featured_categories_bg_color' ),
            'type'              => 'option',
            'transport'         => 'refresh',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color'
        ) );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'graceful_times_blog_options[featured_categories_bg_color]', array(
            'label'    => esc_html__( 'Background Color', 'graceful-times-blog' ),
            'section'  => 'graceful_times_featured_categories',
            'priority' => 3
        ) ) );

        // Get all categories for dropdown
        $graceful_times_categories = get_categories( array( 'hide_empty' => false ) );
        $graceful_times_cat_choices = array( 'null' => esc_html__( '-- Select Category --', 'graceful-times-blog' ) );
        foreach ( $graceful_times_categories as $graceful_times_cat ) {
            $graceful_times_cat_choices[ $graceful_times_cat->term_id ] = $graceful_times_cat->name;
        }

        // Category 1
        $wp_customize->add_setting( 'graceful_times_blog_options[featured_category_1]', array(
            'default'           => graceful_times_blog_options( 'featured_category_1' ),
            'type'              => 'option',
            'transport'         => 'refresh',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'absint'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[featured_category_1]', array(
            'label'    => esc_html__( 'Category 1', 'graceful-times-blog' ),
            'section'  => 'graceful_times_featured_categories',
            'type'     => 'select',
            'choices'  => $graceful_times_cat_choices,
            'priority' => 4
        ) );

        $wp_customize->add_setting( 'graceful_times_blog_options[featured_category_image_1]', array(
            'default'           => '',
            'type'              => 'option',
            'transport'         => 'refresh',
            'sanitize_callback' => 'absint'
        ) );
        $wp_customize->add_control(
            new WP_Customize_Cropped_Image_Control( $wp_customize, 'graceful_times_blog_options[featured_category_image_1]', array(
                'label'      => esc_html__( 'Category 1 Image', 'graceful-times-blog' ),
                'section'    => 'graceful_times_featured_categories',
                'flex_width' => true,
                'flex_height' => true,
                'width'      => 400,
                'height'     => 300,
                'priority'   => 5
            )
        ) );

        // Category 2
        $wp_customize->add_setting( 'graceful_times_blog_options[featured_category_2]', array(
            'default'           => graceful_times_blog_options( 'featured_category_2' ),
            'type'              => 'option',
            'transport'         => 'refresh',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'absint'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[featured_category_2]', array(
            'label'    => esc_html__( 'Category 2', 'graceful-times-blog' ),
            'section'  => 'graceful_times_featured_categories',
            'type'     => 'select',
            'choices'  => $graceful_times_cat_choices,
            'priority' => 5
        ) );

        $wp_customize->add_setting( 'graceful_times_blog_options[featured_category_image_2]', array(
            'default'           => '',
            'type'              => 'option',
            'transport'         => 'refresh',
            'sanitize_callback' => 'absint'
        ) );
        $wp_customize->add_control(
            new WP_Customize_Cropped_Image_Control( $wp_customize, 'graceful_times_blog_options[featured_category_image_2]', array(
                'label'      => esc_html__( 'Category 2 Image', 'graceful-times-blog' ),
                'section'    => 'graceful_times_featured_categories',
                'flex_width' => true,
                'flex_height' => true,
                'width'      => 400,
                'height'     => 300,
                'priority'   => 6
            )
        ) );

        // Category 3
        $wp_customize->add_setting( 'graceful_times_blog_options[featured_category_3]', array(
            'default'           => graceful_times_blog_options( 'featured_category_3' ),
            'type'              => 'option',
            'transport'         => 'refresh',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'absint'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[featured_category_3]', array(
            'label'    => esc_html__( 'Category 3', 'graceful-times-blog' ),
            'section'  => 'graceful_times_featured_categories',
            'type'     => 'select',
            'choices'  => $graceful_times_cat_choices,
            'priority' => 7
        ) );

        $wp_customize->add_setting( 'graceful_times_blog_options[featured_category_image_3]', array(
            'default'           => '',
            'type'              => 'option',
            'transport'         => 'refresh',
            'sanitize_callback' => 'absint'
        ) );
        $wp_customize->add_control(
            new WP_Customize_Cropped_Image_Control( $wp_customize, 'graceful_times_blog_options[featured_category_image_3]', array(
                'label'      => esc_html__( 'Category 3 Image', 'graceful-times-blog' ),
                'section'    => 'graceful_times_featured_categories',
                'flex_width' => true,
                'flex_height' => true,
                'width'      => 400,
                'height'     => 300,
                'priority'   => 8
            )
        ) );

        // Category 4
        $wp_customize->add_setting( 'graceful_times_blog_options[featured_category_4]', array(
            'default'           => graceful_times_blog_options( 'featured_category_4' ),
            'type'              => 'option',
            'transport'         => 'refresh',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'absint'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[featured_category_4]', array(
            'label'    => esc_html__( 'Category 4', 'graceful-times-blog' ),
            'section'  => 'graceful_times_featured_categories',
            'type'     => 'select',
            'choices'  => $graceful_times_cat_choices,
            'priority' => 9
        ) );

        $wp_customize->add_setting( 'graceful_times_blog_options[featured_category_image_4]', array(
            'default'           => '',
            'type'              => 'option',
            'transport'         => 'refresh',
            'sanitize_callback' => 'absint'
        ) );
        $wp_customize->add_control(
            new WP_Customize_Cropped_Image_Control( $wp_customize, 'graceful_times_blog_options[featured_category_image_4]', array(
                'label'      => esc_html__( 'Category 4 Image', 'graceful-times-blog' ),
                'section'    => 'graceful_times_featured_categories',
                'flex_width' => true,
                'flex_height' => true,
                'width'      => 400,
                'height'     => 300,
                'priority'   => 10
            )
        ) );


        /** Times Post Slider */
        // Enable Post Slider
        $wp_customize->add_section( 'graceful_times_post_slider' , array(
            'title'      => esc_html__( 'Times Post Slider', 'graceful-times-blog' ),
            'priority'   => 26,
            'capability' => 'edit_theme_options'
        ) );

        // Enable Latest Post Section
        $wp_customize->add_setting( 'graceful_times_blog_options[times_post_slider_show]', array(
            'default'    => graceful_times_blog_options( 'times_post_slider_show' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_checkboxes'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[times_post_slider_show]', array(
            'label'     => esc_html__( 'Enable Times Post Slider', 'graceful-times-blog' ),
            'section'   => 'graceful_times_post_slider',
            'type'      => 'checkbox',
            'priority'  => 1
        ) );

        // Times Slider Layout Width
        $boxed_width_times_slider = array(
            'full' => esc_html__( 'Full', 'graceful-times-blog' ),
            'wrapped' => esc_html__( 'Boxed', 'graceful-times-blog' ),
        );

        $wp_customize->add_setting( 'graceful_times_blog_options[times_slider_width]', array(
            'default'    => graceful_times_blog_options( 'times_slider_width' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_select'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[times_slider_width]', array(
            'label'         => esc_html__( 'Times Post Slider Width', 'graceful-times-blog' ),
            'section'       => 'graceful_basic',
            'type'          => 'select',
            'choices'       => $boxed_width_times_slider,
            'priority'      => 27
        ) );

        // Show Excerpt in Times Slider
        $wp_customize->add_setting( 'graceful_times_blog_options[times_slider_show_excerpt]', array(
            'default'           => graceful_times_blog_options( 'times_slider_show_excerpt' ),
            'type'              => 'option',
            'transport'         => 'refresh',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_checkboxes'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[times_slider_show_excerpt]', array(
            'label'    => esc_html__( 'Show Excerpt in Times Slider', 'graceful-times-blog' ),
            'section'  => 'graceful_times_post_slider',
            'type'     => 'checkbox',
            'priority' => 2
        ) );


        /*** Hero Banner ***/
        // Hero Banner section
        $wp_customize->add_section( 'graceful_times_hero_banner' , array(
            'title'      => esc_html__( 'Hero Banner', 'graceful-times-blog' ),
            'priority'   => 27,
            'capability' => 'edit_theme_options'
        ) );


        // Hero Banner Enable
        $wp_customize->add_setting( 'graceful_times_blog_options[hero_banner_show]', array(
            'default'    => graceful_times_blog_options( 'hero_banner_show' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_checkboxes'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[hero_banner_show]', array(
            'label'     => esc_html__( 'Enable Hero Banner', 'graceful-times-blog' ),
            'section'   => 'graceful_times_hero_banner',
            'type'      => 'checkbox',
            'priority'  => 1
        ) );

        // Hero Banner
        $wp_customize->add_setting( 'graceful_times_blog_options[hero_banner_image_1]', array(
            'default'   => '',
            'type'      => 'option',
            'transport' => 'refresh',
            'sanitize_callback' => 'graceful_sanitize_number_absint'
        ) );
        $wp_customize->add_control(
            new WP_Customize_Cropped_Image_Control( $wp_customize, 'graceful_times_blog_options[hero_banner_image_1]', array(
                'label'         => esc_html__( 'Image', 'graceful-times-blog' ),
                'section'       => 'graceful_times_hero_banner',
                'flex_width'    => false,
                'flex_height'   => false,
                'width'         => 400,
                'height'        => 400,
                'priority'      => 15
            )
        ) );

        $wp_customize->add_setting( 'graceful_times_blog_options[hero_banner_title_1]', array(
            'default'    => graceful_times_blog_options( 'hero_banner_title_1' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_text_field'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[hero_banner_title_1]', array(
            'label'     => esc_html__( 'Title', 'graceful-times-blog' ),
            'section'   => 'graceful_times_hero_banner',
            'type'      => 'text',
            'priority'  => 17
        ) );

        $wp_customize->add_setting( 'graceful_times_blog_options[hero_banner_url_1]', array(
            'default'    => graceful_times_blog_options( 'hero_banner_url_1' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'esc_url_raw'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[hero_banner_url_1]', array(
            'label'     => esc_html__( 'Link URL', 'graceful-times-blog' ),
            'section'   => 'graceful_times_hero_banner',
            'type'      => 'text',
            'priority'  => 19
        ) );

        $wp_customize->add_setting( 'graceful_times_blog_options[hero_banner_button_color]', array(
            'default'    => graceful_times_blog_options('hero_banner_button_color'),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color'
        ) );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'graceful_times_blog_options[hero_banner_button_color]', array(
            'label'     => esc_html__( 'Button Color', 'graceful-times-blog' ),
            'section'   => 'graceful_times_hero_banner',
            'priority'  => 21
        ) ) );

        // Hero Banner Layout Width
        $boxed_width_hero_banner = array(
            'full' => esc_html__( 'Full', 'graceful-times-blog' ),
            'wrapped' => esc_html__( 'Boxed', 'graceful-times-blog' ),
        );

        $wp_customize->add_setting( 'graceful_times_blog_options[hero_banner_width]', array(
            'default'    => graceful_times_blog_options( 'hero_banner_width' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_select'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[hero_banner_width]', array(
            'label'         => esc_html__( 'Hero Banner Width', 'graceful-times-blog' ),
            'section'       => 'graceful_basic',
            'type'          => 'select',
            'choices'       => $boxed_width_hero_banner,
            'priority'      => 28
        ) );

        // Sanitize number absint
        function graceful_sanitize_number_absint( $number, $setting ) {

            // ensure $number is an absolute integer
            $number = absint( $number );

            // return default if not integer
            return ( $number ? $number : $setting->default );

        }

        // Enqueue customizer styles
        function graceful_times_customizer_css() {
            wp_enqueue_style( 'graceful-customize-style', get_theme_file_uri( '/assets/css/customize-ui.css' ) );
        }
        add_action( 'customize_controls_enqueue_scripts', 'graceful_times_customizer_css' );



        /*** Top Navigation ***/
        // add Top Navigation section
        $wp_customize->add_panel(
            'layout_settings',
            array(
                'priority'   => 20,
                'capability' => 'edit_theme_options',
                'title'      => __( 'Top Navigaion', 'graceful-times-blog' ),
            )
        );

        $wp_customize->add_section( 'graceful_top_navigation' , array(
            'title'      => esc_html__( 'Top Navigation', 'graceful-times-blog' ),
            'priority'   => 23,
            'capability' => 'edit_theme_options'
        ) );

        // Top Navigation
        $wp_customize->add_setting( 'graceful_times_blog_options[top_navigation_show]', array(
            'default'    => graceful_times_blog_options('top_navigation_show'),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_checkboxes'
        ) );
        $wp_customize->add_control( 'graceful_times_blog_options[top_navigation_show]', array(
            'label'     => esc_html__( 'Enable Top Navigation', 'graceful-times-blog' ),
            'section'   => 'graceful_top_navigation',
            'type'      => 'checkbox',
            'priority'  => 1
        ) );

        // Top Navigation Background Color
        $wp_customize->add_setting( 'graceful_times_blog_options[top_navigation_bg]', array(
            'default'    => graceful_times_blog_options('top_navigation_bg'),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color'
        ) );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'graceful_times_blog_options[top_navigation_bg]', array(
            'label'     => esc_html__( 'Top Navigation Background Color', 'graceful-times-blog' ),
            'section'   => 'graceful_top_navigation',
            'priority'  => 3
        ) ) );

        // Top Navigation Text Color
        $wp_customize->add_setting( 'graceful_times_blog_options[top_navigation_text_color]', array(
            'default'    => graceful_times_blog_options('top_navigation_text_color'),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color'
        ) );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'graceful_times_blog_options[top_navigation_text_color]', array(
            'label'     => esc_html__( 'Top Navigation Text Color', 'graceful-times-blog' ),
            'section'   => 'graceful_top_navigation',
            'priority'  => 5
        ) ) );

        //Main Navigation Background Color
        $wp_customize->add_setting( 'graceful_times_blog_options[main_navigation_bg]', array(
            'default'    => graceful_times_blog_options('main_navigation_bg'),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color'
        ) );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'graceful_times_blog_options[main_navigation_bg]', array(
            'label'     => esc_html__( 'Main Navigation Background Color', 'graceful-times-blog' ),
            'section'   => 'graceful_main_navigation',
            'priority'  => 15
        ) ) );

    }
    add_action( 'customize_register', 'graceful_times_blog_customize_register', 99 );


    register_nav_menus(
        array(
            'top'  => esc_html__( 'Top Menu', 'graceful-times-blog' ),
        )
    );

    function graceful_top_menu_fallback() {
        if ( current_user_can( 'edit_theme_options' ) ) {
            ?>
            <ul id="top-menu">
                <li>
                    <a href="<?php echo esc_url( home_url( '/wp-admin/nav-menus.php') ) ?>">
                        <?php esc_html_e( 'Set-up Top Menu', 'graceful-times-blog' ) ?>
                    </a>
                </li>
            </ul>
            <?php
        }
    }

    function graceful_times_blog_options( $controls ) {

        $graceful_times_blog_defaults = array(
            'top_navigation_show' => true,
            'top_navigation_bg' => '#ffffff',
            'top_navigation_text_color' => '#333333',
            'main_navigation_bg' => '#f9f4f1',
            'blog_grid_excerpt_length' => '50',
            'latest_posts_show' => true,
            'latest_posts_width' => 'full',
            'latest_posts_show_category' => true,
            'latest_posts_show_author' => true,
            'latest_posts_show_date' => true,
            'featured_categories_show' => false,
            'featured_categories_width' => 'full',
            'featured_categories_bg_color' => '#f9f4f1',
            'featured_category_1' => 0,
            'featured_category_image_1' => '',
            'featured_category_2' => 0,
            'featured_category_image_2' => '',
            'featured_category_3' => 0,
            'featured_category_image_3' => '',
            'featured_category_4' => 0,
            'featured_category_image_4' => '',
            'times_post_slider_show' => false,
            'times_slider_width' => 'wrapped',
            'times_slider_show_excerpt' => true,
            'hero_banner_show' => false,
            'hero_banner_window' => true,
            'hero_banner_width' => 'full',
            'hero_banner_title_1' => '',
            'hero_banner_url_1' => '',
            'hero_banner_image_1' => '',
            'hero_banner_button_color' => '#000000'
        );

        // merge defaults and options
        $graceful_times_blog_defaults = wp_parse_args( get_option( 'graceful_times_blog_options' ), $graceful_times_blog_defaults );

        // return control
        return $graceful_times_blog_defaults[ $controls ];

    }
}
add_action( 'after_setup_theme', 'graceful_times_blog_theme_setup' );

// ----------------------------------------------------------------------------------
//  New Fonts
// ----------------------------------------------------------------------------------
function graceful_times_blog_enqueue_assets()
{
    // Include the file.
    require_once get_theme_file_path('webfont-loader/wptt-webfont-loader.php');
    // Load the webfont.
    wp_enqueue_style(
        'minimalist-stories-fonts',
        wptt_get_webfont_url('https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;600&family=Playfair+Display:wght@400;700&display=auto'),
        array(),
        '1.0'
    );
}
add_action( 'wp_enqueue_scripts', 'graceful_times_blog_enqueue_assets' );

// ----------------------------------------------------------------------------------
//  Custom Excerpt Length
// ----------------------------------------------------------------------------------

/**
 * Modify excerpt length for blog listing
 *
 * @param int $length Excerpt length.
 * @return int Modified excerpt length.
 */
function graceful_times_blog_excerpt_length( $length ) {
	return 30;
}
add_filter( 'excerpt_length', 'graceful_times_blog_excerpt_length', 9999 );

/**
 * Override parent theme excerpt length option
 *
 * @param array $defaults Parent theme options.
 * @return array Modified options.
 */
function graceful_times_blog_override_excerpt_length( $defaults ) {
	if ( isset( $defaults['post_page_excerpt_length'] ) ) {
		$defaults['post_page_excerpt_length'] = '30';
	}
	if ( isset( $defaults['post_page_grid_excerpt_length'] ) ) {
		$defaults['post_page_grid_excerpt_length'] = '30';
	}
	return $defaults;
}
add_filter( 'option_graceful_options', 'graceful_times_blog_override_excerpt_length', 20 );

// ----------------------------------------------------------------------------------
//  Dynamic Inline Styles
// ----------------------------------------------------------------------------------

/**
 * Add inline styles for customizer options
 */
function graceful_times_blog_inline_styles() {
	$graceful_times_featured_cat_bg = graceful_times_blog_options( 'featured_categories_bg_color' );

	$graceful_times_custom_css = '';

	if ( $graceful_times_featured_cat_bg && '#f9f4f1' !== $graceful_times_featured_cat_bg ) {
		$graceful_times_custom_css .= '.graceful-times-featured-categories { background: ' . esc_attr( $graceful_times_featured_cat_bg ) . '; }';
	}

	if ( ! empty( $graceful_times_custom_css ) ) {
		wp_add_inline_style( 'graceful-times-blog-style', $graceful_times_custom_css );
	}
}
add_action( 'wp_enqueue_scripts', 'graceful_times_blog_inline_styles', 20 );

// ----------------------------------------------------------------------------------
//  Include Widget Files
// ----------------------------------------------------------------------------------
require get_stylesheet_directory() . '/inc/widgets/social-media-widget.php';